/* machine.h.  Generated by configure.  */
/* machine.h.in.  Generated from configure.in by autoheader.  */
/*
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: acconfig.h,v 1.155 2007/06/10 18:11:12 mast Exp $
*/

#ifndef MACHINE_H
#define MACHINE_H

/* We must define this *always* */
#ifndef POSIX_SOURCE
#define POSIX_SOURCE
#endif

/* Get more declarations in GNU libc. */
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

/* Get more declarations from AIX libc. */
#ifndef _ALL_SOURCE
#define _ALL_SOURCE
#endif

/* Building as a library? */
/* #undef LIBPIKE */

/* Where's the master.pike file installed? */
#define DEFAULT_MASTER "NONE/pike/%d.%d.%d/lib/master.pike"

/* Define this if you want run time self tests */
/* #undef PIKE_DEBUG */

/* Define this if you want some extra (possibly verbose) run time self tests */
/* #undef PIKE_EXTRA_DEBUG */

/* Define to make Pike do a full cleanup at exit to detect leaks. */
/* #undef DO_PIKE_CLEANUP */

/* Define this if you want pike to interact with valgrind. */
/* #undef USE_VALGRIND */

/* Define this if you are going to use a memory access checker (like Purify) */
/* #undef __CHECKER__ */

/* Defined if Doug Leas malloc implementation is used. */
/* #undef USE_DL_MALLOC */

/* Define this if you want malloc debugging */
/* #undef DEBUG_MALLOC */

/* Define this if you want checkpoints */
/* #undef DMALLOC_TRACE */

/* Define this if you want dmalloc to keep track of freed memory. */
/* #undef DMALLOC_TRACK_FREE */

/* With this, dmalloc will trace malloc(3) calls */
/* #undef ENCAPSULATE_MALLOC */

/* With this, dmalloc will report leaks made by malloc(3) calls */
/* #undef REPORT_ENCAPSULATED_MALLOC */

/* Define this to enable the internal Pike security system */
/* #undef PIKE_SECURITY */

/* Define this to enable experimental facets support */
/* #undef WITH_FACETS */

/* Define this to enable the internal bignum conversion */
#define AUTO_BIGNUM 1

/* Define this to enable experimental code for multicpu machines */
/* #undef PIKE_RUN_UNLOCKED */

/* Define this if you want to enable the shared nodes mode of the optimizer. */
#define SHARED_NODES 1

/* Define this if you want to enable the new type checker code. */
/* #undef NEW_ARG_CHECK */

/* Define this to use the new keypair loop. */
/* #undef PIKE_MAPPING_KEYPAIR_LOOP */

/* Define this to get portable dumped bytecode. */
#define PIKE_PORTABLE_BYTECODE 1

/* Enable profiling */
/* #undef PROFILING */

/* Enable internal profiling */
/* #undef INTERNAL_PROFILING */

/* If possible, the expansion for a "#define short" to avoid that bison
 * uses short everywhere internally. */
#define BISON_SHORT_EXPANSION int

/* The following USE_* are used by smartlink */
/* Define this if your ld sets the run path with -rpath */
/* #undef USE_RPATH */

/* Define this if your ld sets the run path with -R */
/* #undef USE_R */

/* Define this if your ld sets the run path with -YP, */
/* #undef USE_YP_ */

/* Define this if your ld sets the run path with +b */
/* #undef USE_PLUS_b */

/* Define this if your ld uses -rpath, but your cc wants -Wl,-rpath, */
/* #undef USE_Wl */

/* Define this if your ld uses -R, but your cc wants -Wl,-R */
/* #undef USE_Wl_R */

/* Define this if your ld uses -rpath, but your cc -Qoption,ld,-rpath (icc) */
/* #undef USE_Qoption */

/* Define this if your ld uses -YP, , but your cc wants -Xlinker -YP, */
/* #undef USE_XLINKER_YP_ */

/* Define this if your ld doesn't have an option to set the run path */
/* #undef USE_LD_LIBRARY_PATH */

/* Define if your tcc supports #pragma TenDRA longlong type allow. */
/* #undef HAVE_PRAGMA_TENDRA_LONGLONG */

/* Define if your tcc supports #pragma TenDRA set longlong type : long long. */
/* #undef HAVE_PRAGMA_TENDRA_SET_LONGLONG_TYPE */

/* The worlds most stringent C compiler? */
#ifdef __TenDRA__
/* We want to be able to use 64bit arithmetic */
#ifdef HAVE_PRAGMA_TENDRA_LONGLONG
#pragma TenDRA longlong type allow
#endif /* HAVE_PRAGMA_TENDRA_LONGLONG */
#ifdef HAVE_PRAGMA_TENDRA_SET_LONGLONG_TYPE
#pragma TenDRA set longlong type : long long
#endif /* HAVE_PRAGMA_TENDRA_SET_LONGLONG_TYPE */

#ifdef _NO_LONGLONG
/* #undef _NO_LONGLONG */
#endif /* _NO_LONGLONG */
#endif /* __TenDRA__ */


/* Define this if your compiler attempts to use _chkstk, but libc contains
 * __chkstk. */
/* #undef HAVE_BROKEN_CHKSTK */

/* Define for solaris */
/* #undef SOLARIS */

/* Define if the closedir function returns void instead of int.  */
/* #undef VOID_CLOSEDIR */

/* Define to 'int' if <sys/time.h> doesn't */
/* #undef time_t */

/* Define to 'short' if <sys/types.h> doesn't */
#define pri_t short

/* Define to 'int' if <sys/types.h> doesn't */
/* #undef uid_t */

/* Define to 'int' if <sys/types.h> doesn't */
/* #undef gid_t */

/* Define to 'int' if <sys/types.h> doesn't */
/* #undef pid_t */

/* Define to 'unsigned long' if <sys/types.h> or <stddef.h> doesn't */
/* #undef size_t */

/* Define to 'long' if <sys/types.h> of <stddef.h> doesn't */
/* #undef ptrdiff_t */

/* Define to 'long' if <sys/types.h> doesn't */
/* #undef off_t */

/* Define to 'int' if <signal.h> doesn't */
/* #undef sig_atomic_t */

/* Define as the return type of signal handlers (int or void).  */
#define RETSIGTYPE void

/* define this if igonoring SIGFPE helps with core dumps */
/* #undef IGNORE_SIGFPE */

/* define if you want to use double precision floats instead of single */
/* #undef WITH_DOUBLE_PRECISION_SVALUE */

/* define if you want to use long double precision floats */
/* #undef WITH_LONG_DOUBLE_PRECISION_SVALUE */

/* define to the type of pike floats */
#define FLOAT_TYPE float

/* define to the size of pike floats */
#define SIZEOF_FLOAT_TYPE SIZEOF_FLOAT

/* force this type upon ints */
#define WITH_LONG_INT 1
/* #undef WITH_LONG_LONG_INT */
/* #undef WITH_INT_INT */

/* define to the type of pike primitive ints */
#define INT_TYPE long

/* define to the size of pike primitive ints */
#define SIZEOF_INT_TYPE SIZEOF_LONG

/* If using the C implementation of alloca, define if you know the
 * direction of stack growth for your system; otherwise it will be
 * automatically deduced at run-time.
 *	STACK_DIRECTION > 0 => grows toward higher addresses
 *	STACK_DIRECTION < 0 => grows toward lower addresses
 *	STACK_DIRECTION = 0 => direction of growth unknown
 *
 * Also used by Pike's runtime C-stack checker.
 */
#define STACK_DIRECTION -1

/* Define this to the number of KB in the initial stack,
 * currently this is 1 Mb on FreeBSD, 2Mb on Linux and
 * unlimited (undefined) everywhere else
 */
#define Pike_INITIAL_STACK_SIZE 8388608

/* If so, is it restricted to user and system time? */
/* #undef GETRUSAGE_RESTRICTED */

/* Solaris has rusage as an ioctl on procfs */
/* #undef GETRUSAGE_THROUGH_PROCFS */

/* So has True64, but no useful information in prstatus_t */
/* #undef GETRUSAGE_THROUGH_PROCFS_PRS */

/* Define if you have infnan */
/* #undef HAVE_INFNAN */

/* Define if you have _isnan */
/* #undef HAVE__ISNAN */

/* Define if you have fork */
#define HAVE_FORK 1

/* Define if you have isspace */
#define HAVE_ISSPACE 1

/* Define if you have fpsetmask */
/* #undef HAVE_FPSETMASK */

/* Define if you have fpsetround */
/* #undef HAVE_FPSETROUND */

/* Define if you have isless */
#define HAVE_ISLESS 1

/* Define if you have isunordered */
#define HAVE_ISUNORDERED 1

/* Define if you have crypt.  */
#define HAVE_CRYPT 1

/* Define if you have ualarm. */
#define HAVE_UALARM 1

/* Define if your ualarm takes two args. */
#define UALARM_TAKES_TWO_ARGS 1

/* Define if your ptrace takes four args. */
#define PTRACE_TAKES_FOUR_ARGS 1

/* Define if argument 3 to ptrace is a pointer type. */
#define PTRACE_ADDR_TYPE_IS_POINTER 1

/* Define if gettimeofday takes to arguments */
#define GETTIMEOFDAY_TAKES_TWO_ARGS 1

/* Define if realloc(NULL, SZ) works. */
#define HAVE_WORKING_REALLOC_NULL 1

/* Define if gethrvtime works (i.e. even without ptime). */
/* #undef HAVE_WORKING_GETHRVTIME */

/* Define if you have gethrtime */
/* #undef HAVE_GETHRTIME */

/* Can we make our own gethrtime? */
/* #undef OWN_GETHRTIME */

/* ... by using the RDTSC instruction? */
/* #undef OWN_GETHRTIME_RDTSC */

/* Define if you have a working, 8-bit-clean memcmp */
#define HAVE_MEMCMP 1

/* Define if it is possible to allocate PROT_EXEC memory with mmap */
#define MEXEC_USES_MMAP 1

/* Define if you have gethostname */
#define HAVE_GETHOSTNAME 1

/* Define if you have memmove.  */
#ifndef __CHECKER__
#define HAVE_MEMMOVE 1
#endif

/* Define if you have memmem.  */
/* #undef HAVE_MEMMEM */

/* Define if you have memset.  */
#define HAVE_MEMSET 1

/* Define if you have memcpy.  */
#define HAVE_MEMCPY 1

/* Define if you have strcoll */
#define HAVE_STRCOLL 1

/* Define this if you have dlopen */
#define HAVE_DLOPEN 1

/* Define if you have ldexp.  */
#define HAVE_LDEXP 1

/* Define if you have rint.  */
#define HAVE_RINT 1

/* Define if you have frexp.  */
#define HAVE_FREXP 1

/* Define if your signals are one-shot */
/* #undef SIGNAL_ONESHOT */

/* Define this if eval_instruction gets large on your platform. */
/* #undef PIKE_SMALL_EVAL_INSTRUCTION */

/* Define if you have gcc-style computed goto, and want to use them. */
/* #undef HAVE_COMPUTED_GOTO */

/* Define this to use machine code */
#define PIKE_USE_MACHINE_CODE 1

/* Define this to one of the available bytecode methods. */
#define PIKE_BYTECODE_METHOD PIKE_BYTECODE_PPC32

/* You have gcc-type function attributes? */
#define HAVE_FUNCTION_ATTRIBUTES 1

/* You have cl-type __declspec? */
/* #undef HAVE_DECLSPEC */

/* Your va_list is a state pointer? */
/* #undef VA_LIST_IS_STATE_PTR */

/* Does your compiler grock 'volatile' */
#define VOLATILE volatile

/* Define to empty if your compiler doesn't support C99's restrict keyword. */
#define restrict /* Not supported */

/* Define this if your compiler doesn't allow cast of void * to function pointer */
/* #undef NO_CAST_TO_FUN */

/* How to extract a char and an unsigned char from a char * */
#define EXTRACT_CHAR_BY_CAST 1
#define EXTRACT_UCHAR_BY_CAST 1

/* Do you have IEEE floats and/or doubles (either big or little endian) ? */
#define FLOAT_IS_IEEE_BIG 1
/* #undef FLOAT_IS_IEEE_LITTLE */
#define DOUBLE_IS_IEEE_BIG 1
/* #undef DOUBLE_IS_IEEE_LITTLE */

/* Define this if strtol exists, and doesn't cut at 0x7fffffff */
/* #undef HAVE_WORKING_STRTOL */

/* The rest of this file is just to eliminate warnings */

/* define if declaration of strchr is missing */
/* #undef STRCHR_DECL_MISSING */

/* define if declaration of malloc is missing */
/* #undef MALLOC_DECL_MISSING */

/* define if declaration of getpeername is missing */
/* #undef GETPEERNAME_DECL_MISSING */

/* define if declaration of gethostname is missing */
/* #undef GETHOSTNAME_DECL_MISSING */

/* define if declaration of popen is missing */
/* #undef POPEN_DECL_MISSING */

/* define if declaration of getenv is missing */
/* #undef GETENV_DECL_MISSING */

/* define if you are using crypt.c. */
/* #undef USE_CRYPT_C */

/* Define if we can declare 'extern char **environ' */
#define DECLARE_ENVIRON 1

/* The byteorder your machine use, most use 4321, PC use 1234 */
#define PIKE_BYTEORDER 4321

/* What alignment do pointers need */
#define PIKE_POINTER_ALIGNMENT 4

/* Assembler prefix for general purpose registers */
#define PIKE_CPU_REG_PREFIX "r"

/* Number of possible filedesriptors */
#define MAX_OPEN_FILEDESCRIPTORS 2097152

/* define this if #include <time.h> provides an external int timezone */
/* #undef HAVE_EXTERNAL_TIMEZONE */

/* define this if your struct tm has a tm_gmtoff */
#define STRUCT_TM_HAS_GMTOFF 1

/* define this if your struct tm has a __tm_gmtoff */
/* #undef STRUCT_TM_HAS___TM_GMTOFF */

/* Define if you have struct timeval */
#define HAVE_STRUCT_TIMEVAL 1

/* Define if you have struct sockaddr_in6 */
#define HAVE_STRUCT_SOCKADDR_IN6 1

/* Define this to the max value of an unsigned short unless <limits.h> does.. */
/* #undef USHRT_MAX */

/* Define these if you are going to use threads */
#define PIKE_THREADS 1
#define _REENTRANT 1
#define _THREAD_SAFE 1

/* Define this if you want the UNIX taste of threads */
/* #undef _UNIX_THREADS */

/* Define this if you want the POSIX taste of threads */
#define _MIT_POSIX_THREADS 1

/* Define this if you want the SGI sproc taste of threads */
/* #undef _SGI_SPROC_THREADS */
/* #undef _SGI_MP_SOURCE */

/* Define this if you have Windows NT threads */
/* #undef NT_THREADS */

/* Use DDLs for dynamically linked modules on NT. */
/* #undef USE_DLL */

/* Define this if your THREAD_T type is a pointer type. */
/* #undef PIKE_THREAD_T_IS_POINTER */

/* Define to the flag to get an error checking mutex, if supported. */
#define PIKE_MUTEX_ERRORCHECK PTHREAD_MUTEX_ERRORCHECK

/* Define to the flag to get a recursive mutex, if supported. */
#define PIKE_MUTEX_RECURSIVE PTHREAD_MUTEX_RECURSIVE

/* Define this if your pthreads have pthread_condattr_default */
/* #undef HAVE_PTHREAD_CONDATTR_DEFAULT */

/* Define this if you need to use &pthread_condattr_default in cond_init() */
/* #undef HAVE_PTHREAD_CONDATTR_DEFAULT_AIX */

/* Define if you have the pthread_attr_setstacksize function.  */
#define HAVE_PTHREAD_ATTR_SETSTACKSIZE 1

/* Define if you have the pthread_atfork function.  */
#define HAVE_PTHREAD_ATFORK 1

/* Define if you have the pthread_cond_init function.  */
#define HAVE_PTHREAD_COND_INIT 1

/* Define if you have the pthread_yield function.  */
/* #undef HAVE_PTHREAD_YIELD */

/* Define if you have the pthread_yield_np function.  */
#define HAVE_PTHREAD_YIELD_NP 1

/* Hack for stupid glibc linuxthreads */
/* #undef HAVE_PTHREAD_INITIAL_THREAD_BOS */

/* Define if your OS has the union wait. */
/* #undef HAVE_UNION_WAIT */

/* Define if you have isgraph */
#define HAVE_ISGRAPH 1

/* Define if your cpp supports the ANSI concatenation operator ## */
#define HAVE_ANSI_CONCAT 1

/* Define if you don't have F_SETFD, or it doesn't work */
/* #undef HAVE_BROKEN_F_SETFD */

/* Define if your thread implementation doesn't propagate euid & egid. */
/* #undef HAVE_BROKEN_LINUX_THREAD_EUID */

/* Define if your cpp supports K&R-style concatenation */
/* #undef HAVE_KR_CONCAT */

/* Use poll() instead of select() ? */
/* #undef HAVE_AND_USE_POLL */

/* Enable use of /dev/epoll on Linux. */
/* #undef WITH_EPOLL */

/* Define to the poll device (eg "/dev/poll") */
/* #undef PIKE_POLL_DEVICE */

/* This works on Solaris or any UNIX where
 * waitpid can report ECHILD when running more than one at once
 * (or any UNIX where waitpid actually works)
 */
#define USE_WAIT_THREAD 1

/* This works on Linux or any UNIX where
 * waitpid works or where threads and signals bugs in
 * less annoying ways than Solaris.
 */
/* #undef USE_SIGCHILD */

/* Enable tracing of the compiler */
/* #undef YYDEBUG */

/* Define if your compiler has a symbol __func__ */
#define HAVE_WORKING___FUNC__ 1

/* Define if your compiler has a symbol __FUNCTION__ */
#define HAVE_WORKING___FUNCTION__ 1

/* The last argument to accept() is an ACCEPT_SIZE_T * */
#define ACCEPT_SIZE_T socklen_t

/* Can we compile in MMX support? */
/* #undef TRY_USE_MMX */

/* Define if you have the <sys/resource.h> header file.  */
#define HAVE_SYS_RESOURCE_H 1

/* set this to the modifier type string to print size_t, like "" or "l" */
#define PRINTSIZET "z"

/* set this to the modifier type string to print ptrdiff_t, like "" or "l" */
#define PRINTPTRDIFFT "t"

/* set this to the modifier type string to print off_t if that type exists */
#define PRINTOFFT "j"

/* set this to the modifier type string to print INT64 if that type exists */
#define PRINTINT64 "ll"

/* Define if the compiler understand union initializations. */
#define HAVE_UNION_INIT 1

/* Define when binary --disable-binary is used. */
/* #undef DISABLE_BINARY */

/* Define to the size of the overhead for a malloc'ed block. (Slightly
 * too much is better than slightly too little.) */
#define PIKE_MALLOC_OVERHEAD (2 * sizeof(void *))

/* Define to the page size (handled efficiently by malloc). */
#define PIKE_MALLOC_PAGE_SIZE (4 * 1024)

/* PIKE_YES if the number reported by fallback_get_cpu_time (rusage.c)
 * is thread local, PIKE_NO if it isn't, PIKE_UNKNOWN if it couldn't
 * be established. */
#define FB_CPU_TIME_IS_THREAD_LOCAL PIKE_NO


/* Define to one of `_getb67', `GETB67', `getb67' for Cray-2 and Cray-YMP
   systems. This function is required for `alloca.c' support on those systems.
   */
/* #undef CRAY_STACKSEG_END */

/* Define to 1 if using `alloca.c'. */
/* #undef C_ALLOCA */

/* Define to 1 if you have the `alarm' function. */
#define HAVE_ALARM 1

/* Define to 1 if you have `alloca', as a function or macro. */
#define HAVE_ALLOCA 1

/* Define to 1 if you have <alloca.h> and it should be used (not on Ultrix).
   */
#define HAVE_ALLOCA_H 1

/* Define to 1 if you have the <asm/mmx.h> header file. */
/* #undef HAVE_ASM_MMX_H */

/* Define to 1 if you have the `bcopy' function. */
#define HAVE_BCOPY 1

/* Define to 1 if you have the `bzero' function. */
#define HAVE_BZERO 1

/* Define to 1 if you have the `clock' function. */
#define HAVE_CLOCK 1

/* Define to 1 if you have the `clock_getcpuclockid' function. */
/* #undef HAVE_CLOCK_GETCPUCLOCKID */

/* Define to 1 if you have the `closefrom' function. */
/* #undef HAVE_CLOSEFROM */

/* Define to 1 if you have the <CoreServices/CoreServices.h> header file. */
#define HAVE_CORESERVICES_CORESERVICES_H 1

/* Define to 1 if you have the <crt/signal.h> header file. */
/* #undef HAVE_CRT_SIGNAL_H */

/* Define to 1 if you have the `crypt' function. */
#define HAVE_CRYPT 1

/* Define to 1 if you have the <crypt.h> header file. */
/* #undef HAVE_CRYPT_H */

/* Define to 1 if you have the <devices/timer.h> header file. */
/* #undef HAVE_DEVICES_TIMER_H */

/* Define to 1 if you have the <direct.h> header file. */
/* #undef HAVE_DIRECT_H */

/* Define to 1 if you have the `dld_get_func' function. */
/* #undef HAVE_DLD_GET_FUNC */

/* Define to 1 if you have the <dld.h> header file. */
/* #undef HAVE_DLD_H */

/* Define to 1 if you have the `dld_link' function. */
/* #undef HAVE_DLD_LINK */

/* Define to 1 if you have the <dlfcn.h> header file. */
#define HAVE_DLFCN_H 1

/* Define to 1 if you have the <dl.h> header file. */
/* #undef HAVE_DL_H */

/* Define to 1 if you have the <errno.h> header file. */
#define HAVE_ERRNO_H 1

/* Define to 1 if you have the `fchmod' function. */
#define HAVE_FCHMOD 1

/* Define to 1 if you have the <fcntl.h> header file. */
#define HAVE_FCNTL_H 1

/* Define to 1 if you have the `fdwalk' function. */
/* #undef HAVE_FDWALK */

/* Define to 1 if you have the `finite' function. */
#define HAVE_FINITE 1

/* Define to 1 if you have the <floatingpoint.h> header file. */
/* #undef HAVE_FLOATINGPOINT_H */

/* Define to 1 if you have the <float.h> header file. */
#define HAVE_FLOAT_H 1

/* Define to 1 if you have the `flock' function. */
#define HAVE_FLOCK 1

/* Define to 1 if you have the <fnord/fnord/fnord.h> header file. */
/* #undef HAVE_FNORD_FNORD_FNORD_H */

/* Define to 1 if you have the `fork1' function. */
/* #undef HAVE_FORK1 */

/* Define to 1 if you have the `fpclass' function. */
/* #undef HAVE_FPCLASS */

/* Define to 1 if you have the `fp_class_d' function. */
/* #undef HAVE_FP_CLASS_D */

/* Define to 1 if you have the <fp_class.h> header file. */
/* #undef HAVE_FP_CLASS_H */

/* Define to 1 if you have the `getegid' function. */
#define HAVE_GETEGID 1

/* Define to 1 if you have the `getenv' function. */
#define HAVE_GETENV 1

/* Define to 1 if you have the `geteuid' function. */
#define HAVE_GETEUID 1

/* Define to 1 if you have the `getgid' function. */
#define HAVE_GETGID 1

/* Define to 1 if you have the `getgrent' function. */
#define HAVE_GETGRENT 1

/* Define to 1 if you have the `getgrnam' function. */
#define HAVE_GETGRNAM 1

/* Define to 1 if you have the `gethrtime' function. */
/* #undef HAVE_GETHRTIME */

/* Define to 1 if you have the `gethrvtime' function. */
/* #undef HAVE_GETHRVTIME */

/* Define to 1 if you have the `getpagesize' function. */
#define HAVE_GETPAGESIZE 1

/* Define to 1 if you have the `getpgid' function. */
#define HAVE_GETPGID 1

/* Define to 1 if you have the `getpgrp' function. */
#define HAVE_GETPGRP 1

/* Define to 1 if you have the `getpwent' function. */
#define HAVE_GETPWENT 1

/* Define to 1 if you have the `getpwnam' function. */
#define HAVE_GETPWNAM 1

/* Define to 1 if you have the `getpwuid' function. */
#define HAVE_GETPWUID 1

/* Define to 1 if you have the `getrlimit' function. */
#define HAVE_GETRLIMIT 1

/* Define to 1 if you have the `getrusage' function. */
#define HAVE_GETRUSAGE 1

/* Define to 1 if you have the `GetSystemInfo' function. */
/* #undef HAVE_GETSYSTEMINFO */

/* Define to 1 if you have the `gettimeofday' function. */
#define HAVE_GETTIMEOFDAY 1

/* Define to 1 if you have the `getuid' function. */
#define HAVE_GETUID 1

/* Define to 1 if you have the `gmtime' function. */
#define HAVE_GMTIME 1

/* Define to 1 if you have the `gmtime_r' function. */
#define HAVE_GMTIME_R 1

/* Define to 1 if you have the `gmtime_s' function. */
/* #undef HAVE_GMTIME_S */

/* Define to 1 if you have the <gnu/stubs.h> header file. */
/* #undef HAVE_GNU_STUBS_H */

/* Define to 1 if you have the <group.h> header file. */
/* #undef HAVE_GROUP_H */

/* Define to 1 if you have the <grp.h> header file. */
#define HAVE_GRP_H 1

/* Define to 1 if you have the <ieeefp.h> header file. */
/* #undef HAVE_IEEEFP_H */

/* Define to 1 if you have the `index' function. */
#define HAVE_INDEX 1

/* Define to 1 if you have the `initgroups' function. */
#define HAVE_INITGROUPS 1

/* Define to 1 if you have the <inttypes.h> header file. */
#define HAVE_INTTYPES_H 1

/* Define to 1 if you have the <io.h> header file. */
/* #undef HAVE_IO_H */

/* Define to 1 if you have the `isinf' function. */
#define HAVE_ISINF 1

/* Define to 1 if you have the `isnan' function. */
#define HAVE_ISNAN 1

/* Define to 1 if you have the `iszero' function. */
/* #undef HAVE_ISZERO */

/* Define to 1 if you have the `kill' function. */
#define HAVE_KILL 1

/* Define to 1 if you have the `kqueue' function. */
#define HAVE_KQUEUE 1

/* Define to 1 if you have the `dl' library (-ldl). */
#define HAVE_LIBDL 1

/* Define to 1 if you have the `dld' library (-ldld). */
/* #undef HAVE_LIBDLD */

/* Define to 1 if you have the `m' library (-lm). */
#define HAVE_LIBM 1

/* Define to 1 if you have the `nsl' library (-lnsl). */
/* #undef HAVE_LIBNSL */

/* Define to 1 if you have the `poll' library (-lpoll). */
#define HAVE_LIBPOLL 1

/* Define to 1 if you have the `rt' library (-lrt). */
/* #undef HAVE_LIBRT */

/* Define to 1 if you have the `socket' library (-lsocket). */
/* #undef HAVE_LIBSOCKET */

/* Define to 1 if you have the `tdf' library (-ltdf). */
/* #undef HAVE_LIBTDF */

/* Define to 1 if you have the <limits.h> header file. */
#define HAVE_LIMITS_H 1

/* Define to 1 if you have the <locale.h> header file. */
#define HAVE_LOCALE_H 1

/* Define to 1 if you have the `localtime' function. */
#define HAVE_LOCALTIME 1

/* Define to 1 if you have the `localtime_s' function. */
/* #undef HAVE_LOCALTIME_S */

/* Define to 1 if you have the `lockf' function. */
#define HAVE_LOCKF 1

/* Define to 1 if you have the `longjmp' function. */
#define HAVE_LONGJMP 1

/* Define to 1 if you have the <mach/mach_init.h> header file. */
#define HAVE_MACH_MACH_INIT_H 1

/* Define to 1 if you have the <mach-o/dyld.h> header file. */
#define HAVE_MACH_O_DYLD_H 1

/* Define to 1 if you have the <mach/task.h> header file. */
#define HAVE_MACH_TASK_H 1

/* Define to 1 if you have the <mach/task_info.h> header file. */
#define HAVE_MACH_TASK_INFO_H 1

/* Define to 1 if you have the `MakeDataExecutable' function. */
#define HAVE_MAKEDATAEXECUTABLE 1

/* Define to 1 if you have the <malloc.h> header file. */
/* #undef HAVE_MALLOC_H */

/* Define to 1 if you have the <memcheck.h> header file. */
/* #undef HAVE_MEMCHECK_H */

/* Define to 1 if you have the `memchr' function. */
#define HAVE_MEMCHR 1

/* Define to 1 if you have the <memory.h> header file. */
#define HAVE_MEMORY_H 1

/* Define to 1 if you have the `mktime' function. */
#define HAVE_MKTIME 1

/* Define to 1 if you have a working `mmap' system call. */
#define HAVE_MMAP 1

/* Define to 1 if you have the <mmx.h> header file. */
/* #undef HAVE_MMX_H */

/* Define to 1 if you have the `munmap' function. */
#define HAVE_MUNMAP 1

/* Define to 1 if you have the `nan' function. */
#define HAVE_NAN 1

/* Define to 1 if you have the `nanosleep' function. */
#define HAVE_NANOSLEEP 1

/* Define to 1 if you have the <netinet/in.h> header file. */
#define HAVE_NETINET_IN_H 1

/* Define to 1 if you have the <net/socket.h> header file. */
/* #undef HAVE_NET_SOCKET_H */

/* Define to 1 if you have the `nice' function. */
#define HAVE_NICE 1

/* Define to 1 if you have the <passwd.h> header file. */
/* #undef HAVE_PASSWD_H */

/* Define to 1 if you have the `perror' function. */
#define HAVE_PERROR 1

/* Define to 1 if you have the `pipe' function. */
#define HAVE_PIPE 1

/* Define to 1 if you have the `poll' function. */
#define HAVE_POLL 1

/* Define to 1 if you have the <poll.h> header file. */
#define HAVE_POLL_H 1

/* Define to 1 if you have the `prctl' function. */
/* #undef HAVE_PRCTL */

/* Define to 1 if you have the <pthread.h> header file. */
#define HAVE_PTHREAD_H 1

/* Define to 1 if you have the `pthread_init' function. */
/* #undef HAVE_PTHREAD_INIT */

/* Define to 1 if you have the `pthread_kill' function. */
#define HAVE_PTHREAD_KILL 1

/* Define to 1 if you have the `pthread_mutexattr_init' function. */
#define HAVE_PTHREAD_MUTEXATTR_INIT 1

/* Define to 1 if you have the `ptrace' function. */
#define HAVE_PTRACE 1

/* Define to 1 if you have the <pwd.h> header file. */
#define HAVE_PWD_H 1

/* Define to 1 if you have the `rindex' function. */
#define HAVE_RINDEX 1

/* Define to 1 if you have the <sched.h> header file. */
#define HAVE_SCHED_H 1

/* Define to 1 if you have the `sched_setscheduler' function. */
/* #undef HAVE_SCHED_SETSCHEDULER */

/* Define to 1 if you have the `setbuf' function. */
#define HAVE_SETBUF 1

/* Define to 1 if you have the `setegid' function. */
#define HAVE_SETEGID 1

/* Define to 1 if you have the `seteuid' function. */
#define HAVE_SETEUID 1

/* Define to 1 if you have the `SetFilePointerEx' function. */
/* #undef HAVE_SETFILEPOINTEREX */

/* Define to 1 if you have the `setgid' function. */
#define HAVE_SETGID 1

/* Define to 1 if you have the `setgroups' function. */
#define HAVE_SETGROUPS 1

/* Define to 1 if you have the `setitimer' function. */
#define HAVE_SETITIMER 1

/* Define to 1 if you have the `setjmp' function. */
#define HAVE_SETJMP 1

/* Define to 1 if you have the <setjmp.h> header file. */
#define HAVE_SETJMP_H 1

/* Define to 1 if you have the `setlocale' function. */
#define HAVE_SETLOCALE 1

/* Define to 1 if you have the `setpgid' function. */
#define HAVE_SETPGID 1

/* Define to 1 if you have the `setpgrp' function. */
#define HAVE_SETPGRP 1

/* Define to 1 if you have the `setpriority' function. */
#define HAVE_SETPRIORITY 1

/* Define to 1 if you have the `setresuid' function. */
/* #undef HAVE_SETRESUID */

/* Define to 1 if you have the `setrlimit' function. */
#define HAVE_SETRLIMIT 1

/* Define to 1 if you have the `setsid' function. */
#define HAVE_SETSID 1

/* Define to 1 if you have the `setuid' function. */
#define HAVE_SETUID 1

/* Define to 1 if you have the `setvbuf' function. */
#define HAVE_SETVBUF 1

/* Define to 1 if you have the `shl_load' function. */
/* #undef HAVE_SHL_LOAD */

/* Define to 1 if you have the `sigaction' function. */
#define HAVE_SIGACTION 1

/* Define to 1 if you have the `sigblock' function. */
#define HAVE_SIGBLOCK 1

/* Define to 1 if you have the `siglongjmp' function. */
#define HAVE_SIGLONGJMP 1

/* Define to 1 if you have the `signal' function. */
#define HAVE_SIGNAL 1

/* Define to 1 if you have the <signal.h> header file. */
#define HAVE_SIGNAL_H 1

/* Define to 1 if you have the `signbit' function. */
/* #undef HAVE_SIGNBIT */

/* Define to 1 if you have the `sigprocmask' function. */
#define HAVE_SIGPROCMASK 1

/* Define to 1 if you have the `sigsetjmp' function. */
#define HAVE_SIGSETJMP 1

/* Define to 1 if you have the `sigvec' function. */
#define HAVE_SIGVEC 1

/* Define to 1 if you have the `snprintf' function. */
#define HAVE_SNPRINTF 1

/* Define to 1 if you have the `socketpair' function. */
#define HAVE_SOCKETPAIR 1

/* Define to 1 if you have the <socket.h> header file. */
/* #undef HAVE_SOCKET_H */

/* Define to 1 if you have the <stddef.h> header file. */
#define HAVE_STDDEF_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#define HAVE_STDINT_H 1

/* Define to 1 if you have the <stdio.h> header file. */
#define HAVE_STDIO_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the `strcasecmp' function. */
#define HAVE_STRCASECMP 1

/* Define to 1 if you have the `strchr' function. */
#define HAVE_STRCHR 1

/* Define to 1 if you have the `strcspn' function. */
#define HAVE_STRCSPN 1

/* Define to 1 if you have the `strdup' function. */
#define HAVE_STRDUP 1

/* Define to 1 if you have the `strerror' function. */
#define HAVE_STRERROR 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if you have the `strncmp' function. */
#define HAVE_STRNCMP 1

/* Define to 1 if you have the `strnlen' function. */
/* #undef HAVE_STRNLEN */

/* Define to 1 if you have the `strtod' function. */
#define HAVE_STRTOD 1

/* Define to 1 if you have the `strtol' function. */
#define HAVE_STRTOL 1

/* Defined if malloc.h contains a struct mallinfo. */
/* #undef HAVE_STRUCT_MALLINFO */

/* Define to 1 if you have the `sync_instruction_memory' function. */
/* #undef HAVE_SYNC_INSTRUCTION_MEMORY */

/* Define to 1 if you have the <syscall.h> header file. */
/* #undef HAVE_SYSCALL_H */

/* Define to 1 if you have the `sysconf' function. */
#define HAVE_SYSCONF 1

/* Define to 1 if you have the <sys/devpoll.h> header file. */
/* #undef HAVE_SYS_DEVPOLL_H */

/* Define to 1 if you have the <sys/epoll.h> header file. */
/* #undef HAVE_SYS_EPOLL_H */

/* Define to 1 if you have the <sys/errno.h> header file. */
#define HAVE_SYS_ERRNO_H 1

/* Define to 1 if you have the <sys/event.h> header file. */
#define HAVE_SYS_EVENT_H 1

/* Define to 1 if you have the <sys/file.h> header file. */
#define HAVE_SYS_FILE_H 1

/* Define to 1 if you have the <sys/filio.h> header file. */
#define HAVE_SYS_FILIO_H 1

/* Define to 1 if you have the <sys/id.h> header file. */
/* #undef HAVE_SYS_ID_H */

/* Define to 1 if you have the <sys/ioctl.h> header file. */
#define HAVE_SYS_IOCTL_H 1

/* Define to 1 if you have the <sys/ioct.h> header file. */
/* #undef HAVE_SYS_IOCT_H */

/* Define to 1 if you have the <sys/mman.h> header file. */
#define HAVE_SYS_MMAN_H 1

/* Define to 1 if you have the <sys/param.h> header file. */
#define HAVE_SYS_PARAM_H 1

/* Define to 1 if you have the <sys/poll.h> header file. */
#define HAVE_SYS_POLL_H 1

/* Define to 1 if you have the <sys/prctl.h> header file. */
/* #undef HAVE_SYS_PRCTL_H */

/* Define to 1 if you have the <sys/priocntl.h> header file. */
/* #undef HAVE_SYS_PRIOCNTL_H */

/* Define to 1 if you have the <sys/procfs.h> header file. */
/* #undef HAVE_SYS_PROCFS_H */

/* Define to 1 if you have the <sys/ptrace.h> header file. */
#define HAVE_SYS_PTRACE_H 1

/* Define to 1 if you have the <sys/rusage.h> header file. */
/* #undef HAVE_SYS_RUSAGE_H */

/* Define to 1 if you have the <sys/sched.h> header file. */
/* #undef HAVE_SYS_SCHED_H */

/* Define to 1 if you have the <sys/select.h> header file. */
#define HAVE_SYS_SELECT_H 1

/* Define to 1 if you have the <sys/socket.h> header file. */
#define HAVE_SYS_SOCKET_H 1

/* Define to 1 if you have the <sys/sockio.h> header file. */
#define HAVE_SYS_SOCKIO_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/syscall.h> header file. */
#define HAVE_SYS_SYSCALL_H 1

/* Define to 1 if you have the <sys/termios.h> header file. */
#define HAVE_SYS_TERMIOS_H 1

/* Define to 1 if you have the <sys/termio.h> header file. */
/* #undef HAVE_SYS_TERMIO_H */

/* Define to 1 if you have the <sys/times.h> header file. */
#define HAVE_SYS_TIMES_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#define HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have the <sys/user.h> header file. */
#define HAVE_SYS_USER_H 1

/* Define to 1 if you have the <sys/wait.h> header file. */
#define HAVE_SYS_WAIT_H 1

/* Define to 1 if you have the <thread.h> header file. */
/* #undef HAVE_THREAD_H */

/* Define to 1 if you have the `thr_yield' function. */
/* #undef HAVE_THR_YIELD */

/* Define to 1 if you have the `time' function. */
#define HAVE_TIME 1

/* Define to 1 if you have the `times' function. */
#define HAVE_TIMES 1

/* Define to 1 if you have the <time.h> header file. */
#define HAVE_TIME_H 1

/* Define to 1 if you have the `tzset' function. */
#define HAVE_TZSET 1

/* Define to 1 if you have the `ualarm' function. */
#define HAVE_UALARM 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to 1 if you have the `usleep' function. */
#define HAVE_USLEEP 1

/* Define to 1 if you have the <valgrind.h> header file. */
/* #undef HAVE_VALGRIND_H */

/* Define to 1 if you have the <valgrind/memcheck.h> header file. */
/* #undef HAVE_VALGRIND_MEMCHECK_H */

/* Define to 1 if you have the <values.h> header file. */
/* #undef HAVE_VALUES_H */

/* Define to 1 if you have the `vfprintf' function. */
#define HAVE_VFPRINTF 1

/* Define to 1 if you have the `vsnprintf' function. */
#define HAVE_VSNPRINTF 1

/* Define to 1 if you have the `vsprintf' function. */
#define HAVE_VSPRINTF 1

/* Define to 1 if you have the `wait3' function. */
#define HAVE_WAIT3 1

/* Define to 1 if you have the `wait4' function. */
#define HAVE_WAIT4 1

/* Define to 1 if you have the `waitpid' function. */
#define HAVE_WAITPID 1

/* Define to 1 if you have the <wchar.h> header file. */
#define HAVE_WCHAR_H 1

/* Define to 1 if you have the <winbase.h> header file. */
/* #undef HAVE_WINBASE_H */

/* Define to 1 if you have the <windows.h> header file. */
/* #undef HAVE_WINDOWS_H */

/* Define to 1 if you have the <winsock2.h> header file. */
/* #undef HAVE_WINSOCK2_H */

/* Define to 1 if you have the <winsock.h> header file. */
/* #undef HAVE_WINSOCK_H */

/* Define to 1 if you have the <ws2tcpip.h> header file. */
/* #undef HAVE_WS2TCPIP_H */

/* Define to 1 if you have the `_alldiv' function. */
/* #undef HAVE__ALLDIV */

/* Define to 1 if you have the `_aullshr' function. */
/* #undef HAVE__AULLSHR */

/* Define to 1 if you have the `_crypt' function. */
/* #undef HAVE__CRYPT */

/* Define to 1 if you have the `_get_daylight' function. */
/* #undef HAVE__GET_DAYLIGHT */

/* Define to 1 if you have the `_get_timezone' function. */
/* #undef HAVE__GET_TIMEZONE */

/* Define to 1 if you have the `_longjmp' function. */
#define HAVE__LONGJMP 1

/* Define to 1 if you have the `_setjmp' function. */
#define HAVE__SETJMP 1

/* Define to 1 if you have the `__priocntl' function. */
/* #undef HAVE___PRIOCNTL */

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT ""

/* Define to the full name of this package. */
#define PACKAGE_NAME ""

/* Define to the full name and version of this package. */
#define PACKAGE_STRING ""

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME ""

/* Define to the version of this package. */
#define PACKAGE_VERSION ""

/* Define as the return type of signal handlers (`int' or `void'). */
#define RETSIGTYPE void

/* The size of a `char *', as computed by sizeof. */
#define SIZEOF_CHAR_P 4

/* The size of a `double', as computed by sizeof. */
#define SIZEOF_DOUBLE 8

/* The size of a `float', as computed by sizeof. */
#define SIZEOF_FLOAT 4

/* The size of a `int', as computed by sizeof. */
#define SIZEOF_INT 4

/* The size of a `long', as computed by sizeof. */
#define SIZEOF_LONG 4

/* The size of a `long double', as computed by sizeof. */
#define SIZEOF_LONG_DOUBLE 16

/* The size of a `long long', as computed by sizeof. */
#define SIZEOF_LONG_LONG 8

/* The size of a `off_t', as computed by sizeof. */
#define SIZEOF_OFF_T 8

/* The size of a `short', as computed by sizeof. */
#define SIZEOF_SHORT 2

/* The size of a `time_t', as computed by sizeof. */
#define SIZEOF_TIME_T 4

/* The size of a `__int64', as computed by sizeof. */
#define SIZEOF___INT64 0

/* If using the C implementation of alloca, define if you know the
   direction of stack growth for your system; otherwise it will be
   automatically deduced at run-time.
	STACK_DIRECTION > 0 => grows toward higher addresses
	STACK_DIRECTION < 0 => grows toward lower addresses
	STACK_DIRECTION = 0 => direction of growth unknown */
#define STACK_DIRECTION -1

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
#define TIME_WITH_SYS_TIME 1

/* Define to 1 if your <sys/time.h> declares `struct tm'. */
/* #undef TM_IN_SYS_TIME */

/* Define to 1 if on AIX 3.
   System headers sometimes define this.
   We just want to avoid a redefinition error message.  */
#ifndef _ALL_SOURCE
/* # undef _ALL_SOURCE */
#endif

/* Define to 1 if on MINIX. */
/* #undef _MINIX */

/* Define to 2 if the system does not provide POSIX.1 features except with
   this defined. */
/* #undef _POSIX_1_SOURCE */

/* Define to 1 if you need to in order for `stat' and other things to work. */
/* #undef _POSIX_SOURCE */

/* Define to 1 if type `char' is unsigned and you are not using gcc.  */
#ifndef __CHAR_UNSIGNED__
/* # undef __CHAR_UNSIGNED__ */
#endif

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
/* #undef inline */
#endif

/* Define to the size of the c-stack for new threads */
#define PIKE_THREAD_C_STACK_SIZE (256 * 1024)

/* NT stuff */
/* #undef HAVE_GETSYSTEMTIMEASFILETIME */
/* #undef HAVE_LOADLIBRARY */
/* #undef HAVE_FREELIBRARY */
/* #undef HAVE_GETPROCADDRESS */
#define DL_EXPORT 
/* #undef USE_MY_WIN32_DLOPEN */

/* CygWin kludge. */
#if defined(HAVE_UNISTD_H) && defined(HAVE_WINDOWS_H)
/* #undef HAVE_WINDOWS_H */
/* #undef HAVE_WINBASE_H */
/* #undef HAVE_WINSOCK_H */
/* #undef HAVE_WINSOCK2_H */
/* #undef HAVE_FD_FLOCK */
#endif /* HAVE_SYS_UNISTD_H && HAVE_WINDOWS_H */

/* How to set a socket non-blocking */
/* #undef USE_IOCTL_FIONBIO */
/* #undef USE_IOCTLSOCKET_FIONBIO */
/* #undef USE_FCNTL_O_NDELAY */
/* #undef USE_FCNTL_FNDELAY */
#define USE_FCNTL_O_NONBLOCK 1

/* How well is OOB TCP working?
 * -1 = unknown
 *  0 = doesn't seem to be working at all
 *  1 = very limited functionality
 *  2 = should be working as long as you are cautious
 *  3 = works excellently
 */
#define PIKE_OOB_WORKS 3

#endif /* MACHINE_H */
