
// 
// 			    Federal Information
// 		   Processing Standards Publication 10-4
// 
// 				 1995 April
// 			Announcing the Standard for
// 
// 	   COUNTRIES, DEPENDENCIES, AREAS OF SPECIAL SOVEREIGNTY,
// 		AND THEIR PRINCIPAL ADMINISTRATIVE DIVISIONS
// 
// Federal Information Processing Standards Publications (FIPS PUBS) are
// issued by the National Institute of Standards and Technology after
// approval by the Secretary of Commerce pursuant to Section 111(d) of
// the Federal Property and Administrative Services Act of 1949, as
// amended by the Computer Security Act of 1987, Public Law 100-235.

// = american standard for countries and country division codes

// Updated 2001-04-17 from ...bugger, lost url
// $Id: FIPS10_4.pmod,v 1.3 2005/02/16 16:47:37 grubba Exp $

#pike __REAL_VERSION__

static mapping(string:string) _region_code_to_name=0;
static mapping(string:string) _region_name_to_code=0;

static void mkregionmappings()
{
   array a=column(regions,0);
   array b=column(regions,1);
   _region_code_to_name=mkmapping(a,b);
   _region_name_to_code=mkmapping(b,a);
}

static mapping(string:array(string)) _division_code_to_line=0;
static mapping(string:array(string)) _division_name_to_line=0;

static void mkdivisionmappings()
{
   array a=column(divisions,1);
   array b=column(divisions,2);
   _division_code_to_line=mkmapping(a,divisions);
   _division_name_to_line=mkmapping(b,divisions);
}

static mapping(string:array(array(string))) _region_to_divisions=0;

static void mkregiondivisionmapping()
{
   mapping res=([]);
   foreach (divisions,array(string) v)
   {
      string c=v[0];
      if (!res[c]) res[c]=({v});
      else res[c]+=({v});
   }
   _region_to_divisions=res;
}

// ----------------------------------------------------------------

string region_code_to_name(string code)
{
   if (!_region_code_to_name) mkregionmappings();
   return _region_code_to_name[upper_case(code)];
}

string region_name_to_code(string code)
{
   if (!_region_name_to_code) mkregionmappings();
   return _region_name_to_code[upper_case(code)];
}

array(string) division_code_to_line(string code)
{
   if (!_division_code_to_line) mkdivisionmappings();
   return _division_code_to_line[upper_case(code)];
}

string division_code_to_name(string code)
{
   array(string) v=division_code_to_line(code);
   return v && v[2];
}

// these aren't really useful, since they report only one division
//
array(string) division_name_to_line(string name)
{
   if (!_division_name_to_line) mkdivisionmappings();
   return _division_name_to_line[name];
}

string division_name_to_code(string code)
{
   array(string) v=division_name_to_line(code);
   return v && v[1];
}


// guessing to multiple lines is better
//

static mapping(string:array(array(string))) guess_to_lines=0;

array(array(string)) division_guess_to_lines(string name)
{
   array(string) guess_mangle(string v)
   {
      v=upper_case(v);
      string q=v-"`"-"'"-"-";
      array res=({v,
		  q,
		  q-" "});
      if (sizeof(v/" ")>1) res+=`+(@map(v/" ",guess_mangle));
      return res;
   };
   void add_guess(string ind,mapping to,array(string) v)
   {
      if (!to[ind]) to[ind]=({v});
      else to[ind]+=({v});
   };
   if (!guess_to_lines)
   {
      guess_to_lines=([]);
      foreach (divisions,array(string) v)
      {
	 map(guess_mangle(v[2]),add_guess,guess_to_lines,v);
	 foreach (v[4..],string q)
	    map(guess_mangle(q),add_guess,guess_to_lines,v);
	 guess_to_lines[v[1]] = ({ v });
      }
//        werror("%O\n",indices(guess_to_lines));
   }
   return Array.uniq(guess_to_lines[upper_case(name)] || ({}));
}

array(string) division_guess_to_codes(string code)
{
   array(array(string)) v=division_guess_to_lines(code);
   return column(v,1);
}

array(array(string)) region_to_divisions(string region)
{
   if (!_region_to_divisions) mkregiondivisionmapping();
   return _region_to_divisions[upper_case(region)] || ({});
}

array(string) region_to_division_codes(string region)
{
   array(array(string)) v=region_to_divisions(region);
   return column(v,1);
}

// ----------------------------------------------------------------

static array(array(string)) regions = ({
   ({"AA","ARUBA"}),
   ({"AC","ANTIGUA AND BARBUDA"}),
   ({"AE","UNITED ARAB EMIRATES"}),
   ({"AF","AFGHANISTAN"}),
   ({"AG","ALGERIA"}),
   ({"AJ","AZERBAIJAN"}),
   ({"AL","ALBANIA"}),
   ({"AM","ARMENIA"}),
   ({"AN","ANDORRA"}),
   ({"AO","ANGOLA"}),
   ({"AR","ARGENTINA"}),
   ({"AS","AUSTRALIA"}),
   ({"AT","ASHMORE AND CARTIER ISLANDS"}),
   ({"AU","AUSTRIA"}),
   ({"AV","ANGUILLA"}),
   ({"BA","BAHRAIN"}),
   ({"BB","BARBADOS"}),
   ({"BC","BOTSWANA"}),
   ({"BD","BERMUDA"}),
   ({"BE","BELGIUM"}),
   ({"BF","BAHAMAS, THE"}),
   ({"BG","BANGLADESH"}),
   ({"BH","BELIZE"}),
   ({"BK","BOSNIA AND HERZEGOVINA"}),
   ({"BL","BOLIVIA"}),
   ({"BM","BURMA"}),
   ({"BN","BENIN"}),
   ({"BO","BELARUS"}),
   ({"BP","SOLOMON ISLANDS"}),
   ({"BR","BRAZIL"}),
   ({"BS","BASSA DE INDIA"}),
   ({"BT","BHUTAN"}),
   ({"BU","BULGARIA"}),
   ({"BV","BOUVET ISLAND"}),
   ({"BX","BRUNEI"}),
   ({"BY","BURUNDI"}),
   ({"CA","CANADA"}),
   ({"CB","CAMBODIA"}),
   ({"CD","CHAD"}),
   ({"CE","SRI LANKA"}),
   ({"CF","CONGO, REPUBLIC OF THE"}),
   ({"CG","CONGO, DEMOCRATIC REPUBLIC OF THE"}),
   ({"CH","CHINA"}),
   ({"CI","CHILE"}),
   ({"CJ","CAYMAN ISLANDS"}),
   ({"CK","COCOS (KEELING) ISLANDS"}),
   ({"CM","CAMEROON"}),
   ({"CN","COMOROS"}),
   ({"CO","COLOMBIA"}),
   ({"CR","CORAL SEA ISLANDS"}),
   ({"CS","COSTA RICA"}),
   ({"CT","CENTRAL AFRICAN REPUBLIC"}),
   ({"CU","CUBA"}),
   ({"CV","CAPE VERDE"}),
   ({"CW","COOK ISLANDS"}),
   ({"CY","CYPRUS"}),
   ({"DA","DENMARK"}),
   ({"DJ","DJIBOUTI"}),
   ({"DO","DOMINICA"}),
   ({"DR","DOMINICAN REPUBLIC"}),
   ({"EC","ECUADOR"}),
   ({"EG","EGYPT"}),
   ({"EI","IRELAND"}),
   ({"EK","EQUATORIAL GUINEA"}),
   ({"EN","ESTONIA"}),
   ({"ER","ERITREA"}),
   ({"ES","EL SALVADOR"}),
   ({"ET","ETHIOPIA"}),
   ({"EU","EUROPA ISLAND"}),
   ({"EZ","CZECH REPUBLIC"}),
   ({"FG","FRENCH GUIANA"}),
   ({"FI","FINLAND"}),
   ({"FJ","FIJI"}),
   ({"FK","FALKLAND ISLANDS"}),
   ({"FM","MICRONESIA, FEDERATED STATES OF"}),
   ({"FO","FAROE ISLANDS"}),
   ({"FP","FRENCH POLYNESIA"}),
   ({"FR","FRANCE"}),
   ({"FS","FRENCH SOUTHERN AND ANTARCTIC LANDS"}),
   ({"GA","GAMBIA, THE"}),
   ({"GB","GABON"}),
   ({"GG","GEORGIA"}),
   ({"GH","GHANA"}),
   ({"GI","GIBRALTAR"}),
   ({"GJ","GRENADA"}),
   ({"GK","GUERNSEY"}),
   ({"GL","GREENLAND"}),
   ({"GM","GERMANY"}),
   ({"GO","GLORIOSO ISLANDS"}),
   ({"GP","GUADELOUPE"}),
   ({"GR","GREECE"}),
   ({"GT","GUATEMALA"}),
   ({"GV","GUINEA"}),
   ({"GY","GUYANA"}),
   ({"GZ","GAZA STRIP"}),
   ({"HA","HAITI"}),
   ({"HK","HONG KONG"}),
   ({"HM","HEARD AND MCDONALD ISLANDS"}),
   ({"HO","HONDURAS"}),
   ({"HR","CROATIA"}),
   ({"HU","HUNGARY"}),
   ({"IC","ICELAND"}),
   ({"ID","INDONESIA"}),
   ({"IM","ISLE OF MAN"}),
   ({"IN","INDIA"}),
   ({"IO","BRITISH INDIAN OCEAN TERRITORY"}),
   ({"IP","CLIPPERTON ISLAND"}),
   ({"IR","IRAN"}),
   ({"IS","ISRAEL"}),
   ({"IT","ITALY"}),
   ({"IV","COTE D' IVOIRE"}),
   ({"IZ","IRAQ"}),
   ({"JA","JAPAN"}),
   ({"JE","JERSEY"}),
   ({"JM","JAMAICA"}),
   ({"JN","JAN MAYEN"}),
   ({"JO","JORDAN"}),
   ({"JU","JUAN DE NOVA ISLAND"}),
   ({"KE","KENYA"}),
   ({"KG","KYRGYZSTAN"}),
   ({"KN","NORTH KOREA"}),
   ({"KR","KIRIBATI"}),
   ({"KS","SOUTH KOREA"}),
   ({"KT","CHRISTMAS ISLAND"}),
   ({"KU","KUWAIT"}),
   ({"KZ","KAZAKHSTAN"}),
   ({"LA","LAOS"}),
   ({"LE","LEBANON"}),
   ({"LG","LATVIA"}),
   ({"LH","LITHUANIA"}),
   ({"LI","LIBERIA"}),
   ({"LO","SLOVAKIA"}),
   ({"LS","LIECHTENSTEIN"}),
   ({"LT","LESOTHO"}),
   ({"LU","LUXEMBOURG"}),
   ({"LY","LIBYA"}),
   ({"MA","MADAGASCAR"}),
   ({"MB","MARTINIQUE"}),
   ({"MC","MACAU"}),
   ({"MD","MOLDOVA"}),
   ({"MF","MAYOTTE"}),
   ({"MG","MONGOLIA"}),
   ({"MH","MONTSERRAT"}),
   ({"MI","MALAWI"}),
   ({"MK","MACEDONIA, FORMER YUGOSLAV REPUBLIC OF"}),
   ({"ML","MALI"}),
   ({"MN","MONACO"}),
   ({"MO","MOROCCO"}),
   ({"MP","MAURITIUS"}),
   ({"MR","MAURITANIA"}),
   ({"MT","MALTA"}),
   ({"MU","OMAN"}),
   ({"MV","MALDIVES"}),
   ({"MX","MEXICO"}),
   ({"MY","MALAYSIA"}),
   ({"MZ","MOZAMBIQUE"}),
   ({"NC","NEW CALEDONIA"}),
   ({"NE","NIUE"}),
   ({"NF","NORFOLK ISLAND"}),
   ({"NG","NIGER"}),
   ({"NH","VANUATU"}),
   ({"NI","NIGERIA"}),
   ({"NL","NETHERLANDS"}),
   ({"NM","NO MAN'S LAND"}),
   ({"NO","NORWAY"}),
   ({"NP","NEPAL"}),
   ({"NR","NAURU"}),
   ({"NS","SURINAME"}),
   ({"NT","NETHERLANDS ANTILLES"}),
   ({"NU","NICARAGUA"}),
   ({"NZ","NEW ZEALAND"}),
   ({"OS","OCEANS"}),
   ({"PA","PARAGUAY"}),
   ({"PC","PITCAIRN ISLAND"}),
   ({"PE","PERU"}),
   ({"PF","PARACEL ISLANDS"}),
   ({"PG","SPRATLY ISLANDS"}),
   ({"PK","PAKISTAN"}),
   ({"PL","POLAND"}),
   ({"PM","PANAMA"}),
   ({"PO","PORTUGAL"}),
   ({"PP","PAPUA NEW GUINEA"}),
   ({"PS","PALAU"}),
   ({"PU","GUINEA-BISSAU"}),
   ({"QA","QATAR"}),
   ({"RE","REUNION"}),
   ({"RM","MARSHALL ISLANDS"}),
   ({"RO","ROMANIA"}),
   ({"RP","PHILIPPINES"}),
   ({"RS","RUSSIA"}),
   ({"RW","RWANDA"}),
   ({"SA","SAUDI ARABIA"}),
   ({"SB","SAINT PIERRE AND MIQUELON"}),
   ({"SC","SAINT KITTS AND NEVIS"}),
   ({"SE","SEYCHELLES"}),
   ({"SF","SOUTH AFRICA"}),
   ({"SG","SENEGAL"}),
   ({"SH","SAINT HELENA"}),
   ({"SI","SLOVENIA"}),
   ({"SL","SIERRA LEONE"}),
   ({"SM","SAN MARINO"}),
   ({"SN","SINGAPORE"}),
   ({"SO","SOMALIA"}),
   ({"SP","SPAIN"}),
   ({"ST","SAINT LUCIA"}),
   ({"SU","SUDAN"}),
   ({"SV","SVALBARD"}),
   ({"SW","SWEDEN"}),
   ({"SX","SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS"}),
   ({"SY","SYRIA"}),
   ({"SZ","SWITZERLAND"}),
   ({"TD","TRINIDAD AND TOBAGO"}),
   ({"TE","TROMELIN ISLAND"}),
   ({"TH","THAILAND"}),
   ({"TI","TAJIKISTAN"}),
   ({"TK","TURKS AND CAICOS ISLANDS"}),
   ({"TL","TOKELAU"}),
   ({"TN","TONGA"}),
   ({"TO","TOGO"}),
   ({"TP","SAO TOME AND PRINCIPE"}),
   ({"TS","TUNISIA"}),
   ({"TT","EAST TIMOR"}),
   ({"TU","TURKEY"}),
   ({"TV","TUVALU"}),
   ({"TW","TAIWAN"}),
   ({"TX","TURKMENISTAN"}),
   ({"TZ","TANZANIA"}),
   ({"UF","UNDERSEA FEATURES"}),
   ({"UG","UGANDA"}),
   ({"UK","UNITED KINGDOM"}),
   ({"UP","UKRAINE"}),
   ({"UV","BURKINA FASO"}),
   ({"UY","URUGUAY"}),
   ({"UZ","UZBEKISTAN"}),
   ({"VC","SAINT VINCENT AND THE GRENADINES"}),
   ({"VE","VENEZUELA"}),
   ({"VI","BRITISH VIRGIN ISLANDS"}),
   ({"VM","VIETNAM"}),
   ({"VT","VATICAN CITY"}),
   ({"WA","NAMIBIA"}),
   ({"WE","WEST BANK"}),
   ({"WF","WALLIS AND FUTUNA"}),
   ({"WI","WESTERN SAHARA"}),
   ({"WS","SAMOA"}),
   ({"WZ","SWAZILAND"}),
   ({"YI","YUGOSLAVIA"}),
   ({"YM","YEMEN"}),
   ({"ZA","ZAMBIA"}),
   ({"ZI","ZIMBABWE"}),
});

static array(array(string)) divisions = ({
   ({"AC","AC01","Barbuda","parish",}),
   ({"AC","AC03","Saint George","parish",}),
   ({"AC","AC04","Saint John","parish",}),
   ({"AC","AC05","Saint Mary","parish",}),
   ({"AC","AC06","Saint Paul","parish",}),
   ({"AC","AC07","Saint Peter","parish",}),
   ({"AC","AC08","Saint Philip","parish",}),
   ({"AE","AE01","Abu Zaby","emirate",}),
   ({"AE","AE02","'Ajman","emirate",}),
   ({"AE","AE03","Dubayy","emirate",}),
   ({"AE","AE04","Al Fujayrah","emirate",}),
   ({"AE","AE05","Ra's al Khaymah","emirate",}),
   ({"AE","AE06","Ash Shariqah","emirate",}),
   ({"AE","AE07","Umm al Qaywayn","emirate",}),
   ({"AF","AF01","Badakhshan","province/velayat",}),
   ({"AF","AF02","Badghis","province/velayat",}),
   ({"AF","AF03","Baghlan","province/velayat",}),
   ({"AF","AF04","AF04","province/velayat",}),
   ({"AF","AF05","Bamian","province/velayat",}),
   ({"AF","AF06","Farah","province/velayat",}),
   ({"AF","AF07","Faryab","province/velayat",}),
   ({"AF","AF08","Ghazni","province/velayat",}),
   ({"AF","AF09","Ghowr","province/velayat",}),
   ({"AF","AF10","Helmand","province/velayat",}),
   ({"AF","AF11","Herat","province/velayat",}),
   ({"AF","AF12","AF12","province/velayat",}),
   ({"AF","AF13","Kabol","province/velayat",}),
   ({"AF","AF14","Kapisa","province/velayat",}),
   ({"AF","AF15","Konar","province/velayat",}),
   ({"AF","AF16","Laghman","province/velayat",}),
   ({"AF","AF17","Lowgar","province/velayat",}),
   ({"AF","AF18","Nangarhar","province/velayat",}),
   ({"AF","AF19","Nimruz","province/velayat",}),
   ({"AF","AF20","Oruzgan","province/velayat",}),
   ({"AF","AF21","Paktia","province/velayat",}),
   ({"AF","AF22","Parvan","province/velayat",}),
   ({"AF","AF23","Kandahar","province/velayat",}),
   ({"AF","AF24","Kondoz","province/velayat",}),
   ({"AF","AF25","AF25","province/velayat",}),
   ({"AF","AF26","Takhar","province/velayat",}),
   ({"AF","AF27","Vardak","province/velayat",}),
   ({"AF","AF28","Zabol","province/velayat",}),
   ({"AF","AF29","Paktika","province/velayat",}),
   ({"AF","AF30","Balkh","province/velayat",}),
   ({"AF","AF31","Jowzjan","province/velayat",}),
   ({"AF","AF32","Samangan","province/velayat",}),
   ({"AF","AF33","Sare Pol","province/velayat",}),
   ({"AG","AG01","Alger","province/wilaya",}),
   ({"AG","AG03","Batna","province/wilaya",}),
   ({"AG","AG04","Constantine","province/wilaya",}),
   ({"AG","AG06","Medea","province/wilaya",}),
   ({"AG","AG07","Mostaganem","province/wilaya",}),
   ({"AG","AG09","Oran","province/wilaya",}),
   ({"AG","AG10","Saida","province/wilaya",}),
   ({"AG","AG12","Setif","province/wilaya",}),
   ({"AG","AG13","Tiaret","province/wilaya",}),
   ({"AG","AG14","Tizi Ouzou","province/wilaya",}),
   ({"AG","AG15","Tlemcen","province/wilaya",}),
   ({"AG","AG18","Bejaia","province/wilaya",}),
   ({"AG","AG19","Biskra","province/wilaya",}),
   ({"AG","AG20","Blida","province/wilaya",}),
   ({"AG","AG21","Bouira","province/wilaya",}),
   ({"AG","AG22","Djelfa","province/wilaya",}),
   ({"AG","AG23","Guelma","province/wilaya",}),
   ({"AG","AG24","Jijel","province/wilaya",}),
   ({"AG","AG25","Laghouat","province/wilaya",}),
   ({"AG","AG26","Mascara","province/wilaya",}),
   ({"AG","AG27","M'Sila","province/wilaya",}),
   ({"AG","AG29","Oum el Bouaghi","province/wilaya",}),
   ({"AG","AG30","Sidi Bel Abbes","province/wilaya",}),
   ({"AG","AG31","Skikda","province/wilaya",}),
   ({"AG","AG33","Tebessa","province/wilaya",}),
   ({"AG","AG34","Adrar","province/wilaya",}),
   ({"AG","AG35","Ain Defla","province/wilaya",}),
   ({"AG","AG36","Ain Temouchent","province/wilaya",}),
   ({"AG","AG37","Annaba","province/wilaya",}),
   ({"AG","AG38","Bechar","province/wilaya",}),
   ({"AG","AG39","Bordj Bou Arreridj","province/wilaya",}),
   ({"AG","AG40","Boumerdes","province/wilaya",}),
   ({"AG","AG41","Chlef","province/wilaya",}),
   ({"AG","AG42","El Bayadh","province/wilaya",}),
   ({"AG","AG43","El Oued","province/wilaya",}),
   ({"AG","AG44","El Tarf","province/wilaya",}),
   ({"AG","AG45","Ghardaia","province/wilaya",}),
   ({"AG","AG46","Illizi","province/wilaya",}),
   ({"AG","AG47","Khenchela","province/wilaya",}),
   ({"AG","AG48","Mila","province/wilaya",}),
   ({"AG","AG49","Naama","province/wilaya",}),
   ({"AG","AG50","Ouargla","province/wilaya",}),
   ({"AG","AG51","Relizane","province/wilaya",}),
   ({"AG","AG52","Souk Ahras","province/wilaya",}),
   ({"AG","AG53","Tamanghasset","province/wilaya",}),
   ({"AG","AG54","Tindouf","province/wilaya",}),
   ({"AG","AG55","Tipaza","province/wilaya",}),
   ({"AG","AG56","Tissemsilt","province/wilaya",}),
   ({"AJ","AJ01","Abseron","rayon/rayonu",}),
   ({"AJ","AJ02","Agcabadi","rayon/rayonu",}),
   ({"AJ","AJ03","Agdam","rayon/rayonu",}),
   ({"AJ","AJ04","Agdas","rayon/rayonu",}),
   ({"AJ","AJ05","Agstafa","rayon/rayonu",}),
   ({"AJ","AJ06","Agsu","rayon/rayonu",}),
   ({"AJ","AJ07","Ali Bayramli","city/sahari",}),
   ({"AJ","AJ08","Astara","rayon/rayonu",}),
   ({"AJ","AJ09","Baki","city/sahari",}),
   ({"AJ","AJ10","Balakan","rayon/rayonu",}),
   ({"AJ","AJ11","Barda","rayon/rayonu",}),
   ({"AJ","AJ12","Beylaqan","rayon/rayonu",}),
   ({"AJ","AJ13","Bilasuvar","rayon/rayonu",}),
   ({"AJ","AJ14","Cabrayil","rayon/rayonu",}),
   ({"AJ","AJ15","Calilabad","rayon/rayonu",}),
   ({"AJ","AJ16","Daskasan","rayon/rayonu",}),
   ({"AJ","AJ17","Davaci","rayon/rayonu",}),
   ({"AJ","AJ18","Fuzuli","rayon/rayonu",}),
   ({"AJ","AJ19","Gadabay","rayon/rayonu",}),
   ({"AJ","AJ20","Ganca","city/sahari",}),
   ({"AJ","AJ21","Goranboy","rayon/rayonu",}),
   ({"AJ","AJ22","Goycay","rayon/rayonu",}),
   ({"AJ","AJ23","Haciqabul","rayon/rayonu",}),
   ({"AJ","AJ24","Imisli","rayon/rayonu",}),
   ({"AJ","AJ25","Ismayilli","rayon/rayonu",}),
   ({"AJ","AJ26","Kalbacar","rayon/rayonu",}),
   ({"AJ","AJ27","Kurdamir","rayon/rayonu",}),
   ({"AJ","AJ28","Lacin","rayon/rayonu",}),
   ({"AJ","AJ29","Lankaran","rayon/rayonu",}),
   ({"AJ","AJ30","Lankaran","city/sahari",}),
   ({"AJ","AJ31","Lerik","rayon/rayonu",}),
   ({"AJ","AJ32","Masalli","rayon/rayonu",}),
   ({"AJ","AJ33","Mingacevir","city/sahari",}),
   ({"AJ","AJ34","Naftalan","city/sahari",}),
   ({"AJ","AJ35","Naxcivan","autonomous republic/muxtar respublikasi",}),
   ({"AJ","AJ36","Neftcala","rayon/rayonu",}),
   ({"AJ","AJ37","Oguz","rayon/rayonu",}),
   ({"AJ","AJ38","Qabala","rayon/rayonu",}),
   ({"AJ","AJ39","Qax","rayon/rayonu",}),
   ({"AJ","AJ40","Qazax","rayon/rayonu",}),
   ({"AJ","AJ41","Qobustan","rayon/rayonu",}),
   ({"AJ","AJ42","Quba","rayon/rayonu",}),
   ({"AJ","AJ43","Qubadli","rayon/rayonu",}),
   ({"AJ","AJ44","Qusar","rayon/rayonu",}),
   ({"AJ","AJ45","Saatli","rayon/rayonu",}),
   ({"AJ","AJ46","Sabirabad","rayon/rayonu",}),
   ({"AJ","AJ47","Saki","rayon/rayonu",}),
   ({"AJ","AJ48","Saki","city/sahari",}),
   ({"AJ","AJ49","Salyan","rayon/rayonu",}),
   ({"AJ","AJ50","Samaxi","rayon/rayonu",}),
   ({"AJ","AJ51","Samkir","rayon/rayonu",}),
   ({"AJ","AJ52","Samux","rayon/rayonu",}),
   ({"AJ","AJ53","Siyazan","rayon/rayonu",}),
   ({"AJ","AJ54","Sumqayit","rayon/rayonu",}),
   ({"AJ","AJ55","Susa","rayon/rayonu",}),
   ({"AJ","AJ56","Susa","city/sahari",}),
   ({"AJ","AJ57","Tartar","rayon/rayonu",}),
   ({"AJ","AJ58","Tovuz","rayon/rayonu",}),
   ({"AJ","AJ59","Ucar","rayon/rayonu",}),
   ({"AJ","AJ60","Xacmaz","rayon/rayonu",}),
   ({"AJ","AJ61","Xankandi","city/sahari",}),
   ({"AJ","AJ62","Xanlar","rayon/rayonu",}),
   ({"AJ","AJ63","Xizi","rayon/rayonu",}),
   ({"AJ","AJ64","Xocali","rayon/rayonu",}),
   ({"AJ","AJ65","Xocavand","rayon/rayonu",}),
   ({"AJ","AJ66","Yardimli","rayon/rayonu",}),
   ({"AJ","AJ67","Yevlax","rayon/rayonu",}),
   ({"AJ","AJ68","Yevlax","city/sahari",}),
   ({"AJ","AJ69","Zangilan","rayon/rayonu",}),
   ({"AJ","AJ70","Zaqatala","rayon/rayonu",}),
   ({"AJ","AJ71","Zardab","rayon/rayonu",}),
   ({"AL","AL01","Berat","district/rreth",}),
   ({"AL","AL02","Diber","district/rreth",}),
   ({"AL","AL03","Durres","district/rreth",}),
   ({"AL","AL04","Elbasan","district/rreth",}),
   ({"AL","AL05","Fier","district/rreth",}),
   ({"AL","AL06","Gjirokaster","district/rreth",}),
   ({"AL","AL07","Gramsh","district/rreth",}),
   ({"AL","AL08","Kolonje","district/rreth",}),
   ({"AL","AL09","Korce","district/rreth",}),
   ({"AL","AL10","Kruje","district/rreth",}),
   ({"AL","AL11","Kukes","district/rreth",}),
   ({"AL","AL12","Lezhe","district/rreth",}),
   ({"AL","AL13","Librazhd","district/rreth",}),
   ({"AL","AL14","Lushnje","district/rreth",}),
   ({"AL","AL15","Mat","district/rreth",}),
   ({"AL","AL16","Mirdite","district/rreth",}),
   ({"AL","AL17","Permet","district/rreth",}),
   ({"AL","AL18","Pogradec","district/rreth",}),
   ({"AL","AL19","Puke","district/rreth",}),
   ({"AL","AL20","Sarande","district/rreth",}),
   ({"AL","AL21","Shkoder","district/rreth",}),
   ({"AL","AL22","Skrapar","district/rreth",}),
   ({"AL","AL23","Tepelene","district/rreth",}),
   ({"AL","AL26","Tropoje","district/rreth",}),
   ({"AL","AL27","Vlore","district/rreth",}),
   ({"AL","AL28","Tiran","district/rreth",}),
   ({"AL","AL29","Bulqize","district/rreth",}),
   ({"AL","AL30","Delvine","district/rreth",}),
   ({"AL","AL31","Devoll","district/rreth",}),
   ({"AL","AL32","Has","district/rreth",}),
   ({"AL","AL33","Kavaje","district/rreth",}),
   ({"AL","AL34","Kucove","district/rreth",}),
   ({"AL","AL35","Kurbin","district/rreth",}),
   ({"AL","AL36","Malesi e Madhe","district/rreth",}),
   ({"AL","AL37","Mallakaster","district/rreth",}),
   ({"AL","AL38","Peqin","district/rreth",}),
   ({"AL","AL39","Tirane"," municipality/bashki",}),
   ({"AM","AM01","Aragatsotn","district/marz",}),
   ({"AM","AM02","Ararat","district/marz",}),
   ({"AM","AM03","Armavir","district/marz",}),
   ({"AM","AM04","Geghark'unik'","district/marz",}),
   ({"AM","AM05","Kotayk'","district/marz",}),
   ({"AM","AM06","Lorri","district/marz",}),
   ({"AM","AM07","Shirak","district/marz",}),
   ({"AM","AM08","Syunik'","district/marz",}),
   ({"AM","AM09","Tavush","district/marz",}),
   ({"AM","AM10","Vayots' Dzor","district/marz",}),
   ({"AM","AM11","Yerevan","city/k'aghak'",}),
// ({"AN","AN01","Andorra","parish/parroquia",}),	// obsolete
   ({"AN","AN02","Canillo","parish/parroquia",}),
   ({"AN","AN03","Encamp","parish/parroquia",}),
   ({"AN","AN04","La Massana","parish/parroquia",}),
   ({"AN","AN05","Ordino","parish/parroquia",}),
   ({"AN","AN06","Sant Julia de Loria","parish/parroquia",}),
   ({"AN","AN07","Andorra la Vella","parish/parroquia",}),
   ({"AN","AN08","Escaldes-Engordany","parish/parroquia",}),
   ({"AO","AO01","Benguela","province/provincia",}),
   ({"AO","AO02","Bie","province/provincia",}),
   ({"AO","AO03","Cabinda","province/provincia",}),
   ({"AO","AO04","Cuando Cubango","province/provincia",}),
   ({"AO","AO05","Cuanza Norte","province/provincia",}),
   ({"AO","AO06","Cuanza Sul","province/provincia",}),
   ({"AO","AO07","Cunene","province/provincia",}),
   ({"AO","AO08","Huambo","province/provincia",}),
   ({"AO","AO09","Huila","province/provincia",}),
   ({"AO","AO10","Luanda","province/provincia",}),
   ({"AO","AO12","Malanje","province/provincia",}),
   ({"AO","AO13","Namibe","province/provincia",}),
   ({"AO","AO14","Moxico","province/provincia",}),
   ({"AO","AO15","Uige","province/provincia",}),
   ({"AO","AO16","Zaire","province/provincia",}),
   ({"AO","AO17","Lunda Norte","province/provincia",}),
   ({"AO","AO18","Lunda Sul","province/provincia",}),
   ({"AO","AO19","Bengo","province/provincia",}),
   ({"AR","AR01","Buenos Aires","provinceprovincia",}),
   ({"AR","AR02","Catamarca","provinceprovincia",}),
   ({"AR","AR03","Chaco","provinceprovincia",}),
   ({"AR","AR04","Chubut","provinceprovincia",}),
   ({"AR","AR05","Cordoba","provinceprovincia",}),
   ({"AR","AR06","Corrientes","provinceprovincia",}),
   ({"AR","AR07","Distrito Federal","district/distrito",}),
   ({"AR","AR08","Entre Rios","provinceprovincia",}),
   ({"AR","AR09","Formosa","provinceprovincia",}),
   ({"AR","AR10","Jujuy","provinceprovincia",}),
   ({"AR","AR11","La Pampa","provinceprovincia",}),
   ({"AR","AR12","La Rioja","provinceprovincia",}),
   ({"AR","AR13","Mendoza","provinceprovincia",}),
   ({"AR","AR14","Misiones","provinceprovincia",}),
   ({"AR","AR15","Neuquen","provinceprovincia",}),
   ({"AR","AR16","Rio Negro","provinceprovincia",}),
   ({"AR","AR17","Salta","provinceprovincia",}),
   ({"AR","AR18","San Juan","provinceprovincia",}),
   ({"AR","AR19","San Luis","provinceprovincia",}),
   ({"AR","AR20","Santa Cruz","provinceprovincia",}),
   ({"AR","AR21","Santa Fe","provinceprovincia",}),
   ({"AR","AR22","Santiago del Estero","provinceprovincia",}),
   ({"AR","AR23","Tierra del Fuego, Antartida e Islas del Atlantico Sur","provinceprovincia",}),
   ({"AR","AR24","Tucuman","provinceprovincia",}),
   ({"AS","AS01","Australian Capital Territory","territory",}),
   ({"AS","AS02","New South Wales","state",}),
   ({"AS","AS03","Northern Territory","territory",}),
   ({"AS","AS04","Queensland","state",}),
   ({"AS","AS05","South Australia","state",}),
   ({"AS","AS06","Tasmania","state",}),
   ({"AS","AS07","Victoria","state",}),
   ({"AS","AS08","Western Australia","state",}),
   ({"AU","AU01","Burgenland","state/bundesland",}),
   ({"AU","AU02","Karnten","state/bundesland",}),
   ({"AU","AU03","Niederosterreich","state/bundesland",}),
   ({"AU","AU04","Oberosterreich","state/bundesland",}),
   ({"AU","AU05","Salzburg","state/bundesland",}),
   ({"AU","AU06","Steiermark","state/bundesland",}),
   ({"AU","AU07","Tirol","state/bundesland",}),
   ({"AU","AU08","Vorarlberg","state/bundesland",}),
   ({"AU","AU09","Wien","state/bundesland",}),
   ({"BA","BA01","Al Hadd","municipality",}),
   ({"BA","BA02","Al Manamah","municipality",}),
   ({"BA","BA03","Al Muharraq","municipality",}),
   ({"BA","BA05","Jidd Hafs","municipality",}),
   ({"BA","BA06","Sitrah","municipality",}),
   ({"BA","BA07","BA07","municipality",}),
   ({"BA","BA08","Al Mintaqah al Gharbiyah","municipality",}),
   ({"BA","BA09","Mintaqat Juzur Hawar","municipality",}),
   ({"BA","BA10","Al Mintaqah ash Shamaliyah","municipality",}),
   ({"BA","BA11","Al Mintaqah al Wusta","municipality",}),
   ({"BA","BA12","Madinat Isa","municipality",}),
   ({"BA","BA13","Ar Rifa' wa al Mintaqah al Janubiyah","municipality",}),
   ({"BA","BA14","Madinat Hamad","municipality",}),
   ({"BB","BB01","Christ Church","Parish",}),
   ({"BB","BB02","Saint Andrew","Parish",}),
   ({"BB","BB03","Saint George","Parish",}),
   ({"BB","BB04","Saint James","Parish",}),
   ({"BB","BB05","Saint John","Parish",}),
   ({"BB","BB06","Saint Joseph","Parish",}),
   ({"BB","BB07","Saint Lucy","Parish",}),
   ({"BB","BB08","Saint Michael","Parish",}),
   ({"BB","BB09","Saint Peter","Parish",}),
   ({"BB","BB10","Saint Philip","Parish",}),
   ({"BB","BB11","Saint Thomas","Parish",}),
   ({"BC","BC01","Central","district",}),
   ({"BC","BC02","Chobe","district",}),
   ({"BC","BC03","Ghanzi","district",}),
   ({"BC","BC04","Kgalagadi","district",}),
   ({"BC","BC05","Kgatleng","district",}),
   ({"BC","BC06","Kweneng","district",}),
   ({"BC","BC07","Ngamiland","district",}),
   ({"BC","BC08","NorthEast","district",}),
   ({"BC","BC09","SouthEast","district",}),
   ({"BC","BC10","Southern","district",}),
   ({"BD","BD01","Devonshire","parish",}),
   ({"BD","BD02","Hamilton","parish",}),
   ({"BD","BD03","Hamilton ","municipality",}),
   ({"BD","BD04","Paget","parish",}),
   ({"BD","BD05","Pembroke","parish",}),
   ({"BD","BD06","Saint George ","municipality",}),
   ({"BD","BD07","Saint George's","parish",}),
   ({"BD","BD08","Sandys","parish",}),
   ({"BD","BD09","Smiths","parish",}),
   ({"BD","BD10","Southampton","parish",}),
   ({"BD","BD11","Warwick","parish",}),
   ({"BE","BE01","Antwerpen","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE02","Brabant","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE03","Hainaut","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE04","Liege","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE05","Limburg","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE06","Luxembourg","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE07","Namur","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE08","Oost-Vlaanderen","province/province (French)/provincie (Flemish)",}),
   ({"BE","BE09","West-Vlaanderen","province/province (French)/provincie (Flemish)",}),
   ({"BF","BF05","Bimini","district",}),
   ({"BF","BF06","Cat Island","district",}),
   ({"BF","BF10","Exuma","district",}),
   ({"BF","BF11","BF11","district",}),
   ({"BF","BF12","BF12","district",}),
   ({"BF","BF13","Inagua","district",}),
   ({"BF","BF15","Long Island","district",}),
   ({"BF","BF16","Mayaguana","district",}),
   ({"BF","BF18","Ragged Island","district",}),
   ({"BF","BF22","Harbour Island","district",}),
   ({"BF","BF23","New Providence","district",}),
   ({"BF","BF24","Acklins and Crooked Islands","district",}),
   ({"BF","BF25","Freeport","district",}),
   ({"BF","BF26","Fresh Creek","district",}),
   ({"BF","BF27","Governor's Harbour","district",}),
   ({"BF","BF28","Green Turtle Cay","district",}),
   ({"BF","BF29","High Rock","district",}),
   ({"BF","BF30","Kemps Bay","district",}),
   ({"BF","BF31","Marsh Harbour","district",}),
   ({"BF","BF32","Nichollstown and Berry Islands","district",}),
   ({"BF","BF33","Rock Sound","district",}),
   ({"BF","BF34","Sandy Point","district",}),
   ({"BF","BF35","San Salvador and Rum Cay","district",}),
   ({"BG","BG80","Chittagong","division",}),
   ({"BG","BG81","Dhaka","division",}),
   ({"BG","BG82","Khulna","division",}),
   ({"BG","BG83","Rajshahi","division",}),
   ({"BH","BH01","Belize","district",}),
   ({"BH","BH02","Cayo","district",}),
   ({"BH","BH03","Corozal","district",}),
   ({"BH","BH04","Orange Walk","district",}),
   ({"BH","BH05","Stann Creek","district",}),
   ({"BH","BH06","Toledo","district",}),
   ({"BK","BKFF","Federation of Bosnia and Herzegovina","Federation",}),
   ({"BK","BKSS","Republika Srpska","Republic",}),
   ({"BL","BL01","Chuquisaca","department/departamento",}),
   ({"BL","BL02","Cochabamba","department/departamento",}),
   ({"BL","BL03","El Beni","department/departamento",}),
   ({"BL","BL04","La Paz","department/departamento",}),
   ({"BL","BL05","Oruro","department/departamento",}),
   ({"BL","BL06","Pando","department/departamento",}),
   ({"BL","BL07","Potosi","department/departamento",}),
   ({"BL","BL08","Santa Cruz","department/departamento",}),
   ({"BL","BL09","Tarija","department/departamento",}),
   ({"BM","BM01","Rakhine State","state",}),
   ({"BM","BM02","Chin State","state",}),
   ({"BM","BM03","Ayeyarwady","division",}),
   ({"BM","BM04","Kachin State","state",}),
   ({"BM","BM05","Kayin State","state",}),
   ({"BM","BM06","Kayah State","state",}),
// ({"BM","BM07","Magwe","division",}),	// obsolete
   ({"BM","BM08","Mandalay","division",}),
// ({"BM","BM09","Pegu","division",}),	// obsolete
   ({"BM","BM10","Sagaing","division",}),
   ({"BM","BM11","Shan State","state",}),
   ({"BM","BM12","Tanintharyi","division",}),
   ({"BM","BM13","Mon State","state",}),
// ({"BM","BM14","Rangoon","division",}),	// obsolete
   ({"BM","BM15","Magway","division",}),
   ({"BM","BM16","Bago","state",}),
   ({"BM","BM17","Yangon","division",}),
   ({"BN","BN01","Atakora","province",}),
   ({"BN","BN02","Atlantique","province",}),
   ({"BN","BN03","Borgou","province",}),
   ({"BN","BN04","Mono","province",}),
   ({"BN","BN05","Oueme","province",}),
   ({"BN","BN06","Zou","province",}),
   ({"BO","BO01","Brestskaya Voblasts'","oblast/voblasts'",}),
   ({"BO","BO02","Homyel'skaya Voblasts'","oblast/voblasts'",}),
   ({"BO","BO03","Hrodzyenskaya Voblasts'","oblast/voblasts'",}),
   ({"BO","BO04","Minsk","cityhorad",}),
   ({"BO","BO05","Minskaya Voblasts'","oblast/voblasts'",}),
   ({"BO","BO06","Mahilyowskaya Voblasts'","oblast/voblasts'",}),
   ({"BO","BO07","Vitsyebskaya Voblasts'","oblast/voblasts'",}),
   ({"BP","BP03","Malaita","province",}),
   ({"BP","BP04","Western","province",}),
   ({"BP","BP05","Central","province",}),
   ({"BP","BP06","Guadalcanal","province",}),
   ({"BP","BP07","Isabel","province",}),
   ({"BP","BP08","Makira","province",}),
   ({"BP","BP09","Temotu","province",}),
   ({"BR","BR01","Acre","state/estado",}),
   ({"BR","BR02","Alagoas","state/estado",}),
   ({"BR","BR03","Amapa","state/estado",}),
   ({"BR","BR04","Amazonas","state/estado",}),
   ({"BR","BR05","Bahia","state/estado",}),
   ({"BR","BR06","Ceara","state/estado",}),
   ({"BR","BR07","Distrito Federal ","federal district/distrito federal",}),
   ({"BR","BR08","Espirito Santo","state/estado",}),
   ({"BR","BR09","Fernando de Noronha","state/estado",}),
   ({"BR","BR10","Goias","state/estado",}),
   ({"BR","BR11","Mato Grosso do Sul","state/estado",}),
   ({"BR","BR13","Maranhao","state/estado",}),
   ({"BR","BR14","Mato Grosso","state/estado",}),
   ({"BR","BR15","Minas Gerais","state/estado",}),
   ({"BR","BR16","Paro","state/estado",}),
   ({"BR","BR17","Paraiba","state/estado",}),
   ({"BR","BR18","Parana","state/estado",}),
   ({"BR","BR19","Pernambuco","state/estado",}),
   ({"BR","BR20","Piaui","state/estado",}),
   ({"BR","BR21","Rio de Janeiro","state/estado",}),
   ({"BR","BR22","Rio Grande do Norte","state/estado",}),
   ({"BR","BR23","Rio Grande do Sul","state/estado",}),
   ({"BR","BR24","Rondonia","state/estado",}),
   ({"BR","BR25","Roraima","state/estado",}),
   ({"BR","BR26","Santa Catarina","state/estado",}),
   ({"BR","BR27","Sao Paulo","state/estado",}),
   ({"BR","BR28","Sergipe","state/estado",}),
   ({"BR","BR31","Tocantins","state/estado",}),
   ({"BT","BT05","Bumthang","district/dzongkhag",}),
   ({"BT","BT06","Chhukha","district/dzongkhag",}),
   ({"BT","BT07","Chirang","district/dzongkhag",}),
   ({"BT","BT08","Daga","district/dzongkhag",}),
   ({"BT","BT09","Geylegphug","district/dzongkhag",}),
   ({"BT","BT10","Ha","district/dzongkhag",}),
   ({"BT","BT11","Lhuntshi","district/dzongkhag",}),
   ({"BT","BT12","Mongar","district/dzongkhag",}),
   ({"BT","BT13","Paro","district/dzongkhag",}),
   ({"BT","BT14","Pemagatsel","district/dzongkhag",}),
   ({"BT","BT15","Punakha","district/dzongkhag",}),
   ({"BT","BT16","Samchi","district/dzongkhag",}),
   ({"BT","BT17","Samdrup","district/dzongkhag",}),
   ({"BT","BT18","Shemgang","district/dzongkhag",}),
   ({"BT","BT19","Tashigang","district/dzongkhag",}),
   ({"BT","BT20","Thimphu","district/dzongkhag",}),
   ({"BT","BT21","Tongsa","district/dzongkhag",}),
   ({"BT","BT22","Wangdi Phodrang","district/dzongkhag",}),
// ({"BU","BU29","Burgas","province/oblast",}),	// obsolete
// ({"BU","BU30","Grad Sofiya","province/oblast",}),	// obsolete
// ({"BU","BU31","Khaskovo","province/oblast",}),	// obsolete
// ({"BU","BU32","Lovech","province/oblast",}),	// obsolete
// ({"BU","BU33","Montana","province/oblast",}),	// obsolete
// ({"BU","BU34","Plovdiv","province/oblast",}),	// obsolete
// ({"BU","BU35","Ruse","province/oblast",}),	// obsolete
// ({"BU","BU36","Sofiya","province/oblast",}),	// obsolete
// ({"BU","BU37","Varna","province/oblast",}),	// obsolete
   ({"BU","BU38","Blagoevgrad","province/oblast",}),
   ({"BU","BU39","Burgas","province/oblast",}),
   ({"BU","BU40","Dobrich","province/oblast",}),
   ({"BU","BU41","Gobrovo","province/oblast",}),
   ({"BU","BU42","Sofiya-Grad","province/oblast",}),
   ({"BU","BU43","Khaskovo","province/oblast",}),
   ({"BU","BU44","Kurdzhali","province/oblast",}),
   ({"BU","BU45","Kyustendil","province/oblast",}),
   ({"BU","BU46","Lovech","province/oblast",}),
   ({"BU","BU47","Montana","province/oblast",}),
   ({"BU","BU48","Pazardzhik","province/oblast",}),
   ({"BU","BU49","Pernik","province/oblast",}),
   ({"BU","BU50","Pleven","province/oblast",}),
   ({"BU","BU51","Plovdiv","province/oblast",}),
   ({"BU","BU52","Razgrad","province/oblast",}),
   ({"BU","BU53","Rusu","province/oblast",}),
   ({"BU","BU54","Shumen","province/oblast",}),
   ({"BU","BU55","Silistra","province/oblast",}),
   ({"BU","BU56","Sliven","province/oblast",}),
   ({"BU","BU57","Smolyan","province/oblast",}),
   ({"BU","BU58","Sofiya","province/oblast",}),
   ({"BU","BU59","Stara Zagora","province/oblast",}),
   ({"BU","BU60","Turgovishte","province/oblast",}),
   ({"BU","BU61","Varna","province/oblast",}),
   ({"BU","BU62","Veliko Turnovo","province/oblast",}),
   ({"BU","BU63","Vidin","province/oblast",}),
   ({"BU","BU64","Vratsa","province/oblast",}),
   ({"BU","BU65","Yambol","province/oblast",}),
   ({"BX","BX01","Belait","district",}),
   ({"BX","BX02","Brunei and Muara","district",}),
   ({"BX","BX03","Temburong","district",}),
   ({"BX","BX04","Tutong","district",}),
   ({"BY","BY02","Bujumbura","province",}),
   ({"BY","BY05","Muramvya","province",}),
   ({"BY","BY09","Bubanza","province",}),
   ({"BY","BY10","Bururi","province",}),
   ({"BY","BY11","Cankuzo","province",}),
   ({"BY","BY12","Cibitoke","province",}),
   ({"BY","BY13","Gitega","province",}),
   ({"BY","BY14","Karuzi","province",}),
   ({"BY","BY15","Kayanza","province",}),
   ({"BY","BY16","Kirundo","province",}),
   ({"BY","BY17","Makamba","province",}),
   ({"BY","BY18","Muyinga","province",}),
   ({"BY","BY19","Ngozi","province",}),
   ({"BY","BY20","Rutana","province",}),
   ({"BY","BY21","Ruyigi","province",}),
   ({"CA","CA01","Alberta","province",}),
   ({"CA","CA02","British Columbia","province",}),
   ({"CA","CA03","Manitoba","province",}),
   ({"CA","CA04","New Brunswick","province",}),
   ({"CA","CA05","Newfoundland","province",}),
// ({"CA","CA06","Northwest Territories","province",}),	// obsolete
   ({"CA","CA07","Nova Scotia","province",}),
   ({"CA","CA08","Ontario","province",}),
   ({"CA","CA09","Prince Edward Island","province",}),
   ({"CA","CA10","Quebec","province",}),
   ({"CA","CA11","Saskatchewan","province",}),
   ({"CA","CA12","Yukon Territory","territory",}),
   ({"CA","CA13","Northwest Territories","territory",}),
   ({"CA","CA14","Nunavut","province",}),
// ({"CB","CB01","Batdambang","province/khett",}),	// obsolete
   ({"CB","CB02","Kampong Cham","province/khett",}),
   ({"CB","CB03","Kampong Chhnang","province/khett",}),
   ({"CB","CB04","Kampong Spoe","province/khett",}),
   ({"CB","CB05","Kampong Thum","province/khett",}),
// ({"CB","CB06","Kampot","province/khett",}),	// obsolete
   ({"CB","CB07","Kandal","province/khett",}),
   ({"CB","CB08","Kaoh Kong","province/khett",}),
   ({"CB","CB09","Krachen","province/khett",}),
   ({"CB","CB10","Mondol Kiri","province/khett",}),
// ({"CB","CB11","Phnum Penh*","province/khett",}),	// obsolete
   ({"CB","CB12","Pouthisat","province/khett",}),
   ({"CB","CB13","Preah Vihear","province/khett",}),
   ({"CB","CB14","Prey Veng","province/khett",}),
// ({"CB","CB15","Rotanokiri","province/khett",}),	// obsolete
// ({"CB","CB16","Siemreab-Otdar Meanchey","province/khett",}),	// obsolete
   ({"CB","CB17","Stoeng Treng","province/khett",}),
   ({"CB","CB18","Svay Rieng","province/khett",}),
   ({"CB","CB19","Takev","province/khett",}),
// ({"CB","CB20","Batdambang","province/khett",}),	// obsolete
   ({"CB","CB21","Kampot","province/khett",}),
   ({"CB","CB22","Phnum Penh","municipality/krong",}),
   ({"CB","CB23","Rotanah Kiri","province/khett",}),
   ({"CB","CB24","Siem Reab","province/khett",}),
   ({"CB","CB25","Banteay Mean Cheay","province/khett",}),
   ({"CB","CB26","Keb","municipality/krong",}),
   ({"CB","CB27","Otdar Mean Cheay","province/khett",}),
   ({"CB","CB28","Preah Seihanu","municipality/krong",}),
   ({"CB","CB29","Batdambang","province/khett",}),
   ({"CB","CB30","Pailin","province/khett",}),
   ({"CD","CD01","Batha","prefecture/prefecture",}),
   ({"CD","CD02","Biltine","prefecture/prefecture",}),
   ({"CD","CD03","Borkou-Ennedi-Tibesti","prefecture/prefecture",}),
   ({"CD","CD04","ChariBaguirmi","prefecture/prefecture",}),
   ({"CD","CD05","Guera","prefecture/prefecture",}),
   ({"CD","CD06","Kanem","prefecture/prefecture",}),
   ({"CD","CD07","Lac","prefecture/prefecture",}),
   ({"CD","CD08","Logone Occidental","prefecture/prefecture",}),
   ({"CD","CD09","Logone Oriental","prefecture/prefecture",}),
   ({"CD","CD10","Mayo-Kebbi","prefecture/prefecture",}),
   ({"CD","CD11","Moyen-Chari","prefecture/prefecture",}),
   ({"CD","CD12","Ouaddai","prefecture/prefecture",}),
   ({"CD","CD13","Salamat","prefecture/prefecture",}),
   ({"CD","CD14","Tandjile","prefecture/prefecture",}),
   ({"CE","CE29","Central","district",}),
   ({"CE","CE30","North Central","district",}),
   ({"CE","CE31","North Eastern","district",}),
   ({"CE","CE32","North Western","district",}),
   ({"CE","CE33","Sabaragamuwa","district",}),
   ({"CE","CE34","Southern","district",}),
   ({"CE","CE35","Uva","district",}),
   ({"CE","CE36","Western","district",}),
   ({"CF","CF01","Bouenza","region/region",}),
   ({"CF","CF03","Cuvette","region/region",}),
   ({"CF","CF04","Kouilou","region/region",}),
   ({"CF","CF05","Lekoumou","region/region",}),
   ({"CF","CF06","Likouala","region/region",}),
   ({"CF","CF07","Niari","region/region",}),
   ({"CF","CF08","Plateaux","region/region",}),
   ({"CF","CF10","Sangha","region/region",}),
   ({"CF","CF11","Pool","region/region",}),
   ({"CF","CF12","Brazzaville","commune",}),
   ({"CG","CG01","Bandundu","region/region",}),
   ({"CG","CG02","Equateur","region/region",}),
   ({"CG","CG03","Kasai-Occidental","region/region",}),
   ({"CG","CG04","Kasai-Oriental","region/region",}),
   ({"CG","CG05","Shaba","region/region",}),
   ({"CG","CG06","Kinshasa","town/ville",}),
// ({"CG","CG07","Kivu","region/region",}),	// obsolete
   ({"CG","CG08","Bas-Congo","region/region",}),
   ({"CG","CG09","Orientale","region/region",}),
   ({"CG","CG10","Maniema","region/region",}),
   ({"CG","CG11","Nord-Kivu","region/region",}),
   ({"CG","CG12","Sud-Kivu","region/region",}),
   ({"CH","CH01","Anhui","province/sheng",}),
   ({"CH","CH02","Zhejiang","province/sheng",}),
   ({"CH","CH03","Jiangxi","province/sheng",}),
   ({"CH","CH04","Jiangsu","province/sheng",}),
   ({"CH","CH05","Jilin","province/sheng",}),
   ({"CH","CH06","Qinghai","province/sheng",}),
   ({"CH","CH07","Fujian","province/sheng",}),
   ({"CH","CH08","Heilongjiang","province/sheng",}),
   ({"CH","CH09","Henan","province/sheng",}),
   ({"CH","CH10","Hebei","province/sheng",}),
   ({"CH","CH11","Hunan","province/sheng",}),
   ({"CH","CH12","Hubei","province/sheng",}),
   ({"CH","CH13","Xinjiang","autonomous region/zizhiqu",}),
   ({"CH","CH14","Xizang ","autonomous region/zizhiqu","Tibet",}),
   ({"CH","CH15","Gansu","province/sheng",}),
   ({"CH","CH16","Guangxi","autonomous region/zizhiqu",}),
   ({"CH","CH18","Guizhou","province/sheng",}),
   ({"CH","CH19","Liaoning","province/sheng",}),
   ({"CH","CH20","Nei Mongol ","autonomous region/zizhiqu","Inner Mongolia",}),
   ({"CH","CH21","Ningxia","autonomous region/zizhiqu",}),
   ({"CH","CH22","Beijing","municipality/shi",}),
   ({"CH","CH23","Shanghai","municipality/shi",}),
   ({"CH","CH24","Shanxi","province/sheng",}),
   ({"CH","CH25","Shandong","province/sheng",}),
   ({"CH","CH26","Shaanxi","province/sheng",}),
// ({"CH","CH27","Sichuan","province/sheng",}),	// obsolete
   ({"CH","CH28","Tianjin","municipality/shi",}),
   ({"CH","CH29","Yunnan","province/sheng",}),
   ({"CH","CH30","Guangdong","province/sheng",}),
   ({"CH","CH31","Hainan","province/sheng",}),
   ({"CH","CH32","Sichuan","province/sheng",}),
   ({"CH","CH33","Chongqing","municipality/shi",}),
   ({"CI","CI01","Valparaiso","region/region",}),
   ({"CI","CI02","Aisen del General Carlos Ibanez del Campo","region/region",}),
   ({"CI","CI03","Antofagasta","region/region",}),
   ({"CI","CI04","Araucania","region/region",}),
   ({"CI","CI05","Atacama","region/region",}),
   ({"CI","CI06","Bio-Bio","region/region",}),
   ({"CI","CI07","Coquimbo","region/region",}),
   ({"CI","CI08","Libertador General Bernardo O'Higgins","region/region",}),
   ({"CI","CI09","Los Lagos","region/region",}),
   ({"CI","CI10","Magallanes y de la Antartica Chilena","region/region",}),
   ({"CI","CI11","Maule","region/region",}),
   ({"CI","CI12","Region Metropolitana","region/region",}),
   ({"CI","CI13","Tarapaca","region/region",}),
   ({"CJ","CJ01","Creek","district",}),
   ({"CJ","CJ02","Eastern","district",}),
   ({"CJ","CJ03","Midland","district",}),
   ({"CJ","CJ04","South Town","district",}),
   ({"CJ","CJ05","Spot Bay","district",}),
   ({"CJ","CJ06","Stake Bay","district",}),
   ({"CJ","CJ07","West End","district",}),
   ({"CJ","CJ08","Western","district",}),
   ({"CM","CM04","Est","province",}),
   ({"CM","CM05","Littoral","province",}),
   ({"CM","CM07","NordOuest","province",}),
   ({"CM","CM08","Ouest","province",}),
   ({"CM","CM09","SudOuest","province",}),
   ({"CM","CM10","Adamaoua","province",}),
   ({"CM","CM11","Centre","province",}),
   ({"CM","CM12","ExtremeNord","province",}),
   ({"CM","CM13","Nord","province",}),
   ({"CM","CM14","Sud","province",}),
   ({"CN","CN01","Anjouan","island",}),
   ({"CN","CN02","Grande Comore","island",}),
   ({"CN","CN03","Moheli","island",}),
   ({"CO","CO01","Amazonas","department/departamento",}),
   ({"CO","CO02","Antioquia","department/departamento",}),
   ({"CO","CO03","Arauca","department/departamento",}),
   ({"CO","CO04","Atlantico","department/departamento",}),
// ({"CO","CO05","Bolivar","department/departamento",}),	// obsolete
// ({"CO","CO06","Boyaca","department/departamento",}),	// obsolete
// ({"CO","CO07","Caldas","department/departamento",}),	// obsolete
   ({"CO","CO08","Caqueta","department/departamento",}),
   ({"CO","CO09","Cauca","department/departamento",}),
   ({"CO","CO10","Cesar","department/departamento",}),
   ({"CO","CO11","Choco","department/departamento",}),
   ({"CO","CO12","Cordoba","department/departamento",}),
   ({"CO","CO14","Guaviare","department/departamento",}),
   ({"CO","CO15","Guainia","department/departamento",}),
   ({"CO","CO16","Huila","department/departamento",}),
   ({"CO","CO17","La Guajira","department/departamento",}),
   ({"CO","CO18","Magdalena","department/departamento",}),
   ({"CO","CO19","Meta","department/departamento",}),
   ({"CO","CO20","Narino","department/departamento",}),
   ({"CO","CO21","Norte de Santander","department/departamento",}),
   ({"CO","CO22","Putumayo","department/departamento",}),
   ({"CO","CO23","Quindio","department/departamento",}),
   ({"CO","CO24","Risaralda","department/departamento",}),
   ({"CO","CO25","San Andres y Providencia","department/departamento",}),
   ({"CO","CO26","Santander","department/departamento",}),
   ({"CO","CO27","Sucre","department/departamento",}),
   ({"CO","CO28","Tolima","department/departamento",}),
   ({"CO","CO29","Valle del Cauca","department/departamento",}),
   ({"CO","CO30","Vaupes","department/departamento",}),
   ({"CO","CO31","Vichada","department/departamento",}),
   ({"CO","CO32","Casanare","department/departamento",}),
   ({"CO","CO33","Cundinamarca","department/departamento",}),
   ({"CO","CO34","Distrito Capital","capital district/distrito capital",}),
   ({"CO","CO35","Bolivar","department/departamento",}),
   ({"CO","CO36","Boyaca","department/departamento",}),
   ({"CO","CO37","Caldas","department/departamento",}),
   ({"CO","CO38","Magdalena","department/departamento",}),
   ({"CS","CS01","Alajuela","province/provincia",}),
   ({"CS","CS02","Cartago","province/provincia",}),
   ({"CS","CS03","Guanacaste","province/provincia",}),
   ({"CS","CS04","Heredia","province/provincia",}),
   ({"CS","CS06","Limon","province/provincia",}),
   ({"CS","CS07","Puntarenas","province/provincia",}),
   ({"CS","CS08","San Jose","province/provincia",}),
   ({"CT","CT01","Bamingui-Bangoran","perfecture/perfecture",}),
   ({"CT","CT02","Basse-Kotto","perfecture/perfecture",}),
   ({"CT","CT03","Haute-Kotto","perfecture/perfecture",}),
   ({"CT","CT04","Haute-Sangha","perfecture/perfecture",}),
   ({"CT","CT05","Haut-Mbomou","perfecture/perfecture",}),
   ({"CT","CT06","Kemo-Gribingui","perfecture/perfecture",}),
   ({"CT","CT07","Lobaye","perfecture/perfecture",}),
   ({"CT","CT08","Mbomou","perfecture/perfecture",}),
   ({"CT","CT09","Nana-Mambere","perfecture/perfecture",}),
   ({"CT","CT11","Ouaka","perfecture/perfecture",}),
   ({"CT","CT12","Ouham","perfecture/perfecture",}),
   ({"CT","CT13","Ouham-Pende","perfecture/perfecture",}),
   ({"CT","CT14","Vakaga","perfecture/perfecture",}),
   ({"CT","CT15","Gribingui","economic perfecture/perfecture economique",}),
   ({"CT","CT16","Sangha","economic perfecture/perfecture economique",}),
   ({"CT","CT17","Ombella-Mpoko","perfecture/perfecture",}),
   ({"CT","CT18","Bangui","commune",}),
   ({"CU","CU01","Pinar del Rio","province/provincia",}),
   ({"CU","CU02","Ciudad de La Habana","province/provincia",}),
   ({"CU","CU03","Matanzas","province/provincia",}),
   ({"CU","CU04","Isla de la Juventud","special municipality/municipio especial",}),
   ({"CU","CU05","Camaguey","province/provincia",}),
   ({"CU","CU07","Ciego de Avila","province/provincia",}),
   ({"CU","CU08","Cienfuegos","province/provincia",}),
   ({"CU","CU09","Granma","province/provincia",}),
   ({"CU","CU10","Guantanamo","province/provincia",}),
   ({"CU","CU11","La Habana","province/provincia",}),
   ({"CU","CU12","Holguin","province/provincia",}),
   ({"CU","CU13","Las Tunas","province/provincia",}),
   ({"CU","CU14","Sancti Spiritus","province/provincia",}),
   ({"CU","CU15","Santiago de Cuba","province/provincia",}),
   ({"CU","CU16","Villa Clara","province/provincia",}),
   ({"CV","CV01","Boa Vista","district/concelho",}),
   ({"CV","CV02","Brava","district/concelho",}),
   ({"CV","CV03","Fogo","district/concelho",}),
   ({"CV","CV04","Maio","district/concelho",}),
   ({"CV","CV05","Paul","district/concelho",}),
   ({"CV","CV06","Praia","district/concelho",}),
   ({"CV","CV07","Ribeira Grande","district/concelho",}),
   ({"CV","CV08","Sal","district/concelho",}),
   ({"CV","CV09","Santa Catarina","district/concelho",}),
   ({"CV","CV10","Sao Nicolau","district/concelho",}),
   ({"CV","CV11","Sao Vicente","district/concelho",}),
   ({"CV","CV12","Tarrafal","district/concelho",}),
   ({"CY","CY01","Famagusta","district",}),
   ({"CY","CY02","Kyrenia","district",}),
   ({"CY","CY03","Larnaca","district",}),
   ({"CY","CY04","Nicosia","district",}),
   ({"CY","CY05","Limassol","district",}),
   ({"CY","CY06","Paphos","district",}),
   ({"DA","DA01","Arhus","county/amt",}),
   ({"DA","DA02","Bornholm","county/amt",}),
   ({"DA","DA03","Frederiksborg","county/amt",}),
   ({"DA","DA04","Fyn","county/amt",}),
   ({"DA","DA05","Kobenhavn","commune/kommune",}),
   ({"DA","DA06","Kobenhavn","county/amt",}),
   ({"DA","DA07","Nordjylland","county/amt",}),
   ({"DA","DA08","Ribe","county/amt",}),
   ({"DA","DA09","Ringkobing","county/amt",}),
   ({"DA","DA10","Roskilde","county/amt",}),
   ({"DA","DA11","Sonderjylland","county/amt",}),
   ({"DA","DA12","Storstrom","county/amt",}),
   ({"DA","DA13","Vejle","county/amt",}),
   ({"DA","DA14","Vestsjalland","county/amt",}),
   ({"DA","DA15","Viborg","county/amt",}),
   ({"DA","DA16","Fredericksberg","commune/kommune",}),
   ({"DJ","DJ01","'Ali Sabih","cercle",}),
   ({"DJ","DJ02","Dikhil","cercle",}),
   ({"DJ","DJ03","Djibouti","cercle",}),
   ({"DJ","DJ04","Obock","cercle",}),
   ({"DJ","DJ05","Tadjoura","cercle",}),
   ({"DO","DO02","Saint Andrew","parish",}),
   ({"DO","DO03","Saint David","parish",}),
   ({"DO","DO04","Saint George","parish",}),
   ({"DO","DO05","Saint John","parish",}),
   ({"DO","DO06","Saint Joseph","parish",}),
   ({"DO","DO07","Saint Luke","parish",}),
   ({"DO","DO08","Saint Mark","parish",}),
   ({"DO","DO09","Saint Patrick","parish",}),
   ({"DO","DO10","Saint Paul","parish",}),
   ({"DO","DO11","Saint Peter","parish",}),
   ({"DR","DR01","Azua","province/provincia",}),
   ({"DR","DR02","Baoruco","province/provincia",}),
   ({"DR","DR03","Barahona","province/provincia",}),
   ({"DR","DR04","Dajabon","province/provincia",}),
   ({"DR","DR05","Distrito Nacional","district/distrito",}),
   ({"DR","DR06","Duarte","province/provincia",}),
   ({"DR","DR08","Espaillat","province/provincia",}),
   ({"DR","DR09","Independencia","province/provincia",}),
   ({"DR","DR10","La Altagracia","province/provincia",}),
   ({"DR","DR11","Elias Pina","province/provincia",}),
   ({"DR","DR12","La Romana","province/provincia",}),
   ({"DR","DR14","Maria Trinidad Sanchez","province/provincia",}),
   ({"DR","DR15","Monte Cristi","province/provincia",}),
   ({"DR","DR16","Pedernales","province/provincia",}),
   ({"DR","DR17","Peravia","province/provincia",}),
   ({"DR","DR18","Puerto Plata","province/provincia",}),
   ({"DR","DR19","Salcedo","province/provincia",}),
   ({"DR","DR20","Samana","province/provincia",}),
   ({"DR","DR21","Sanchez Ramirez","province/provincia",}),
   ({"DR","DR23","San Juan","province/provincia",}),
   ({"DR","DR24","San Pedro de Macoris","province/provincia",}),
   ({"DR","DR25","Santiago","province/provincia",}),
   ({"DR","DR26","Santiago Rodriguez","province/provincia",}),
   ({"DR","DR27","Valverde","province/provincia",}),
   ({"DR","DR28","El Seibo","province/provincia",}),
   ({"DR","DR29","Hato Mayor","province/provincia",}),
   ({"DR","DR30","La Vega","province/provincia",}),
   ({"DR","DR31","Monsenor Nouel","province/provincia",}),
   ({"DR","DR32","Monte Plata","province/provincia",}),
   ({"DR","DR33","San Cristobal","province/provincia",}),
   ({"EC","EC01","Galapagos","province/provincia",}),
   ({"EC","EC02","Azuay","province/provincia",}),
   ({"EC","EC03","Bolivar","province/provincia",}),
   ({"EC","EC04","Canar","province/provincia",}),
   ({"EC","EC05","Carchi","province/provincia",}),
   ({"EC","EC06","Chimborazo","province/provincia",}),
   ({"EC","EC07","Cotopaxi","province/provincia",}),
   ({"EC","EC08","El Oro","province/provincia",}),
   ({"EC","EC09","Esmeraldas","province/provincia",}),
   ({"EC","EC10","Guayas","province/provincia",}),
   ({"EC","EC11","Imbabura","province/provincia",}),
   ({"EC","EC12","Loja","province/provincia",}),
   ({"EC","EC13","Los Rios","province/provincia",}),
   ({"EC","EC14","Manabi","province/provincia",}),
   ({"EC","EC15","Morona-Santiago","province/provincia",}),
// ({"EC","EC16","Napo","province/provincia",}),	// obsolete
   ({"EC","EC17","Pastaza","province/provincia",}),
   ({"EC","EC18","Pichincha","province/provincia",}),
   ({"EC","EC19","Tungurahua","province/provincia",}),
   ({"EC","EC20","Zamora-Chinchipe","province/provincia",}),
// ({"EC","EC21","Napo","province/provincia",}),	// obsolete
   ({"EC","EC22","Sucumbios","province/provincia",}),
   ({"EC","EC23","Napo","province/provincia",}),
   ({"EC","EC24","Orellana","province/provincia",}),
   ({"EG","EG01","Ad Daqahliyah","governorate/muhafazah",}),
   ({"EG","EG02","Al Bahr al Ahmar","governorate/muhafazah",}),
   ({"EG","EG03","Al Buhayrah","governorate/muhafazah",}),
   ({"EG","EG04","Al Fayyum","governorate/muhafazah",}),
   ({"EG","EG05","Al Gharbiyah","governorate/muhafazah",}),
   ({"EG","EG06","Al Iskandariyah","governorate/muhafazah",}),
   ({"EG","EG07","Al Isma'iliyah","governorate/muhafazah",}),
   ({"EG","EG08","Al Jizah","governorate/muhafazah",}),
   ({"EG","EG09","Al Minufiyah","governorate/muhafazah",}),
   ({"EG","EG10","Al Minya","governorate/muhafazah",}),
   ({"EG","EG11","Al Qahirah","governorate/muhafazah",}),
   ({"EG","EG12","Al Qaly\257biyah","governorate/muhafazah",}),
   ({"EG","EG13","Al Wadi al Jadid","governorate/muhafazah",}),
   ({"EG","EG14","Ash Sharqiyah","governorate/muhafazah",}),
   ({"EG","EG15","As Suways","governorate/muhafazah",}),
   ({"EG","EG16","Aswan","governorate/muhafazah",}),
   ({"EG","EG17","Asyut","governorate/muhafazah",}),
   ({"EG","EG18","Bani Suwayf","governorate/muhafazah",}),
   ({"EG","EG19","Bur Sa'id","governorate/muhafazah",}),
   ({"EG","EG20","Dumyat","governorate/muhafazah",}),
   ({"EG","EG21","Kafr ash Shaykh","governorate/muhafazah",}),
   ({"EG","EG22","Matruh","governorate/muhafazah",}),
   ({"EG","EG23","Qina","governorate/muhafazah",}),
   ({"EG","EG24","Suhaj","governorate/muhafazah",}),
   ({"EG","EG26","Janub Sina'","governorate/muhafazah",}),
   ({"EG","EG27","Shamal Sina'","governorate/muhafazah",}),
   ({"EI","EI01","Carlow","county",}),
   ({"EI","EI02","Cavan","county",}),
   ({"EI","EI03","Clare","county",}),
   ({"EI","EI04","Cork","county",}),
   ({"EI","EI06","Donegal","county",}),
   ({"EI","EI07","Dublin","county",}),
   ({"EI","EI10","Galway","county",}),
   ({"EI","EI11","Kerry","county",}),
   ({"EI","EI12","Kildare","county",}),
   ({"EI","EI13","Kilkenny","county",}),
   ({"EI","EI14","Leitrim","county",}),
   ({"EI","EI15","Laois","county",}),
   ({"EI","EI16","Limerick","county",}),
   ({"EI","EI18","Longford","county",}),
   ({"EI","EI19","Louth","county",}),
   ({"EI","EI20","Mayo","county",}),
   ({"EI","EI21","Meath","county",}),
   ({"EI","EI22","Monaghan","county",}),
   ({"EI","EI23","Offaly","county",}),
   ({"EI","EI24","Roscommon","county",}),
   ({"EI","EI25","Sligo","county",}),
   ({"EI","EI26","Tipperary","county",}),
   ({"EI","EI27","Waterford","county",}),
   ({"EI","EI29","Westmeath","county",}),
   ({"EI","EI30","Wexford","county",}),
   ({"EI","EI31","Wicklow","county",}),
   ({"EK","EK03","Annobon","province/provincia",}),
   ({"EK","EK04","Bioko Norte","province/provincia",}),
   ({"EK","EK05","Bioko Sur","province/provincia",}),
   ({"EK","EK06","Centro Sur","province/provincia",}),
   ({"EK","EK07","Kie-Ntem","province/provincia",}),
   ({"EK","EK08","Litoral","province/provincia",}),
   ({"EK","EK09","Wele-Nzas","province/provincia",}),
   ({"EN","EN01","Harjumaa","county/maa",}),
   ({"EN","EN02","Hiiumaa","county/maa",}),
   ({"EN","EN03","Ida-Virumaa","county/maa",}),
   ({"EN","EN04","Jarvamaa","county/maa",}),
   ({"EN","EN05","Jogevamaa","county/maa",}),
   ({"EN","EN07","Laanemaa","county/maa",}),
   ({"EN","EN08","Laane-Virumaa","county/maa",}),
   ({"EN","EN11","Parnumaa","county/maa",}),
   ({"EN","EN12","Polvamaa","county/maa",}),
   ({"EN","EN13","Raplamaa","county/maa",}),
   ({"EN","EN14","Saaremaa","county/maa",}),
   ({"EN","EN18","Tartumaa","county/maa",}),
   ({"EN","EN19","Valgamaa","county/maa",}),
   ({"EN","EN20","Viljandimaa","county/maa",}),
   ({"EN","EN21","Vorumaa","county/maa",}),
   ({"ES","ES01","Ahuachapan","department/departamento",}),
   ({"ES","ES02","Cabanas","department/departamento",}),
   ({"ES","ES03","Chalatenango","department/departamento",}),
   ({"ES","ES04","Cuscatlan","department/departamento",}),
   ({"ES","ES05","La Libertad","department/departamento",}),
   ({"ES","ES06","La Paz","department/departamento",}),
   ({"ES","ES07","La Union","department/departamento",}),
   ({"ES","ES08","Morazan","department/departamento",}),
   ({"ES","ES09","San Miguel","department/departamento",}),
   ({"ES","ES10","San Salvador","department/departamento",}),
   ({"ES","ES11","Santa Ana","department/departamento",}),
   ({"ES","ES12","San Vicente","department/departamento",}),
   ({"ES","ES13","Sonsonate","department/departamento",}),
   ({"ES","ES14","Usulutan","department/departamento",}),
   ({"ET","ET01","Arsi","administraative region/astedader akababi",}),
   ({"ET","ET02","ET02","administraative region/astedader akababi",}),
   ({"ET","ET03","ET03","administraative region/astedader akababi",}),
   ({"ET","ET05","ET05","administraative region/astedader akababi",}),
   ({"ET","ET06","ET06","administraative region/astedader akababi",}),
   ({"ET","ET07","ET07","administraative region/astedader akababi",}),
   ({"ET","ET08","ET08","administraative region/astedader akababi",}),
   ({"ET","ET09","ET09","administraative region/astedader akababi",}),
   ({"ET","ET10","ET10","administraative region/astedader akababi",}),
   ({"ET","ET11","ET11","administraative region/astedader akababi",}),
   ({"ET","ET12","ET12","administraative region/astedader akababi",}),
   ({"ET","ET13","ET13","administraative region/astedader akababi",}),
   ({"ET","ET14","ET14","administraative region/astedader akababi",}),
   ({"ET","ET17","Asosa","administraative region/astedader akababi",}),
   ({"ET","ET18","Borena","administraative region/astedader akababi",}),
   ({"ET","ET19","Debub Gonder","administraative region/astedader akababi",}),
   ({"ET","ET20","Debub Shewa","administraative region/astedader akababi",}),
   ({"ET","ET21","Debub Welo","administraative region/astedader akababi",}),
   ({"ET","ET22","Dire Dawa","autonomous region/rasgez akababi",}),
   ({"ET","ET23","Gambela","administraative region/astedader akababi",}),
   ({"ET","ET24","Metekel","administraative region/astedader akababi",}),
   ({"ET","ET25","Mirab Gojam","administraative region/astedader akababi",}),
   ({"ET","ET26","Mirab Harerge","administraative region/astedader akababi",}),
   ({"ET","ET27","Mirab Shewa","administraative region/astedader akababi",}),
   ({"ET","ET28","Misrak Gojam","administraative region/astedader akababi",}),
   ({"ET","ET29","Misrak Haregre","administraative region/astedader akababi",}),
   ({"ET","ET30","Nazret","administraative region/astedader akababi",}),
   ({"ET","ET31","Ogaden","autonomous region/rasgez akababi",}),
   ({"ET","ET32","Omo","administraative region/astedader akababi",}),
   ({"ET","ET33","Semen Gonder","administraative region/astedader akababi",}),
   ({"ET","ET34","Semen shewa","administraative region/astedader akababi",}),
   ({"ET","ET35","Semen Welo","administraative region/astedader akababi",}),
   ({"ET","ET37","Tigray","autonomous region/rasgez akababi",}),
   ({"ET","ET38","Bale","administraative region/astedader akababi",}),
   ({"ET","ET39","Gamo Gofa","administraative region/astedader akababi",}),
   ({"ET","ET40","Ilubabor","administraative region/astedader akababi",}),
   ({"ET","ET41","Kefa","administraative region/astedader akababi",}),
   ({"ET","ET42","Sidamo","administraative region/astedader akababi",}),
   ({"ET","ET43","Welega","administraative region/astedader akababi",}),
   ({"EZ","EZ52","Praha, Hlavni Mesto","region/kraj",}),
   ({"EZ","EZ78","Brnensky Kraj","region/kraj",}),
   ({"EZ","EZ79","Budejovicky Kraj","region/kraj",}),
   ({"EZ","EZ80","Jihlavsky Kraj","region/kraj",}),
   ({"EZ","EZ81","Karlovarsky Kraj","region/kraj",}),
   ({"EZ","EZ82","Kralovehradecky Kraj","region/kraj",}),
   ({"EZ","EZ83","Liberecky Kraj","region/kraj",}),
   ({"EZ","EZ84","Olomoucky Kraj","region/kraj",}),
   ({"EZ","EZ85","Ostravsky Kraj","region/kraj",}),
   ({"EZ","EZ86","Pardubicks Kraj","region/kraj",}),
   ({"EZ","EZ87","Plzensky Kraj","region/kraj",}),
   ({"EZ","EZ88","Stredocesky Kraj","region/kraj",}),
   ({"EZ","EZ89","Ustecky Kraj","region/kraj",}),
   ({"EZ","EZ90","Zlinsky Kraj","region/kraj",}),
   ({"FI","FI01","Ahvenanmaa","province/laani",}),
// ({"FI","FI02","Hame","province/laani",}),	// obsolete
// ({"FI","FI03","Keski-Suomi","province/laani",}),	// obsolete
// ({"FI","FI04","Kuopio","province/laani",}),	// obsolete
// ({"FI","FI05","Kymi","province/laani",}),	// obsolete
   ({"FI","FI06","Lappi","province/laani",}),
// ({"FI","FI07","Mikkeli","province/laani",}),	// obsolete
   ({"FI","FI08","Oulu Laani","province/laani",}),
// ({"FI","FI09","Pohjois-Karjala","province/laani",}),	// obsolete
// ({"FI","FI10","Turku ja Pori","province/laani",}),	// obsolete
// ({"FI","FI11","Uusimaa","province/laani",}),	// obsolete
// ({"FI","FI12","Vaasa","province/laani",}),	// obsolete
   ({"FI","FI13","Etela-Suomen Laani","province/laani",}),
   ({"FI","FI14","Ita-Suomen Laani","province/laani",}),
   ({"FI","FI15","Lansi-Suomen Laani","province/laani",}),
   ({"FJ","FJ01","Central","division",}),
   ({"FJ","FJ02","Eastern","division",}),
   ({"FJ","FJ03","Northern","division",}),
   ({"FJ","FJ04","Rotuma","dependency",}),
   ({"FJ","FJ05","Western","division",}),
   ({"FM","FM01","Kosrae","island",}),
   ({"FM","FM02","Pohnpei","island",}),
   ({"FM","FM03","Chuuk","island",}),
   ({"FM","FM04","Yap","island",}),
   ({"FR","FR97","Aquitaine","region/region",}),
   ({"FR","FR98","Auvergne","region/region",}),
   ({"FR","FR99","Basse-Normandie","region/region",}),
   ({"FR","FRA1","Bourgogne","region/region",}),
   ({"FR","FRA2","Bretagne","region/region",}),
   ({"FR","FRA3","Centre","region/region",}),
   ({"FR","FRA4","Champagne-Ardenne","region/region",}),
   ({"FR","FRA5","Corse","region/region",}),
   ({"FR","FRA6","Franche-Comte","region/region",}),
   ({"FR","FRA7","Haute-Normandie","region/region",}),
   ({"FR","FRA8","Ile-de-France","region/region",}),
   ({"FR","FRA9","Languedoc-Roussillon","region/region",}),
   ({"FR","FRB1","Limousin","region/region",}),
   ({"FR","FRB2","Lorraine","region/region",}),
   ({"FR","FRB3","Midi-Pyrenees","region/region",}),
   ({"FR","FRB4","Nord-Pas-de-Calais","region/region",}),
   ({"FR","FRB5","Pays de la Loire","region/region",}),
   ({"FR","FRB6","Picardie","region/region",}),
   ({"FR","FRB7","Poitou-Charentes","region/region",}),
   ({"FR","FRB8","Provence-Alpes-Cote d'Azur","region/region",}),
   ({"FR","FRB9","Rhone-Alpes","region/region",}),
   ({"FR","FRC1","Alsace","region/region",}),
   ({"GA","GA01","Banjul","city",}),
   ({"GA","GA02","Lower River","division",}),
   ({"GA","GA03","MacCarthy Island","division",}),
   ({"GA","GA04","Upper River","division",}),
   ({"GA","GA05","Western","division",}),
   ({"GA","GA07","North Bank","division",}),
   ({"GB","GB01","Estuaire","province",}),
   ({"GB","GB02","Haut-Ogooue","province",}),
   ({"GB","GB03","Moyen-Ogooue","province",}),
   ({"GB","GB04","Ngounie","province",}),
   ({"GB","GB05","Nyanga","province",}),
   ({"GB","GB06","Ogooue-Ivindo","province",}),
   ({"GB","GB07","Ogooue-Lolo","province",}),
   ({"GB","GB08","Ogooue-Maritime","province",}),
   ({"GB","GB09","Woleu-Ntem","province",}),
   ({"GG","GG01","Abashis Raioni","region/raioni",}),
   ({"GG","GG02","Abkhazia","autonomous republic/avtonomiuri respublika",}),
   ({"GG","GG03","Adigenis Raioni","region/raioni",}),
   ({"GG","GG04","Ajaria","autonomous republic/avtonomiuri respublika",}),
   ({"GG","GG05","Akhalgoris Raioni","region/raioni",}),
   ({"GG","GG06","Akhalk'alak'is Raioni","region/raioni",}),
   ({"GG","GG07","Akhalts'ikhis Raioni","region/raioni",}),
   ({"GG","GG08","Akhmetis Raioni","region/raioni",}),
   ({"GG","GG09","Ambrolauris Raioni","region/raioni",}),
   ({"GG","GG10","Aspindzis Raioni","region/raioni",}),
   ({"GG","GG11","Baghdat'is Raioni","region/raioni",}),
   ({"GG","GG12","Bolnisis Raioni","region/raioni",}),
   ({"GG","GG13","Borjomis Raioni","region/raioni",}),
   ({"GG","GG14","Chiat'ura","city/k'lak'i",}),
   ({"GG","GG15","Ch'khorotsqus Raioni","region/raioni",}),
   ({"GG","GG16","Ch'okhatauris Raioni","region/raioni",}),
   ({"GG","GG17","Dedop'listsqaros Raioni","region/raioni",}),
   ({"GG","GG18","Dmanisis Raioni","region/raioni",}),
   ({"GG","GG19","Dushet'is Raioni","region/raioni",}),
   ({"GG","GG20","Gardabanis Raioni","region/raioni",}),
   ({"GG","GG21","Gori","city/k'lak'i",}),
   ({"GG","GG22","Goris Raioni","region/raioni",}),
   ({"GG","GG23","Gurjaanis Raioni","region/raioni",}),
   ({"GG","GG24","Javis Raioni","region/raioni",}),
   ({"GG","GG25","K'arelis Raioni","region/raioni",}),
   ({"GG","GG26","Kaspis Raioni","region/raioni",}),
   ({"GG","GG27","Kharagaulis Raioni","region/raioni",}),
   ({"GG","GG28","Khashuris Raioni","region/raioni",}),
   ({"GG","GG29","Khobis Raioni","region/raioni",}),
   ({"GG","GG30","Khonis Raioni","region/raioni",}),
   ({"GG","GG31","K'ut'aisi","city/k'lak'i",}),
   ({"GG","GG32","Lagodekhis Raioni","region/raioni",}),
   ({"GG","GG33","Lanch'khut'is Raioni","region/raioni",}),
   ({"GG","GG34","Lentekhis Raioni","region/raioni",}),
   ({"GG","GG35","Marneulis Raioni","region/raioni",}),
   ({"GG","GG36","Martvilis Raioni","region/raioni",}),
   ({"GG","GG37","Mestiis Raioni","region/raioni",}),
   ({"GG","GG38","Mts'khet'is Raioni","region/raioni",}),
   ({"GG","GG39","Ninotsmindis Raioni","region/raioni",}),
   ({"GG","GG40","Onis Raioni","region/raioni",}),
   ({"GG","GG41","Ozurget'is Raioni","region/raioni",}),
   ({"GG","GG42","P'ot'i","city/k'lak'i",}),
   ({"GG","GG43","Qazbegis Raioni","region/raioni",}),
   ({"GG","GG44","Qvarlis Raioni","region/raioni",}),
   ({"GG","GG45","Rust'avi","city/k'lak'i",}),
   ({"GG","GG46","Sach'kheris Raioni","region/raioni",}),
   ({"GG","GG47","Sagarejos Raioni","region/raioni",}),
   ({"GG","GG48","Samtrediis Raioni","region/raioni",}),
   ({"GG","GG49","Senakis Raioni","region/raioni",}),
   ({"GG","GG50","Sighnaghis Raioni","region/raioni",}),
   ({"GG","GG51","T'bilisi","city/k'lak'i",}),
   ({"GG","GG52","T'elavis Raioni","region/raioni",}),
   ({"GG","GG53","T'erjolis Raioni","region/raioni",}),
   ({"GG","GG54","T'et'ritsqaros Raioni","region/raioni",}),
   ({"GG","GG55","T'ianet'is Raioni","region/raioni",}),
   ({"GG","GG56","Tqibuli","city/k'lak'i",}),
   ({"GG","GG57","Ts'ageris Raioni","region/raioni",}),
   ({"GG","GG58","Tsalenjikhis Raioni","region/raioni",}),
   ({"GG","GG59","Tsalkis Raioni","region/raioni",}),
   ({"GG","GG60","Tsqaltubo","city/k'lak'i",}),
   ({"GG","GG61","Vanis Raioni","region/raioni",}),
   ({"GG","GG62","Zestp'onis Raioni","region/raioni",}),
   ({"GG","GG63","Zugdidi","city/k'lak'i",}),
   ({"GG","GG64","Zugdidis Raioni","region/raioni",}),
   ({"GH","GH01","Greater Accra","region",}),
   ({"GH","GH02","Ashanti","region",}),
   ({"GH","GH03","Brong-Ahafo","region",}),
   ({"GH","GH04","Central","region",}),
   ({"GH","GH05","Eastern","region",}),
   ({"GH","GH06","Northern","region",}),
   ({"GH","GH08","Volta","region",}),
   ({"GH","GH09","Western","region",}),
   ({"GH","GH10","Upper East","region",}),
   ({"GH","GH11","Upper West","region",}),
   ({"GJ","GJ01","Saint Andrew","parish",}),
   ({"GJ","GJ02","Saint David","parish",}),
   ({"GJ","GJ03","Saint George","parish",}),
   ({"GJ","GJ04","Saint John","parish",}),
   ({"GJ","GJ05","Saint Mark","parish",}),
   ({"GJ","GJ06","Saint Patrick","parish",}),
   ({"GL","GL01","Nordgronland","municipality",}),
   ({"GL","GL02","Ostgronland","municipality",}),
   ({"GL","GL03","Vestgronland","municipality",}),
   ({"GM","GM01","Baden-Wurttemberg","state/land",}),
   ({"GM","GM02","Bayern","state/land",}),
   ({"GM","GM03","Bremen","state/land",}),
   ({"GM","GM04","Hamburg","state/land",}),
   ({"GM","GM05","Hessen","state/land",}),
   ({"GM","GM06","Niedersachsen","state/land",}),
   ({"GM","GM07","Nordrhein-Westfalen","state/land",}),
   ({"GM","GM08","Rheinland-Pfalz","state/land",}),
   ({"GM","GM09","Saarland","state/land",}),
   ({"GM","GM10","Schleswig-Holstein","state/land",}),
   ({"GM","GM11","Brandenburg","state/land",}),
   ({"GM","GM12","Mecklenburg-Vorpommern","state/land",}),
   ({"GM","GM13","Sachsen","state/land",}),
   ({"GM","GM14","Sachsen-Anhalt","state/land",}),
   ({"GM","GM15","Thuringen","state/land",}),
   ({"GM","GM16","Berlin","state/land",}),
   ({"GR","GR01","Evros","department/nomos",}),
   ({"GR","GR02","Rodhopi","department/nomos",}),
   ({"GR","GR03","Xanthi","department/nomos",}),
   ({"GR","GR04","Drama","department/nomos",}),
   ({"GR","GR05","Serrai","department/nomos",}),
   ({"GR","GR06","Kilkis","department/nomos",}),
   ({"GR","GR07","Pella","department/nomos",}),
   ({"GR","GR08","Florina","department/nomos",}),
   ({"GR","GR09","Kastoria","department/nomos",}),
   ({"GR","GR10","Grevena","department/nomos",}),
   ({"GR","GR11","Kozani","department/nomos",}),
   ({"GR","GR12","Imathia","department/nomos",}),
   ({"GR","GR13","Thessaloniki","department/nomos",}),
   ({"GR","GR14","Kavala","department/nomos",}),
   ({"GR","GR15","Khalkidhiki","department/nomos",}),
   ({"GR","GR16","Pieria","department/nomos",}),
   ({"GR","GR17","Ioannina","department/nomos",}),
   ({"GR","GR18","Thesprotia","department/nomos",}),
   ({"GR","GR19","Preveza","department/nomos",}),
   ({"GR","GR20","Arta","department/nomos",}),
   ({"GR","GR21","Larisa","department/nomos",}),
   ({"GR","GR22","Trikala","department/nomos",}),
   ({"GR","GR23","Kardhitsa","department/nomos",}),
   ({"GR","GR24","Magnisia","department/nomos",}),
   ({"GR","GR25","Kerkira","department/nomos",}),
   ({"GR","GR26","Levkas","department/nomos",}),
   ({"GR","GR27","Kefallinia","department/nomos",}),
   ({"GR","GR28","Zakinthos","department/nomos",}),
   ({"GR","GR29","Fthiotis","department/nomos",}),
   ({"GR","GR30","Evritania","department/nomos",}),
   ({"GR","GR31","Aitolia kai Akarnania","department/nomos",}),
   ({"GR","GR32","Fokis","department/nomos",}),
   ({"GR","GR33","Voiotia","department/nomos",}),
   ({"GR","GR34","Evvoia","department/nomos",}),
   ({"GR","GR35","Attiki","department/nomos",}),
   ({"GR","GR36","Argolis","department/nomos",}),
   ({"GR","GR37","Korinthia","department/nomos",}),
   ({"GR","GR38","Akhaia","department/nomos",}),
   ({"GR","GR39","Ilia","department/nomos",}),
   ({"GR","GR40","Messinia","department/nomos",}),
   ({"GR","GR41","Arkadhia","department/nomos",}),
   ({"GR","GR42","Lakonia","department/nomos",}),
   ({"GR","GR43","Khania","department/nomos",}),
   ({"GR","GR44","Rethimni","department/nomos",}),
   ({"GR","GR45","Iraklion","department/nomos",}),
   ({"GR","GR46","Lasithi","department/nomos",}),
   ({"GR","GR47","Dhodhekanisos","department/nomos",}),
   ({"GR","GR48","Samos","department/nomos",}),
   ({"GR","GR49","Kikladhes","department/nomos",}),
   ({"GR","GR50","Khios","department/nomos",}),
   ({"GR","GR51","Lesvos","department/nomos",}),
   ({"GT","GT01","Alta Verapaz","department/departamento",}),
   ({"GT","GT02","Baja Verapaz","department/departamento",}),
   ({"GT","GT03","Chimaltenango","department/departamento",}),
   ({"GT","GT04","Chiquimula","department/departamento",}),
   ({"GT","GT05","El Progreso","department/departamento",}),
   ({"GT","GT06","Escuintla","department/departamento",}),
   ({"GT","GT07","Guatemala","department/departamento",}),
   ({"GT","GT08","Huehuetenango","department/departamento",}),
   ({"GT","GT09","Izabal","department/departamento",}),
   ({"GT","GT10","Jalapa","department/departamento",}),
   ({"GT","GT11","Jutiapa","department/departamento",}),
   ({"GT","GT12","Peten","department/departamento",}),
   ({"GT","GT13","Quetzaltenango","department/departamento",}),
   ({"GT","GT14","Quiche","department/departamento",}),
   ({"GT","GT15","Retalhuleu","department/departamento",}),
   ({"GT","GT16","Sacatepequez","department/departamento",}),
   ({"GT","GT17","San Marcos","department/departamento",}),
   ({"GT","GT18","Santa Rosa","department/departamento",}),
   ({"GT","GT19","Solola","department/departamento",}),
   ({"GT","GT20","Suchitepequez","department/departamento",}),
   ({"GT","GT21","Totonicapan","department/departamento",}),
   ({"GT","GT22","Zacapa","department/departamento",}),
   ({"GV","GV01","Beyla","administrative region/region administrative",}),
   ({"GV","GV02","Boffa","administrative region/region administrative",}),
   ({"GV","GV03","Boke","administrative region/region administrative",}),
   ({"GV","GV04","Conakry","administrative region/region administrative",}),
   ({"GV","GV05","Dabola","administrative region/region administrative",}),
   ({"GV","GV06","Dalaba","administrative region/region administrative",}),
   ({"GV","GV07","Dinguiraye","administrative region/region administrative",}),
   ({"GV","GV08","Dubreka","administrative region/region administrative",}),
   ({"GV","GV09","Faranah","administrative region/region administrative",}),
   ({"GV","GV10","Forecariah","administrative region/region administrative",}),
   ({"GV","GV11","Fria","administrative region/region administrative",}),
   ({"GV","GV12","Gaoual","administrative region/region administrative",}),
   ({"GV","GV13","Gueckedou","administrative region/region administrative",}),
   ({"GV","GV14","Kankan","administrative region/region administrative",}),
   ({"GV","GV15","Kerouane","administrative region/region administrative",}),
   ({"GV","GV16","Kindia","administrative region/region administrative",}),
   ({"GV","GV17","Kissidougou","administrative region/region administrative",}),
   ({"GV","GV18","Koundara","administrative region/region administrative",}),
   ({"GV","GV19","Kouroussa","administrative region/region administrative",}),
   ({"GV","GV20","Labe","administrative region/region administrative",}),
   ({"GV","GV21","Macenta","administrative region/region administrative",}),
   ({"GV","GV22","Mali","administrative region/region administrative",}),
   ({"GV","GV23","Mamou","administrative region/region administrative",}),
   ({"GV","GV24","Nzerekore","administrative region/region administrative",}),
   ({"GV","GV25","Pita","administrative region/region administrative",}),
   ({"GV","GV26","Siguiri","administrative region/region administrative",}),
   ({"GV","GV27","Telimele","administrative region/region administrative",}),
   ({"GV","GV28","Tougue","administrative region/region administrative",}),
   ({"GV","GV29","Yomou","administrative region/region administrative",}),
   ({"GY","GY10","Barima-Waini","region",}),
   ({"GY","GY11","Cuyuni-Mazaruni","region",}),
   ({"GY","GY12","Demerara-Mahaica","region",}),
   ({"GY","GY13","East Berbice-Corentyne","region",}),
   ({"GY","GY14","Essequibo Islands-West Demerara","region",}),
   ({"GY","GY15","Mahaica-Berbice","region",}),
   ({"GY","GY16","Pomeroon-Supenaam","region",}),
   ({"GY","GY17","Potaro-Siparuni","region",}),
   ({"GY","GY18","Upper Demerara-Berbice","region",}),
   ({"GY","GY19","Upper Takutu-Upper Essequibo","region",}),
   ({"HA","HA03","Nord-Ouest","department/departement",}),
   ({"HA","HA06","Artibonite","department/departement",}),
   ({"HA","HA07","Centre","department/departement",}),
   ({"HA","HA08","Grand'Anse","department/departement",}),
   ({"HA","HA09","Nord","department/departement",}),
   ({"HA","HA10","Nord-Est","department/departement",}),
   ({"HA","HA11","Ouest","department/departement",}),
   ({"HA","HA12","Sud","department/departement",}),
   ({"HA","HA13","Sud-Est","department/departement",}),
   ({"HO","HO01","Atlantida","department/departamento",}),
   ({"HO","HO02","Choluteca","department/departamento",}),
   ({"HO","HO03","Colon","department/departamento",}),
   ({"HO","HO04","Comayagua","department/departamento",}),
   ({"HO","HO05","Copan","department/departamento",}),
   ({"HO","HO06","Cortes","department/departamento",}),
   ({"HO","HO07","El Paraiso","department/departamento",}),
   ({"HO","HO08","Francisco Morazan","department/departamento",}),
   ({"HO","HO09","Gracias a Dios","department/departamento",}),
   ({"HO","HO10","Intibuca","department/departamento",}),
   ({"HO","HO11","Islas de la Bahia","department/departamento",}),
   ({"HO","HO12","La Paz","department/departamento",}),
   ({"HO","HO13","Lempira","department/departamento",}),
   ({"HO","HO14","Ocotepeque","department/departamento",}),
   ({"HO","HO15","Olancho","department/departamento",}),
   ({"HO","HO16","Santa Barbara","department/departamento",}),
   ({"HO","HO17","Valle","department/departamento",}),
   ({"HO","HO18","Yoro","department/departamento",}),
   ({"HR","HR01","Bjelovarsko-Bilogorska","county/zupanija",}),
   ({"HR","HR02","Brodsko-Posavka","county/zupanija",}),
   ({"HR","HR03","Dubrovacko-Neretvanska","county/zupanija",}),
   ({"HR","HR04","Istarska","county/zupanija",}),
   ({"HR","HR05","Karlovacka","county/zupanija",}),
   ({"HR","HR06","Koprivnicko-Krizevacka","county/zupanija",}),
   ({"HR","HR07","Krapinsko-Zagorska","county/zupanija",}),
   ({"HR","HR08","Licko-Senjska","county/zupanija",}),
   ({"HR","HR09","Medimurska","county/zupanija",}),
   ({"HR","HR10","Osjecko-Baranjska","county/zupanija",}),
   ({"HR","HR11","Pozesko-Slavonska","county/zupanija",}),
   ({"HR","HR12","Primorsko-Goranska","county/zupanija",}),
   ({"HR","HR13","Sibensko-Kninska","county/zupanija",}),
   ({"HR","HR14","Sisacko-Moslavacka","county/zupanija",}),
   ({"HR","HR15","Splitsko-Dalmatinska","county/zupanija",}),
   ({"HR","HR16","Varazdinska","county/zupanija",}),
   ({"HR","HR17","Viroviticko-Podravska","county/zupanija",}),
   ({"HR","HR18","Vukovarsko-Srijemska","county/zupanija",}),
   ({"HR","HR19","Zadarska","county/zupanija",}),
   ({"HR","HR20","Zagrebacka","county/zupanija",}),
   ({"HR","HR21","Grad Zagreb"," city/grad",}),
   ({"HU","HU01","Bacs-Kiskun","county/megye",}),
   ({"HU","HU02","Baranya","county/megye",}),
   ({"HU","HU03","Bekes","county/megye",}),
   ({"HU","HU04","Borsod-Abauj-Zemplen","county/megye",}),
   ({"HU","HU05","Budapest","capital city/fovaros",}),
   ({"HU","HU06","Csongrad","county/megye",}),
   ({"HU","HU07","Debrecen","urban county/megyei varos",}),
   ({"HU","HU08","Fejer","county/megye",}),
   ({"HU","HU09","Gyor-Moson-Sopron","county/megye",}),
   ({"HU","HU10","Hajdu-Bihar","county/megye",}),
   ({"HU","HU11","Heves","county/megye",}),
   ({"HU","HU12","Komarom-Esztergom","county/megye",}),
   ({"HU","HU13","Miskolc","urban county/megyei varos",}),
   ({"HU","HU14","Nograd","county/megye",}),
   ({"HU","HU15","Pees","urban county/megyei varos",}),
   ({"HU","HU16","Pest","county/megye",}),
   ({"HU","HU17","Somogy","county/megye",}),
   ({"HU","HU18","Szabolcs-Szatmar-Bereg","county/megye",}),
   ({"HU","HU19","Szeged","urban county/megyei varos",}),
   ({"HU","HU20","Jasz-Nagykun-Szolnok","county/megye",}),
   ({"HU","HU21","Tolna","county/megye",}),
   ({"HU","HU22","Vas","county/megye",}),
   ({"HU","HU23","Veszprem","county/megye",}),
   ({"HU","HU24","Zala","county/megye",}),
   ({"HU","HU25","Gyor","urban county/megyei varos",}),
   ({"HU","HU26","Bekescsaba","urban county/megyei varos",}),
   ({"HU","HU27","Dunaujvaros","urban county/megyei varos",}),
   ({"HU","HU28","Eger","urban county/megyei varos",}),
   ({"HU","HU29","Hodmezovasarhely","urban county/megyei varos",}),
   ({"HU","HU30","Kaposvar","urban county/megyei varos",}),
   ({"HU","HU31","Kecskemet","urban county/megyei varos",}),
   ({"HU","HU32","Nagykanizsa","urban county/megyei varos",}),
   ({"HU","HU33","Nyiregyhaza","urban county/megyei varos",}),
   ({"HU","HU34","Sopron","urban county/megyei varos",}),
   ({"HU","HU35","Szekesfehervar","urban county/megyei varos",}),
   ({"HU","HU36","Szolnok","urban county/megyei varos",}),
   ({"HU","HU37","Szombathely","urban county/megyei varos",}),
   ({"HU","HU38","Tatabanya","urban county/megyei varos",}),
   ({"HU","HU39","Veszprem","urban county/megyei varos",}),
   ({"HU","HU40","Zalaegerszeg","urban county/megyei varos",}),
   ({"IC","IC01","Akranes","independent town/kaupstadir",}),
   ({"IC","IC02","Akureyri","independent town/kaupstadir",}),
   ({"IC","IC03","Arnessysla","county/sysia",}),
   ({"IC","IC04","Austur-Bardastrandarsysla","county/sysia",}),
   ({"IC","IC05","Austur-Hunavatnssysla","county/sysia",}),
   ({"IC","IC06","Austur-Skaftafellssysla","county/sysia",}),
   ({"IC","IC07","Borgarfjardarsysla","county/sysia",}),
   ({"IC","IC08","Dalasysla","county/sysia",}),
   ({"IC","IC09","Eyjafjardarsysla","county/sysia",}),
   ({"IC","IC10","Gullbringusysla","county/sysia",}),
   ({"IC","IC11","Hafnarfjordur","independent town/kaupstadir",}),
   ({"IC","IC12","Husavik","independent town/kaupstadir",}),
   ({"IC","IC13","Isafjordur","independent town/kaupstadir",}),
   ({"IC","IC14","Keflavik","independent town/kaupstadir",}),
   ({"IC","IC15","Kjosarsysla","county/sysia",}),
   ({"IC","IC16","Kopavogur","independent town/kaupstadir",}),
   ({"IC","IC17","Myrasysla","county/sysia",}),
   ({"IC","IC18","Neskaupstadur","independent town/kaupstadir",}),
   ({"IC","IC19","Nordur-Isafjardarsysla","county/sysia",}),
   ({"IC","IC20","Nordur-Mulasysla","county/sysia",}),
   ({"IC","IC21","Nordur-Tingeyjarsysla","county/sysia",}),
   ({"IC","IC22","Olafsfjordur","independent town/kaupstadir",}),
   ({"IC","IC23","Rang\267rvallasysla","county/sysia",}),
   ({"IC","IC24","Reykjavik","independent town/kaupstadir",}),
   ({"IC","IC25","Saudarkrokur","independent town/kaupstadir",}),
   ({"IC","IC26","Seydisfjordur","independent town/kaupstadir",}),
   ({"IC","IC27","Siglufjordur","independent town/kaupstadir",}),
   ({"IC","IC28","Skagafjardarsysla","county/sysia",}),
   ({"IC","IC29","Snafellsnes-og Hnappadalssysla","county/sysia",}),
   ({"IC","IC30","Strandasysla","county/sysia",}),
   ({"IC","IC31","Sudur-Mulasysla","county/sysia",}),
   ({"IC","IC32","Sudur-Tingeyjarsysla","county/sysia",}),
   ({"IC","IC33","Vestmannaeyjar","independent town/kaupstadir",}),
   ({"IC","IC34","Vestur-Bardastrandarsysla","county/sysia",}),
   ({"IC","IC35","Vestur-Hunavatnssysla","county/sysia",}),
   ({"IC","IC36","Vestur-Isafjardarsysla","county/sysia",}),
   ({"IC","IC37","Vestur-Skaftafellssysla","county/sysia",}),
   ({"ID","ID01","Aceh Atjeh","special region/daerah istimewa",}),
   ({"ID","ID02","Bali","province/propinsi",}),
   ({"ID","ID03","Bengkulu","province/propinsi",}),
   ({"ID","ID04","Jakarta Raya Djakarta Raya","special district/daerah khusus ibukota",}),
   ({"ID","ID05","Jambi Djambi","province/propinsi",}),
   ({"ID","ID06","Jawa Barat Djawa Barat","province/propinsi",}),
   ({"ID","ID07","Jawa Tengah Djawa Tengah","province/propinsi",}),
   ({"ID","ID08","Jawa Timur Djawa Timur","province/propinsi",}),
   ({"ID","ID09","Irian Jaya","province/propinsi",}),
   ({"ID","ID10","Yogyakarta Jogjakarta","special region/daerah istimewa",}),
   ({"ID","ID11","Kalimantan Barat","province/propinsi",}),
   ({"ID","ID12","Kalimantan Selatan","province/propinsi",}),
   ({"ID","ID13","Kalimantan Tengah","province/propinsi",}),
   ({"ID","ID14","Kalimantan Timur","province/propinsi",}),
   ({"ID","ID15","Lampung","province/propinsi",}),
// ({"ID","ID16","Maluku","province/propinsi",}),	// obsolete
   ({"ID","ID17","Nusa Tenggara Barat","province/propinsi",}),
   ({"ID","ID18","Nusa Tenggara Timur","province/propinsi",}),
   ({"ID","ID19","Riau","province/propinsi",}),
   ({"ID","ID20","Sulawesi Selatan","province/propinsi",}),
   ({"ID","ID21","Sulawesi Tengah","province/propinsi",}),
   ({"ID","ID22","Sulawesi Tenggara","province/propinsi",}),
   ({"ID","ID23","Sulawesi Utara","province/propinsi",}),
   ({"ID","ID24","Sumatera Barat","province/propinsi",}),
   ({"ID","ID25","Sumatera Selatan","province/propinsi",}),
   ({"ID","ID26","Sumatera Utara","province/propinsi",}),
// ({"ID","ID27","Timor Timur","province/propinsi",}),	// obsolete
   ({"ID","ID28","Maluku","province/propinsi",}),
   ({"ID","ID29","Maluku Utara","province/propinsi",}),
   ({"IN","IN01","Andaman and Nicobar Islands","union territory",}),
   ({"IN","IN02","Andhra Pradesh","state",}),
   ({"IN","IN03","Assam","state",}),
   ({"IN","IN04","Bihar","state",}),
   ({"IN","IN05","Chandigarh","union territory",}),
   ({"IN","IN06","Dadra and Nagar Haveli","union territory",}),
   ({"IN","IN07","Delhi","union territory",}),
   ({"IN","IN09","Gujarat","state",}),
   ({"IN","IN10","Haryana","state",}),
   ({"IN","IN11","Himachal Pradesh","state",}),
   ({"IN","IN12","Jammu and Kashmir","state",}),
   ({"IN","IN13","Kerala","state",}),
   ({"IN","IN14","Lakshadweep Laccadive, Minacoy, and Amindivi Islands","union territory",}),
   ({"IN","IN15","Madhya Pradesh","state",}),
   ({"IN","IN16","Maharashtra","state",}),
   ({"IN","IN17","Manipur","state",}),
   ({"IN","IN18","Meghalaya","state",}),
   ({"IN","IN19","Karnataka","state",}),
   ({"IN","IN20","Nagaland","state",}),
   ({"IN","IN21","Orissa","state",}),
   ({"IN","IN22","Pondicherry","union territory",}),
   ({"IN","IN23","Punjab","state",}),
   ({"IN","IN24","Rajasthan","state",}),
   ({"IN","IN25","Tamil Nadu Madris","state",}),
   ({"IN","IN26","Tripura","state",}),
   ({"IN","IN27","Uttar Pradesh","state",}),
   ({"IN","IN28","West Bengal","state",}),
   ({"IN","IN29","Sikkim","state",}),
   ({"IN","IN30","Arunachal Pradesh","state",}),
   ({"IN","IN31","Mizoram","union territory",}),
   ({"IN","IN32","Daman and Diu","union territory",}),
   ({"IN","IN33","Goa","state",}),
   ({"IR","IR01","Azarbayjan-e Gharbi","province/ostan",}),
// ({"IR","IR02","Azarbayjan-e Klavari","province/ostan",}),	// obsolete
   ({"IR","IR03","Chahar Ma\261all va Bakhtiari","province/ostan",}),
   ({"IR","IR04","Sistan va Baluchestan","province/ostan",}),
   ({"IR","IR05","Kohgiluyeh va Buyer Ahmad","province/ostan",}),
   ({"IR","IR07","Fars","province/ostan",}),
   ({"IR","IR08","Gilan","province/ostan",}),
   ({"IR","IR09","Hamadan","province/ostan",}),
   ({"IR","IR10","Ilam","province/ostan",}),
   ({"IR","IR11","Hormozgan","province/ostan",}),
   ({"IR","IR12","IR12","province/ostan",}),
   ({"IR","IR13","Kermanshah","province/ostan",}),
   ({"IR","IR15","Khuzestan","province/ostan",}),
   ({"IR","IR16","Kordestan","province/ostan",}),
// ({"IR","IR17","Mazandaran","province/ostan",}),	// obsolete
   ({"IR","IR18","IR18","province/ostan",}),
   ({"IR","IR19","IR19","province/ostan",}),
   ({"IR","IR21","IR21","province/ostan",}),
   ({"IR","IR22","Bushehr","province/ostan",}),
   ({"IR","IR23","Lorestan","province/ostan",}),
// ({"IR","IR24","Markazi","province/ostan",}),	// obsolete
   ({"IR","IR25","Semnan","province/ostan",}),
   ({"IR","IR26","Tehran","province/ostan",}),
// ({"IR","IR27","Zanjan","province/ostan",}),	// obsolete
   ({"IR","IR28","Esfahan","province/ostan",}),
   ({"IR","IR29","Kerman","province/ostan",}),
   ({"IR","IR30","Khorasan","province/ostan",}),
   ({"IR","IR31","Yazd","province/ostan",}),
   ({"IR","IR32","Ardabil","province/ostan",}),
   ({"IR","IR33","Azarbayjan-e Sharqi","province/ostan",}),
   ({"IR","IR34","Markazi","province/ostan",}),
   ({"IR","IR35","Mazandaran","province/ostan",}),
   ({"IR","IR36","Zanjan","province/ostan",}),
   ({"IR","IR37","Golestan","province/ostan",}),
   ({"IR","IR38","Qazvin","province/ostan",}),
   ({"IR","IR39","Qom","province/ostan",}),
   ({"IS","IS01","HaDarom ","district/mehoz","Southern",}),
   ({"IS","IS02","HaMerkaz ","district/mehoz","Central",}),
   ({"IS","IS03","Ha\373afon ","district/mehoz","Northern",}),
   ({"IS","IS04","H\355efa ","district/mehoz","Haifa",}),
   ({"IS","IS05","Tel Aviv","district/mehoz",}),
   ({"IS","IS06","Yerushalayim ","district/mehoz","Jerusalem",}),
   ({"IT","IT01","Abruzzi","region/regione",}),
   ({"IT","IT02","Basilicata","region/regione",}),
   ({"IT","IT03","Calabria","region/regione",}),
   ({"IT","IT04","Campania","region/regione",}),
   ({"IT","IT05","Emilia-Romagna","region/regione",}),
   ({"IT","IT06","Friuli-Venezia Giulia","region/regione",}),
   ({"IT","IT07","Lazio","region/regione",}),
   ({"IT","IT08","Liguria","region/regione",}),
   ({"IT","IT09","Lombardia","region/regione",}),
   ({"IT","IT10","Marche","region/regione",}),
   ({"IT","IT11","Molise","region/regione",}),
   ({"IT","IT12","Piemonte","region/regione",}),
   ({"IT","IT13","Puglia","region/regione",}),
   ({"IT","IT14","Sardegna","region/regione",}),
   ({"IT","IT15","Sicilia","region/regione",}),
   ({"IT","IT16","Toscana","region/regione",}),
   ({"IT","IT17","Trentino-Alto Adige","region/regione",}),
   ({"IT","IT18","Umbria","region/regione",}),
   ({"IT","IT19","Valle d'Aosta","region/regione",}),
   ({"IT","IT20","Veneto","region/regione",}),
// ({"IV","IV01","Abengourou","department/departement",}),	// obsolete
   ({"IV","IV03","Dabakala","department/departement",}),
   ({"IV","IV04","Aboisso","department/departement",}),
   ({"IV","IV05","Adzope","department/departement",}),
   ({"IV","IV06","Agboville","department/departement",}),
   ({"IV","IV07","Biankouma","department/departement",}),
   ({"IV","IV11","Bouna","department/departement",}),
   ({"IV","IV12","Boundiali","department/departement",}),
   ({"IV","IV14","Danane","department/departement",}),
   ({"IV","IV16","Divo","department/departement",}),
   ({"IV","IV17","Ferkessedougou","department/departement",}),
   ({"IV","IV18","Gagnoa","department/departement",}),
   ({"IV","IV20","Katiola","department/departement",}),
   ({"IV","IV21","Korhogo","department/departement",}),
   ({"IV","IV23","Odienne","department/departement",}),
   ({"IV","IV25","Seguela","department/departement",}),
   ({"IV","IV26","Touba","department/departement",}),
   ({"IV","IV27","Bongouanou","department/departement",}),
   ({"IV","IV28","Issia","department/departement",}),
   ({"IV","IV29","Lakota","department/departement",}),
   ({"IV","IV30","Mankono","department/departement",}),
   ({"IV","IV31","Oume","department/departement",}),
   ({"IV","IV32","Soubre","department/departement",}),
   ({"IV","IV33","Tingrela","department/departement",}),
   ({"IV","IV34","Zuenoula","department/departement",}),
   ({"IV","IV35","Abidjan","department/departement",}),
   ({"IV","IV36","Bangolo","department/departement",}),
   ({"IV","IV37","Beoumi","department/departement",}),
   ({"IV","IV38","Bondoukou","department/departement",}),
   ({"IV","IV39","Bouafle","department/departement",}),
   ({"IV","IV40","Bouake","department/departement",}),
   ({"IV","IV41","Daloa","department/departement",}),
   ({"IV","IV42","Daoukro","department/departement",}),
   ({"IV","IV43","Dimbokro","department/departement",}),
   ({"IV","IV44","Duekoue","department/departement",}),
   ({"IV","IV45","Grand-Lahou","department/departement",}),
   ({"IV","IV46","Guiglo","department/departement",}),
   ({"IV","IV47","Man","department/departement",}),
   ({"IV","IV48","Mbahiakro","department/departement",}),
   ({"IV","IV49","Sakassou","department/departement",}),
   ({"IV","IV50","San Pedro","department/departement",}),
   ({"IV","IV51","Sassandra","department/departement",}),
   ({"IV","IV52","Sinfra","department/departement",}),
   ({"IV","IV53","Tabou","department/departement",}),
   ({"IV","IV54","Tanda","department/departement",}),
   ({"IV","IV55","Tiassale","department/departement",}),
   ({"IV","IV56","Toumodi","department/departement",}),
   ({"IV","IV57","Vavoua","department/departement",}),
   ({"IV","IV58","Yamoussoukro","department/departement",}),
   ({"IV","IV59","Abengourou","department/departement",}),
   ({"IV","IV60","Agnilbilekrou","department/departement",}),
   ({"IZ","IZ01","Al Anbar","province/muhafazah",}),
   ({"IZ","IZ02","Al Basrah","province/muhafazah",}),
   ({"IZ","IZ03","Al Muthann\267","province/muhafazah",}),
   ({"IZ","IZ04","Al Qadisiyah","province/muhafazah",}),
   ({"IZ","IZ05","As Sulaymaniyah","province/muhafazah",}),
   ({"IZ","IZ06","Babil","province/muhafazah",}),
   ({"IZ","IZ07","Baghdad","province/muhafazah",}),
   ({"IZ","IZ08","Dahuk","province/muhafazah",}),
   ({"IZ","IZ09","Dhi Qar","province/muhafazah",}),
   ({"IZ","IZ10","Diyala","province/muhafazah",}),
   ({"IZ","IZ11","Arbil","province/muhafazah",}),
   ({"IZ","IZ12","Karbala'","province/muhafazah",}),
   ({"IZ","IZ13","At Ta'mim","province/muhafazah",}),
   ({"IZ","IZ14","Maysan","province/muhafazah",}),
   ({"IZ","IZ15","Ninawa","province/muhafazah",}),
   ({"IZ","IZ16","Wasit","province/muhafazah",}),
   ({"IZ","IZ17","An Najaf","province/muhafazah",}),
   ({"IZ","IZ18","S\361alah ad Din","province/muhafazah",}),
   ({"JA","JA01","Aichi","perfecture",}),
   ({"JA","JA02","Akita","perfecture",}),
   ({"JA","JA03","Aomori","perfecture",}),
   ({"JA","JA04","Chiba","perfecture",}),
   ({"JA","JA05","Ehime","perfecture",}),
   ({"JA","JA06","Fukui","perfecture",}),
   ({"JA","JA07","Fukuoka","perfecture",}),
   ({"JA","JA08","Fukushima","perfecture",}),
   ({"JA","JA09","Gifu","perfecture",}),
   ({"JA","JA10","Gumma","perfecture",}),
   ({"JA","JA11","Hiroshima","perfecture",}),
   ({"JA","JA12","Hokkaido","perfecture",}),
   ({"JA","JA13","Hyogo","perfecture",}),
   ({"JA","JA14","Ibaraki","perfecture",}),
   ({"JA","JA15","Ishikawa","perfecture",}),
   ({"JA","JA16","Iwate","perfecture",}),
   ({"JA","JA17","Kagawa","perfecture",}),
   ({"JA","JA18","Kagoshima","perfecture",}),
   ({"JA","JA19","Kanagawa","perfecture",}),
   ({"JA","JA20","Kochi","perfecture",}),
   ({"JA","JA21","Kumamoto","perfecture",}),
   ({"JA","JA22","Kyoto","perfecture",}),
   ({"JA","JA23","Mie","perfecture",}),
   ({"JA","JA24","Miyagi","perfecture",}),
   ({"JA","JA25","Miyazaki","perfecture",}),
   ({"JA","JA26","Nagano","perfecture",}),
   ({"JA","JA27","Nagasaki","perfecture",}),
   ({"JA","JA28","Nara","perfecture",}),
   ({"JA","JA29","Niigata","perfecture",}),
   ({"JA","JA30","Oita","perfecture",}),
   ({"JA","JA31","Okayama","perfecture",}),
   ({"JA","JA32","Osaka","perfecture",}),
   ({"JA","JA33","Saga","perfecture",}),
   ({"JA","JA34","Saitama","perfecture",}),
   ({"JA","JA35","Shiga","perfecture",}),
   ({"JA","JA36","Shimane","perfecture",}),
   ({"JA","JA37","Shizuoka","perfecture",}),
   ({"JA","JA38","Tochigi","perfecture",}),
   ({"JA","JA39","Tokushima","perfecture",}),
   ({"JA","JA40","Tokyo","perfecture",}),
   ({"JA","JA41","Tottori","perfecture",}),
   ({"JA","JA42","Toyama","perfecture",}),
   ({"JA","JA43","Wakayama","perfecture",}),
   ({"JA","JA44","Yamagata","perfecture",}),
   ({"JA","JA45","Yamaguchi","perfecture",}),
   ({"JA","JA46","Yamanashi","perfecture",}),
   ({"JA","JA47","Okinawa","perfecture",}),
   ({"JM","JM01","Clarendon","parish",}),
   ({"JM","JM02","Hanover","parish",}),
   ({"JM","JM04","Manchester","parish",}),
   ({"JM","JM07","Portland","parish",}),
   ({"JM","JM08","Saint Andrew","parish",}),
   ({"JM","JM09","Saint Ann","parish",}),
   ({"JM","JM10","Saint Catherine","parish",}),
   ({"JM","JM11","Saint Elizabeth","parish",}),
   ({"JM","JM12","Saint James","parish",}),
   ({"JM","JM13","Saint Mary","parish",}),
   ({"JM","JM14","Saint Thomas","parish",}),
   ({"JM","JM15","Trelawny","parish",}),
   ({"JM","JM16","Westmoreland","parish",}),
   ({"JM","JM17","KingstonSaint John","parish",}),
   ({"JO","JO02","Al Balqa'","governorate/muhafazah",}),
// ({"JO","JO07","Ma'an","governorate/muhafazah",}),	// obsolete
   ({"JO","JO09","Al Karak","governorate/muhafazah",}),
// ({"JO","JO10","Al Mafraq","governorate/muhafazah",}),	// obsolete
// ({"JO","JO11","'Amman","governorate/muhafazah",}),	// obsolete
   ({"JO","JO12","At Tafilah","governorate/muhafazah",}),
// ({"JO","JO13","Az Zaraq","governorate/muhafazah",}),	// obsolete
// ({"JO","JO14","Irbid","governorate/muhafazah",}),	// obsolete
   ({"JO","JO15","Al Mafraq","governorate/muhafazah",}),
   ({"JO","JO16","'Amman","governorate/muhafazah",}),
   ({"JO","JO17","Az Zaraq","governorate/muhafazah",}),
   ({"JO","JO18","Irbid","governorate/muhafazah",}),
   ({"JO","JO19","Ma'an","governorate/muhafazah",}),
   ({"JO","JO20","Ajlun","governorate/muhafazah",}),
   ({"JO","JO21","Al Aqabah","governorate/muhafazah",}),
   ({"JO","JO22","Jarash","governorate/muhafazah",}),
   ({"JO","JO23","Vassa","governorate/muhafazah",}),
   ({"KE","KE01","Central","province",}),
   ({"KE","KE02","Coast","province",}),
   ({"KE","KE03","Eastern","province",}),
   ({"KE","KE05","Nairobi Area","area",}),
   ({"KE","KE06","NorthEastern","province",}),
   ({"KE","KE07","Nyanza","province",}),
   ({"KE","KE08","Rift Valley","province",}),
   ({"KE","KE09","Western","province",}),
   ({"KG","KG01","Bishkek","city/sharry",}),
   ({"KG","KG02","Chuy","oblast/oblasty",}),
   ({"KG","KG03","Jalal-Abad","oblast/oblasty",}),
   ({"KG","KG04","Naryn","oblast/oblasty",}),
// ({"KG","KG05","Osh","oblast/oblasty",}),	// obsolete
   ({"KG","KG06","Talas","oblast/oblasty",}),
   ({"KG","KG07","Ysyk-Kol","oblast/oblasty",}),
   ({"KG","KG08","Osh","oblast/oblasty",}),
   ({"KG","KG09","Batken","oblast/oblasty",}),
   ({"KN","KN01","Chagang-do","province",}),
   ({"KN","KN03","Hamgyong-namdo","province",}),
   ({"KN","KN06","Hwanghae-namdo","province",}),
   ({"KN","KN07","Hwanghae-bukto","province",}),
   ({"KN","KN08","Kaesong-si","special city",}),
   ({"KN","KN09","Kangwon-do","province",}),
   ({"KN","KN11","P'yongan-bukto","province",}),
   ({"KN","KN12","P'yongyang-si","special city",}),
   ({"KN","KN13","Yanggang-do","province",}),
   ({"KN","KN14","Namp'o-si","special city",}),
   ({"KN","KN15","P'yongan-bukto","province",}),
   ({"KN","KN16","Hamgyong-bukto","province",}),
   ({"KR","KR01","Gilbert Islands","islands",}),
   ({"KR","KR02","Line Islands","islands",}),
   ({"KR","KR03","Phoenix Islands","islands",}),
   ({"KS","KS01","Cheju-do","province",}),
   ({"KS","KS03","Cholla-bukto","province",}),
   ({"KS","KS05","Ch'ungch'ong-bukto","province",}),
   ({"KS","KS06","Kangwon-do","province",}),
   ({"KS","KS08","Kyongsang-namdo","province",}),
   ({"KS","KS10","Pusan-gwangyoksi","special city",}),
   ({"KS","KS11","Soul-t'ukpyolsi","special city",}),
   ({"KS","KS12","Inch'on-gwangyoksi","special city",}),
   ({"KS","KS13","Kyonggi-do","province",}),
   ({"KS","KS14","Kyongsang-bukto","province",}),
   ({"KS","KS15","Taegu-gwangyoksi","special city",}),
   ({"KS","KS16","Cholla-namdo","province",}),
   ({"KS","KS17","Ch'ungch'ong-namdo","province",}),
   ({"KS","KS18","Kwangju-gwangyoksi","special city",}),
   ({"KS","KS19","Taejon-gwangyoksi","province",}),
   ({"KU","KU02","Al Asimah","governorate/muhafazah",}),
   ({"KU","KU03","Hawalli","governorate/muhafazah",}),
   ({"KU","KU04","Al Ahmadi","governorate/muhafazah",}),
   ({"KU","KU05","Al Jahra'","governorate/muhafazah",}),
   ({"KU","KU06","Al Farwaniyah","governorate/muhafazah",}),
   ({"KZ","KZ01","Almaty","oblast/oblysy",}),
   ({"KZ","KZ02","Almaty","city/qalasy",}),
   ({"KZ","KZ03","Aqmola","oblast/oblysy",}),
   ({"KZ","KZ04","Aqtobe","oblast/oblysy",}),
   ({"KZ","KZ05","Astana","oblast/oblysy",}),
   ({"KZ","KZ06","Atyrau","oblast/oblysy",}),
   ({"KZ","KZ07","Batys Qazaqstan","oblast/oblysy",}),
   ({"KZ","KZ08","Bayqongyr","city/qalasy",}),
   ({"KZ","KZ09","Mangghystau","oblast/oblysy",}),
   ({"KZ","KZ10","Ongtustik Qazaqstan","oblast/oblysy",}),
   ({"KZ","KZ11","Pavlodar","oblast/oblysy",}),
   ({"KZ","KZ12","Qaraghandy","oblast/oblysy",}),
   ({"KZ","KZ13","Qostanay","oblast/oblysy",}),
   ({"KZ","KZ14","Qyzylorda","oblast/oblysy",}),
   ({"KZ","KZ15","Shyghys Qazaqstan","oblast/oblysy",}),
   ({"KZ","KZ16","Soltustik Qazaqstan","oblast/oblysy",}),
   ({"KZ","KZ17","Zhambyl","oblast/oblysy",}),
   ({"LA","LA01","Attapu","province/khoueng",}),
   ({"LA","LA02","Champasak","province/khoueng",}),
   ({"LA","LA03","Houaphan","province/khoueng",}),
// ({"LA","LA04","Houaphan","province/khoueng",}),	// obsolete
// ({"LA","LA06","Louangphraband","province/khoueng",}),	// obsolete
   ({"LA","LA07","Oudomxai","province/khoueng",}),
// ({"LA","LA08","Phongsali","province/khoueng",}),	// obsolete
// ({"LA","LA09","Saravan","province/khoueng",}),	// obsolete
// ({"LA","LA10","Savannakhet","province/khoueng",}),	// obsolete
// ({"LA","LA11","Vientiane","province/khoueng",}),	// obsolete
   ({"LA","LA13","Xiagnabouli","province/khoueng",}),
   ({"LA","LA14","Xiangkhoang","province/khoueng",}),
   ({"LA","LA15","Khammouan","province/khoueng",}),
   ({"LA","LA16","Louangnamtha","province/khoueng",}),
   ({"LA","LA17","Louangphabang","province/khoueng",}),
   ({"LA","LA18","Phongsali","province/khoueng",}),
   ({"LA","LA19","Salavan","province/khoueng",}),
   ({"LA","LA20","Savannakhet","province/khoueng",}),
   ({"LA","LA21","","province/khoueng","Viangchan",}),
   ({"LA","LA22","Bokeo","province/khoueng",}),
   ({"LA","LA23","Bolikhamxai","province/khoueng",}),
   ({"LA","LA24","Viangchan"," city/kampeng nakhon",}),
   ({"LA","LA25","Xaisomboun","special zone/khetphiset",}),
   ({"LA","LA26","Xekong","province/khoueng",}),
   ({"LA","LA27","Viangchan","province/khoueng",}),
   ({"LE","LE01","Al Biqa'","governorate/muhafazah",}),
   ({"LE","LE02","Al Janub","governorate/muhafazah",}),
   ({"LE","LE03","Ash Shamal","governorate/muhafazah",}),
   ({"LE","LE04","Bayrut","governorate/muhafazah",}),
   ({"LE","LE05","Jabal Lubnan","governorate/muhafazah",}),
   ({"LG","LG01","Aizjrayjkes Rajons","Region",}),
   ({"LG","LG02","Aluksnes Rajons","Region",}),
   ({"LG","LG03","Balvu Rajons","Region",}),
   ({"LG","LG04","Bauskas Rajons","Region",}),
   ({"LG","LG05","Cesu Rajons","Region",}),
   ({"LG","LG06","Daugavpils","Region",}),
   ({"LG","LG07","Daugavpils Rajons","Region",}),
   ({"LG","LG08","Dobeles Rajons","Region",}),
   ({"LG","LG09","Gulbenes Rajons","Region",}),
   ({"LG","LG10","Jekabpils Rajons","Region",}),
   ({"LG","LG11","Jelgava","Region",}),
   ({"LG","LG12","Jelgavas Rajons","Region",}),
   ({"LG","LG13","Jurmala","Region",}),
   ({"LG","LG14","Kraslavas Rajons","Region",}),
   ({"LG","LG15","Kuldigas Rajons","Region",}),
   ({"LG","LG16","Liepaja","Region",}),
   ({"LG","LG17","Liepajas Rajons","Region",}),
   ({"LG","LG18","Limbazu Rajons","Region",}),
   ({"LG","LG19","Ludzas Rajons","Region",}),
   ({"LG","LG20","Madonas Rajons","Region",}),
   ({"LG","LG21","Ogres Rajons","Region",}),
   ({"LG","LG22","Preiju Rajons","Region",}),
   ({"LG","LG23","Rezekne","Region",}),
   ({"LG","LG24","Rezeknes Rajons","Region",}),
   ({"LG","LG25","Riga","Region",}),
   ({"LG","LG26","Rigas Rajons","Region",}),
   ({"LG","LG27","Saldus Rajons","Region",}),
   ({"LG","LG28","Talsu Rajons","Region",}),
   ({"LG","LG29","Tukuma Rajons","Region",}),
   ({"LG","LG30","Valkas Rajons","Region",}),
   ({"LG","LG31","Valmieras Rajons","Region",}),
   ({"LG","LG32","Ventspils","Region",}),
   ({"LG","LG33","Ventspils Rajons","Region",}),
   ({"LH","LH01","Akmenes Rajonas","rajonas",}),
   ({"LH","LH02","Alytaus Rajonas","rajonas",}),
   ({"LH","LH03","Alytus","rajonas",}),
   ({"LH","LH04","Anyksciu Rajonas","rajonas",}),
   ({"LH","LH05","Birstonas","rajonas",}),
   ({"LH","LH06","Birzu Rajonas","rajonas",}),
   ({"LH","LH07","Druskininkai","rajonas",}),
   ({"LH","LH08","Ignalinos Rajonas","rajonas",}),
   ({"LH","LH09","Jonavos Rajonas","rajonas",}),
   ({"LH","LH10","Joniskio Rajonas","rajonas",}),
   ({"LH","LH11","Jurbarko Rajonas","rajonas",}),
   ({"LH","LH12","Kaisiadoriu Rajonas","rajonas",}),
   ({"LH","LH13","Kaunas","rajonas",}),
   ({"LH","LH14","Kauno Rajonas","rajonas",}),
   ({"LH","LH15","Kedainiu Rajonas","rajonas",}),
   ({"LH","LH16","Kelmes Rajonas","rajonas",}),
   ({"LH","LH17","Klaipeda","rajonas",}),
   ({"LH","LH18","Klaipedos Rajonas","rajonas",}),
   ({"LH","LH19","Kretingos Rajonas","rajonas",}),
   ({"LH","LH20","Kupiskio Rajonas","rajonas",}),
   ({"LH","LH21","Lazdiju Rajonas","rajonas",}),
   ({"LH","LH22","Marijampole","rajonas",}),
   ({"LH","LH23","Marijampoles Rajonas","rajonas",}),
   ({"LH","LH24","Mazeikiu Rajonas","rajonas",}),
   ({"LH","LH25","Moletu Rajonas","rajonas",}),
   ({"LH","LH26","Neringa","rajonas",}),
   ({"LH","LH27","Pakruojo Rajonas","rajonas",}),
   ({"LH","LH28","Palanga","rajonas",}),
   ({"LH","LH29","Panevezio Rajonas","rajonas",}),
   ({"LH","LH30","Panevezys","rajonas",}),
   ({"LH","LH31","Pasvalio Rajonas","rajonas",}),
   ({"LH","LH32","Plunges Rajonas","rajonas",}),
   ({"LH","LH33","Prienu Rajonas","rajonas",}),
   ({"LH","LH34","Radviliskio Rajonas","rajonas",}),
   ({"LH","LH35","Raseiniu Rajonas","rajonas",}),
   ({"LH","LH36","Rokiskio Rajonas","rajonas",}),
   ({"LH","LH37","Sakiu Rajonas","rajonas",}),
   ({"LH","LH38","Salcininku Rajonas","rajonas",}),
   ({"LH","LH39","Siauliai","rajonas",}),
   ({"LH","LH40","Siauliu Rajonas","rajonas",}),
   ({"LH","LH41","Silales Rajonas","rajonas",}),
   ({"LH","LH42","Silutes Rajonas","rajonas",}),
   ({"LH","LH43","Sirvintu Rajonas","rajonas",}),
   ({"LH","LH44","Skuodo Rajonas","rajonas",}),
   ({"LH","LH45","Svencioniu Rajonas","rajonas",}),
   ({"LH","LH46","Taurages Rajonas","rajonas",}),
   ({"LH","LH47","Telsiu Rajonas","rajonas",}),
   ({"LH","LH48","Traku Rajonas","rajonas",}),
   ({"LH","LH49","Ukmerges Rajonas","rajonas",}),
   ({"LH","LH50","Utenos Rajonas","rajonas",}),
   ({"LH","LH51","Varenos Rajonas","rajonas",}),
   ({"LH","LH52","Vilkaviskio Rajonas","rajonas",}),
   ({"LH","LH53","Vilniaus Rajonas","rajonas",}),
   ({"LH","LH54","Vilnius","rajonas",}),
   ({"LH","LH55","Zarasu Rajonas","rajonas",}),
   ({"LI","LI01","Bong","county",}),
   ({"LI","LI02","Grand Gedeh","county",}),
// ({"LI","LI04","Grand Cape Mount","county",}),	// obsolete
   ({"LI","LI05","Lofa","county",}),
   ({"LI","LI07","Monrovia","commonwealth district",}),
// ({"LI","LI08","Montserrado","county",}),	// obsolete
   ({"LI","LI09","Nimba","county",}),
   ({"LI","LI10","Sinoe","county",}),
   ({"LI","LI11","Grand Bassa","county",}),
   ({"LI","LI12","Grand Cape Mount","county",}),
   ({"LI","LI13","Maryland","county",}),
   ({"LI","LI14","Montserrado","county",}),
   ({"LI","LI15","Bomi","county",}),
   ({"LI","LI16","Grand Kru","county",}),
   ({"LI","LI17","Margibi","county",}),
   ({"LI","LI18","River Cess","county",}),
   ({"LO","LO01","Banskobystricky","district/kray",}),
   ({"LO","LO02","Bratislavsky","district/kray",}),
   ({"LO","LO03","Kosicky","district/kray",}),
   ({"LO","LO04","Nitrinsky","district/kray",}),
   ({"LO","LO05","Presovsky","district/kray",}),
   ({"LO","LO06","Treciansky","district/kray",}),
   ({"LO","LO07","Trnavsky","district/kray",}),
   ({"LO","LO08","Zilinsky","district/kray",}),
   ({"LS","LS01","Balzers","commune/gemeinde",}),
   ({"LS","LS02","Eschen","commune/gemeinde",}),
   ({"LS","LS03","Gamprin","commune/gemeinde",}),
   ({"LS","LS04","Mauren","commune/gemeinde",}),
   ({"LS","LS05","Planken","commune/gemeinde",}),
   ({"LS","LS06","Ruggell","commune/gemeinde",}),
   ({"LS","LS07","Schaan","commune/gemeinde",}),
   ({"LS","LS08","Schellenberg","commune/gemeinde",}),
   ({"LS","LS09","Triesen","commune/gemeinde",}),
   ({"LS","LS10","Triesenberg","commune/gemeinde",}),
   ({"LS","LS11","Vaduz","commune/gemeinde",}),
   ({"LT","LT01","LT01","district",}),
   ({"LT","LT02","LT02","district",}),
   ({"LT","LT03","LT03","district",}),
   ({"LT","LT04","LT04","district",}),
   ({"LT","LT05","LT05","district",}),
   ({"LT","LT06","LT06","district",}),
   ({"LT","LT10","Berea","district",}),
   ({"LT","LT11","Butha-Buthe","district",}),
   ({"LT","LT12","Leribe","district",}),
   ({"LT","LT13","Mafeteng","district",}),
   ({"LT","LT14","Maseru","district",}),
   ({"LT","LT15","Mohale's Hoek","district",}),
   ({"LT","LT16","Mokhotlong","district",}),
   ({"LT","LT17","Qacha's Hoek","district",}),
   ({"LT","LT18","Quthing","district",}),
   ({"LT","LT19","Thaba-Tseka","district",}),
   ({"LU","LU01","Diekirch","district/district",}),
   ({"LU","LU02","Grevenmacher","district/district",}),
   ({"LU","LU03","Luxembourg","district/district",}),
   ({"LY","LY02","LY02","municipality/baladiyah",}),
   ({"LY","LY03","Al 'Aziziyah","municipality/baladiyah",}),
   ({"LY","LY04","LY04","municipality/baladiyah",}),
   ({"LY","LY05","Al Jufrah","municipality/baladiyah",}),
   ({"LY","LY06","LY06","municipality/baladiyah",}),
   ({"LY","LY08","Al Kufrah","municipality/baladiyah",}),
   ({"LY","LY09","LY09","municipality/baladiyah",}),
   ({"LY","LY10","LY10","municipality/baladiyah",}),
   ({"LY","LY11","LY11","municipality/baladiyah",}),
   ({"LY","LY12","LY12","municipality/baladiyah",}),
   ({"LY","LY13","Ash Shati'","municipality/baladiyah",}),
   ({"LY","LY15","LY15","municipality/baladiyah",}),
   ({"LY","LY18","LY18","municipality/baladiyah",}),
   ({"LY","LY19","LY19","municipality/baladiyah",}),
   ({"LY","LY23","LY23","municipality/baladiyah",}),
   ({"LY","LY24","LY24","municipality/baladiyah",}),
   ({"LY","LY25","LY25","municipality/baladiyah",}),
   ({"LY","LY26","LY26","municipality/baladiyah",}),
   ({"LY","LY27","LY27","municipality/baladiyah",}),
   ({"LY","LY29","LY29","municipality/baladiyah",}),
   ({"LY","LY30","Murzuq","municipality/baladiyah",}),
   ({"LY","LY31","LY31","municipality/baladiyah",}),
   ({"LY","LY32","LY32","municipality/baladiyah",}),
   ({"LY","LY33","LY33","municipality/baladiyah",}),
   ({"LY","LY34","Sabha","municipality/baladiyah",}),
   ({"LY","LY35","LY35","municipality/baladiyah",}),
   ({"LY","LY36","LY36","municipality/baladiyah",}),
   ({"LY","LY37","LY37","municipality/baladiyah",}),
   ({"LY","LY39","LY39","municipality/baladiyah",}),
   ({"LY","LY41","Tarhunah","municipality/baladiyah",}),
   ({"LY","LY42","T\366ubruq","municipality/baladiyah",}),
   ({"LY","LY43","LY43","municipality/baladiyah",}),
   ({"LY","LY45","Zlitan","municipality/baladiyah",}),
   ({"LY","LY46","LY46","municipality/baladiyah",}),
   ({"LY","LY47","Ajdabiya","municipality/baladiyah",}),
   ({"LY","LY48","Al Fatih","municipality/baladiyah",}),
   ({"LY","LY49","Al Jabal al Akhdar","municipality/baladiyah",}),
   ({"LY","LY50","Al Khums","municipality/baladiyah",}),
   ({"LY","LY51","An Nuqat al Khams","municipality/baladiyah",}),
   ({"LY","LY52","Awbari","municipality/baladiyah",}),
   ({"LY","LY53","Az Zawiyah","municipality/baladiyah",}),
   ({"LY","LY54","Banghazi","municipality/baladiyah",}),
   ({"LY","LY55","Darnah","municipality/baladiyah",}),
   ({"LY","LY56","Ghadamis","municipality/baladiyah",}),
   ({"LY","LY57","Gharyan","municipality/baladiyah",}),
   ({"LY","LY58","Misratah","municipality/baladiyah",}),
   ({"LY","LY59","Sawfajjin","municipality/baladiyah",}),
   ({"LY","LY60","Surt","municipality/baladiyah",}),
   ({"LY","LY61","T\366arrbuus","municipality/baladiyah",}),
   ({"LY","LY62","Yafran","municipality/baladiyah",}),
   ({"MA","MA01","Antsiranana","province/faritanin'",}),
   ({"MA","MA02","Fianarantsoa","province/faritanin'",}),
   ({"MA","MA03","Mahajanga","province/faritanin'",}),
   ({"MA","MA04","Toamasina","province/faritanin'",}),
   ({"MA","MA05","Antananarivo","province/faritanin'",}),
   ({"MA","MA06","Toliara","province/faritanin'",}),
   ({"MC","MC01","Ilhas","district/concelho",}),
   ({"MC","MC02","Macau","district/concelho",}),
   ({"MD","MD13","Chisinau","county/judetul",}),
   ({"MD","MD46","Balti","county/judetul",}),
   ({"MD","MD47","Cahul","county/judetul",}),
   ({"MD","MD48","Chisinau","county/judetul",}),
   ({"MD","MD49","Dubasari","county/judetul",}),
   ({"MD","MD50","Edinet","county/judetul",}),
   ({"MD","MD51","Gagauzia"," autonomous territoral unit/unitate teritoriala autonoma",}),
   ({"MD","MD52","Lapusna","county/judetul",}),
   ({"MD","MD53","Orhei","county/judetul",}),
   ({"MD","MD54","Soroca","county/judetul",}),
   ({"MD","MD55","Tighina","county/judetul",}),
   ({"MD","MD56","Ungheni","county/judetul",}),
   ({"MG","MG01","Arhangay","province/aymag",}),
   ({"MG","MG02","Bayanhongor","province/aymag",}),
   ({"MG","MG03","Bayan-Olgiy","province/aymag",}),
   ({"MG","MG04","MG04","province/aymag",}),
   ({"MG","MG05","Darhan","municipality/hot",}),
   ({"MG","MG06","Dornod","province/aymag",}),
   ({"MG","MG07","Dornogovi","province/aymag",}),
   ({"MG","MG08","Dundgovi","province/aymag",}),
   ({"MG","MG09","Dzavhan","province/aymag",}),
   ({"MG","MG10","Govi-Altay","province/aymag",}),
   ({"MG","MG11","Hentiy","province/aymag",}),
   ({"MG","MG12","Hovd","province/aymag",}),
   ({"MG","MG13","Hovsgol","province/aymag",}),
   ({"MG","MG14","Omnogovi","province/aymag",}),
   ({"MG","MG15","Ovorhangay","province/aymag",}),
   ({"MG","MG16","Selenge","province/aymag",}),
   ({"MG","MG17","Suhbaatar","province/aymag",}),
   ({"MG","MG18","Tov","province/aymag",}),
   ({"MG","MG19","Uvs","province/aymag",}),
   ({"MG","MG20","Ulaanbaatar","municipality/hot",}),
   ({"MG","MG21","Bulgan","province/aymag",}),
   ({"MG","MG22","Erdenet","municipality/hot",}),
   ({"MH","MH01","Saint Anthony","parish",}),
   ({"MH","MH02","Saint Georges","parish",}),
   ({"MH","MH03","Saint Peter","parish",}),
   ({"MI","MI02","Chikwawa","district",}),
   ({"MI","MI03","Chiradzulu","district",}),
   ({"MI","MI04","Chitipa","district",}),
   ({"MI","MI05","Thyolo","district",}),
   ({"MI","MI06","Dedza","district",}),
   ({"MI","MI07","Dowa","district",}),
   ({"MI","MI08","Karonga","district",}),
   ({"MI","MI09","Kasungu","district",}),
   ({"MI","MI10","Machinga Kasupe","district",}),
   ({"MI","MI11","Lilongwe","district",}),
   ({"MI","MI12","Mangochi Fort Johnston","district",}),
   ({"MI","MI13","Mchinji","district",}),
   ({"MI","MI14","Mulanje Mlange","district",}),
   ({"MI","MI15","Mzimba","district",}),
   ({"MI","MI16","Ntcheu","district",}),
   ({"MI","MI17","Nkhata Bay","district",}),
   ({"MI","MI18","Nkhotakota","district",}),
   ({"MI","MI19","Nsanje","district",}),
   ({"MI","MI20","Ntchisi Nchisi","district",}),
   ({"MI","MI21","Rumphi Rumpil","district",}),
   ({"MI","MI22","Salima","district",}),
   ({"MI","MI23","Zomba","district",}),
   ({"MI","MI24","Blantyre","district",}),
   ({"MI","MI25","Mwanza","district",}),
   ({"ML","ML01","Bamako","district/region",}),
   ({"ML","ML02","Gao","district/region",}),
   ({"ML","ML03","Kayes","district/region",}),
   ({"ML","ML04","Mopti","district/region",}),
   ({"ML","ML05","Segou","district/region",}),
   ({"ML","ML06","Sikasso","district/region",}),
   ({"ML","ML07","Koulikoro","district/region",}),
   ({"ML","ML08","Tombouctou","district/region",}),
   ({"MO","MO01","Agadir","province/province",}),
   ({"MO","MO02","Al Hoce\324ma","province/province",}),
   ({"MO","MO03","Azilal","province/province",}),
   ({"MO","MO04","Ben Slimane","province/province",}),
   ({"MO","MO05","Beni Mellal","province/province",}),
   ({"MO","MO06","Boulemane","province/province",}),
   ({"MO","MO07","Casablanca","municipality/wilaya",}),
   ({"MO","MO08","Chaouen","province/province",}),
   ({"MO","MO09","El Jadida","province/province",}),
   ({"MO","MO10","El Kelaa des Sraghna","province/province",}),
   ({"MO","MO11","Er Rachidia","province/province",}),
   ({"MO","MO12","Essaouira","province/province",}),
   ({"MO","MO13","Fes","municipality/wilaya",}),
   ({"MO","MO14","Figuig","province/province",}),
   ({"MO","MO15","Kenitra","province/province",}),
   ({"MO","MO16","Khemisset","province/province",}),
   ({"MO","MO17","Khenifra","province/province",}),
   ({"MO","MO18","Khouribga","province/province",}),
   ({"MO","MO19","Marrakech","municipality/wilaya",}),
   ({"MO","MO20","Meknes","province/province",}),
   ({"MO","MO21","Nador","province/province",}),
   ({"MO","MO22","Ouarzazate","province/province",}),
   ({"MO","MO23","Oujda","province/province",}),
   ({"MO","MO24","Rabat-Sale","municipality/wilaya",}),
   ({"MO","MO25","Safi","province/province",}),
   ({"MO","MO26","Settat","province/province",}),
   ({"MO","MO27","Tanger","province/province",}),
   ({"MO","MO29","Tata","province/province",}),
   ({"MO","MO30","Taza","province/province",}),
   ({"MO","MO32","Tiznit","province/province",}),
// ({"MO","MO33","Guelmim","province/province",}),	// obsolete
   ({"MO","MO34","Ifrane","province/province",}),
   ({"MO","MO35","Laayoune","province/province",}),
   ({"MO","MO36","Tan-Tan","province/province",}),
   ({"MO","MO37","Taounate","province/province",}),
   ({"MO","MO38","Sidi Kacem","province/province",}),
   ({"MO","MO39","Taroudannt","province/province",}),
   ({"MO","MO40","Tetouan","province/province",}),
   ({"MO","MO41","Larache","province/province",}),
   ({"MO","MO42","Guelmim","province/province",}),
   ({"MO","MO43","Assa-Zag","province/province",}),
   ({"MO","MO44","Es Smara","province/province",}),
   ({"MP","MP12","Black River","district",}),
   ({"MP","MP13","Flacq","district",}),
   ({"MP","MP14","Grand Port","district",}),
   ({"MP","MP15","Moka","district",}),
   ({"MP","MP16","Pamplemousses","district",}),
   ({"MP","MP17","Plaines Wilhems","district",}),
   ({"MP","MP18","Port Louis","district",}),
   ({"MP","MP19","Rivi\313re du Rempart","district",}),
   ({"MP","MP20","Savanne","district",}),
   ({"MP","MP21","Agalega Islands","dependency",}),
   ({"MP","MP22","Cargados Carajos","dependency",}),
   ({"MP","MP23","Rodrigues","dependency",}),
   ({"MR","MR01","Hodh Ech Chargui","region/region",}),
   ({"MR","MR02","Hodh El Gharbi","region/region",}),
   ({"MR","MR03","Assaba","region/region",}),
   ({"MR","MR04","Gorgol","region/region",}),
   ({"MR","MR05","Brakna","region/region",}),
   ({"MR","MR06","Trarza","region/region",}),
   ({"MR","MR07","Adrar","region/region",}),
   ({"MR","MR08","Dakhlet Nouadhibou","region/region",}),
   ({"MR","MR09","Tagant","region/region",}),
   ({"MR","MR10","Guidimaka","region/region",}),
   ({"MR","MR11","Tiris Zemmour","region/region",}),
   ({"MR","MR12","Inchiri","region/region",}),
   ({"MU","MU01","Ad Dakhiliyah","region/mintaqat",}),
   ({"MU","MU02","Al Batinah","region/mintaqat",}),
   ({"MU","MU03","Al Wusta","region/mintaqat",}),
   ({"MU","MU04","Ash Sharqiyah","region/mintaqat",}),
   ({"MU","MU05","Az Zahirah","region/mintaqat",}),
   ({"MU","MU06","Masqat","region/mintaqat",}),
   ({"MU","MU07","Musandam","governorate/muhafazat",}),
   ({"MU","MU08","Zufar","governorate/muhafazat",}),
   ({"MV","MV01","Seenu","district/atholhu",}),
// ({"MV","MV02","Aliff","district/atholhu",}),	// obsolete
// ({"MV","MV03","Laviyani","district/atholhu",}),	// obsolete
// ({"MV","MV04","Waavu","district/atholhu",}),	// obsolete
   ({"MV","MV05","Laamu","district/atholhu",}),
// ({"MV","MV07","Haa Aliff","district/atholhu",}),	// obsolete
// ({"MV","MV08","Thaa","district/atholhu",}),	// obsolete
// ({"MV","MV12","Meemu","district/atholhu",}),	// obsolete
// ({"MV","MV13","Raa","district/atholhu",}),	// obsolete
// ({"MV","MV14","Faafu","district/atholhu",}),	// obsolete
// ({"MV","MV17","Daalu","district/atholhu",}),	// obsolete
// ({"MV","MV20","Baa","district/atholhu",}),	// obsolete
// ({"MV","MV23","Haa Daalu","district/atholhu",}),	// obsolete
// ({"MV","MV24","Shaviyani","district/atholhu",}),	// obsolete
// ({"MV","MV25","Noonu","district/atholhu",}),	// obsolete
// ({"MV","MV26","Kaafu","district/atholhu",}),	// obsolete
// ({"MV","MV27","Gaafu Aliff","district/atholhu",}),	// obsolete
// ({"MV","MV28","Gaafu Daalu","district/atholhu",}),	// obsolete
// ({"MV","MV29","Naviyani","district/atholhu",}),	// obsolete
   ({"MV","MV30","Alifu","district/atholhu",}),
   ({"MV","MV31","Baa","district/atholhu",}),
   ({"MV","MV32","Dhaalu","district/atholhu",}),
   ({"MV","MV33","Faafa","district/atholhu",}),
   ({"MV","MV34","Gaafu Alifu","district/atholhu",}),
   ({"MV","MV35","Gaafu Dhaalu","district/atholhu",}),
   ({"MV","MV36","Haa Alifu","district/atholhu",}),
   ({"MV","MV37","Haa Dhaalu","district/atholhu",}),
   ({"MV","MV38","Kaafu","district/atholhu",}),
   ({"MV","MV39","Lhaviyani","district/atholhu",}),
   ({"MV","MV40","Maale","municipality",}),
   ({"MV","MV41","Meenu","district/atholhu",}),
   ({"MV","MV42","Gnaviyani","district/atholhu",}),
   ({"MV","MV43","Noonu","district/atholhu",}),
   ({"MV","MV44","Raa","district/atholhu",}),
   ({"MV","MV45","Shaviyani","district/atholhu",}),
   ({"MV","MV46","Thaa","district/atholhu",}),
   ({"MV","MV47","Vaavu","district/atholhu",}),
   ({"MX","MX01","Aguascalientes","state/estado",}),
   ({"MX","MX02","Baja California","state/estado",}),
   ({"MX","MX03","Baja California Sur","state/estado",}),
   ({"MX","MX04","Campeche","state/estado",}),
   ({"MX","MX05","Chiapas","state/estado",}),
   ({"MX","MX06","Chihuahua","state/estado",}),
   ({"MX","MX07","Coahuila de Zaragoza","state/estado",}),
   ({"MX","MX08","Colima","state/estado",}),
   ({"MX","MX09","Distrito Federal","state/estado",}),
   ({"MX","MX10","Durango","state/estado",}),
   ({"MX","MX11","Guanajuato","state/estado",}),
   ({"MX","MX12","Guerrero","state/estado",}),
   ({"MX","MX13","Hidalgo","state/estado",}),
   ({"MX","MX14","Jalisco","state/estado",}),
   ({"MX","MX15","Mexico","state/estado",}),
   ({"MX","MX16","Michoacan de Ocampo","state/estado",}),
   ({"MX","MX17","Morelos","state/estado",}),
   ({"MX","MX18","Nayarit","state/estado",}),
   ({"MX","MX19","Nuevo Leon","state/estado",}),
   ({"MX","MX20","Oaxaca","state/estado",}),
   ({"MX","MX21","Puebla","state/estado",}),
   ({"MX","MX22","Queretaro de Arteaga","state/estado",}),
   ({"MX","MX23","Quintana Roo","state/estado",}),
   ({"MX","MX24","San Luis Potosi","state/estado",}),
   ({"MX","MX25","Sinaloa","state/estado",}),
   ({"MX","MX26","Sonora","state/estado",}),
   ({"MX","MX27","Tabasco","state/estado",}),
   ({"MX","MX28","Tamaulipas","state/estado",}),
   ({"MX","MX29","Tlaxcala","state/estado",}),
   ({"MX","MX30","Veracruz-Llave","state/estado",}),
   ({"MX","MX31","Yucatan","state/estado",}),
   ({"MX","MX32","Zacatecas","state/estado",}),
   ({"MY","MY01","Johor","state/negeri",}),
   ({"MY","MY02","Kedah","state/negeri",}),
   ({"MY","MY03","Kelantan","state/negeri",}),
   ({"MY","MY04","Melaka","state/negeri",}),
   ({"MY","MY05","Negeri Sembilan","state/negeri",}),
   ({"MY","MY06","Pahang","state/negeri",}),
   ({"MY","MY07","Perak","state/negeri",}),
   ({"MY","MY08","Perlis","state/negeri",}),
   ({"MY","MY09","Pulau Pinang","state/negeri",}),
   ({"MY","MY11","Sarawak","state/negeri",}),
   ({"MY","MY12","Selangor","state/negeri",}),
   ({"MY","MY13","Terengganu","state/negeri",}),
   ({"MY","MY14","Wilayah Persekutuan","federal territory/wilayah persekutuan",}),
   ({"MY","MY15","Labuan","federal territory/wilayah persekutuan",}),
   ({"MY","MY16","Sabah","state/negeri",}),
   ({"MZ","MZ01","Cabo Delgado","province/provincia",}),
   ({"MZ","MZ02","Gaza","province/provincia",}),
   ({"MZ","MZ03","Inhambane","province/provincia",}),
   ({"MZ","MZ04","Maputo","province/provincia",}),
   ({"MZ","MZ05","Sofala","province/provincia",}),
   ({"MZ","MZ06","Nampula","province/provincia",}),
   ({"MZ","MZ07","Niassa","province/provincia",}),
   ({"MZ","MZ08","Tete","province/provincia",}),
   ({"MZ","MZ09","Zambezia","province/provincia",}),
   ({"MZ","MZ10","Manica","province/provincia",}),
   ({"NG","NG01","Agadez","department/departement",}),
   ({"NG","NG02","Diffa","department/departement",}),
   ({"NG","NG03","Dosso","department/departement",}),
   ({"NG","NG04","Maradi","department/departement",}),
// ({"NG","NG05","Niamey","department/departement",}),	// obsolete
   ({"NG","NG06","Tahoua","department/departement",}),
   ({"NG","NG07","Zinder","department/departement",}),
   ({"NG","NG08","Niamey","autonomous region",}),
   ({"NG","NG09","Tillaberi","department/departement",}),
// ({"NH","NH05","Ambrym","province",}),	// obsolete
// ({"NH","NH06","Aoba/Maewo","province",}),	// obsolete
   ({"NH","NH07","Torba","province",}),
// ({"NH","NH08","Efate","province",}),	// obsolete
// ({"NH","NH09","Epi","province",}),	// obsolete
// ({"NH","NH10","Malakula","province",}),	// obsolete
// ({"NH","NH11","Paama","province",}),	// obsolete
// ({"NH","NH12","Pentecote","province",}),	// obsolete
   ({"NH","NH13","Sanma","province",}),
// ({"NH","NH14","Shepherd","province",}),	// obsolete
   ({"NH","NH15","Tafea","province",}),
   ({"NH","NH16","Malampa","province",}),
   ({"NH","NH17","Penama","province",}),
   ({"NH","NH18","Shefa","province",}),
   ({"NI","NI05","Lagos","state",}),
// ({"NI","NI10","Rivers","state",}),	// obsolete
   ({"NI","NI11","Abuja Capital Territory","capital territory",}),
   ({"NI","NI12","NI12","state",}),
   ({"NI","NI16","Ogun","state",}),
// ({"NI","NI17","Ondo","state",}),	// obsolete
   ({"NI","NI18","NI18","state",}),
// ({"NI","NI19","Plateau","state",}),	// obsolete
   ({"NI","NI20","NI20","state",}),
   ({"NI","NI21","Akwa Ibom","state",}),
   ({"NI","NI22","Cross River","state",}),
   ({"NI","NI23","Kaduna","state",}),
   ({"NI","NI24","Katsina","state",}),
   ({"NI","NI25","Anambra","state",}),
   ({"NI","NI26","Benue","state",}),
   ({"NI","NI27","Borno","state",}),
   ({"NI","NI28","Imo","state",}),
   ({"NI","NI29","Kano","state",}),
   ({"NI","NI30","Kwara","state",}),
   ({"NI","NI31","Niger","state",}),
   ({"NI","NI32","Oyo","state",}),
// ({"NI","NI34","Abia","state",}),	// obsolete
   ({"NI","NI35","Adamawa","state",}),
   ({"NI","NI36","Delta","state",}),
   ({"NI","NI37","Edo","state",}),
   ({"NI","NI39","Jigawa","state",}),
   ({"NI","NI40","Kebbi","state",}),
   ({"NI","NI41","Kogi","state",}),
   ({"NI","NI42","Osun","state",}),
   ({"NI","NI43","Taraba","state",}),
   ({"NI","NI44","Yobe","state",}),
   ({"NI","NI45","Abia","state",}),
   ({"NI","NI46","Bauchi","state",}),
   ({"NI","NI47","Enugu","state",}),
   ({"NI","NI48","Ondo","state",}),
   ({"NI","NI49","Plateau","state",}),
   ({"NI","NI50","Rivers","state",}),
   ({"NI","NI51","Sokoto","state",}),
   ({"NI","NI52","Bayelsa","state",}),
   ({"NI","NI53","Ebonyi","state",}),
   ({"NI","NI54","Ekiti","state",}),
   ({"NI","NI55","Gombe","state",}),
   ({"NI","NI56","Nassarawa","state",}),
   ({"NI","NI57","Zamfara","state",}),
   ({"NL","NL01","Drenthe","province/provincie",}),
   ({"NL","NL02","Friesland","province/provincie",}),
   ({"NL","NL03","Gelderland","province/provincie",}),
   ({"NL","NL04","Groningen","province/provincie",}),
   ({"NL","NL05","Limburg","province/provincie",}),
   ({"NL","NL06","Noord-Brabant","province/provincie",}),
   ({"NL","NL07","Noord-Holland","province/provincie",}),
   ({"NL","NL09","Utrecht","province/provincie",}),
   ({"NL","NL10","Zeeland","province/provincie",}),
   ({"NL","NL11","Zuid-Holland","province/provincie",}),
   ({"NL","NL15","Overijssel","province/provincie",}),
   ({"NL","NL16","Flevoland","province/provincie",}),
   ({"NO","NO01","Akershus","province/fylke",}),
   ({"NO","NO02","Aust-Agder","province/fylke",}),
   ({"NO","NO04","Buskerud","province/fylke",}),
   ({"NO","NO05","Finnmark","province/fylke",}),
   ({"NO","NO06","Hedmark","province/fylke",}),
   ({"NO","NO07","Hordaland","province/fylke",}),
   ({"NO","NO08","More og Romsdal","province/fylke",}),
   ({"NO","NO09","Nordland","province/fylke",}),
   ({"NO","NO10","Nord-Trondelag","province/fylke",}),
   ({"NO","NO11","Oppland","province/fylke",}),
   ({"NO","NO12","Oslo","province/fylke",}),
   ({"NO","NO13","\377stfold","province/fylke",}),
   ({"NO","NO14","Rogaland","province/fylke",}),
   ({"NO","NO15","Sogn og Fjordane","province/fylke",}),
   ({"NO","NO16","Sor-Trondelag","province/fylke",}),
   ({"NO","NO17","Telemark","province/fylke",}),
   ({"NO","NO18","Troms","province/fylke",}),
   ({"NO","NO19","Vest-Agder","province/fylke",}),
   ({"NO","NO20","Vestfold","province/fylke",}),
   ({"NP","NP01","Bagmati","zone",}),
   ({"NP","NP02","Bheri","zone",}),
   ({"NP","NP03","Dhawalagiri","zone",}),
   ({"NP","NP04","Gandaki","zone",}),
   ({"NP","NP05","Janakpur","zone",}),
   ({"NP","NP06","Karnali","zone",}),
   ({"NP","NP07","Kosi","zone",}),
   ({"NP","NP08","Lumbini","zone",}),
   ({"NP","NP09","Mahakali","zone",}),
   ({"NP","NP10","Mechi","zone",}),
   ({"NP","NP11","Narayani","zone",}),
   ({"NP","NP12","Rapti","zone",}),
   ({"NP","NP13","Sagarmatha","zone",}),
   ({"NP","NP14","Seti","zone",}),
   ({"NR","NR01","Aiwo","district",}),
   ({"NR","NR02","Anabar","district",}),
   ({"NR","NR03","Anetan","district",}),
   ({"NR","NR04","Anibare","district",}),
   ({"NR","NR05","Baiti","district",}),
   ({"NR","NR06","Boe","district",}),
   ({"NR","NR07","Buada","district",}),
   ({"NR","NR08","Denigomodu","district",}),
   ({"NR","NR09","Ewa","district",}),
   ({"NR","NR10","Ijuw","district",}),
   ({"NR","NR11","Meneng","district",}),
   ({"NR","NR12","Nibok","district",}),
   ({"NR","NR13","Uaboe","district",}),
   ({"NR","NR14","Yaren","district",}),
   ({"NS","NS10","Brokopondo","district/distrikt",}),
   ({"NS","NS11","Commewijne","district/distrikt",}),
   ({"NS","NS12","Coronie","district/distrikt",}),
   ({"NS","NS13","Marowijne","district/distrikt",}),
   ({"NS","NS14","Nickerie","district/distrikt",}),
   ({"NS","NS15","Para","district/distrikt",}),
   ({"NS","NS16","Paramaribo","district/distrikt",}),
   ({"NS","NS17","Saramacca","district/distrikt",}),
   ({"NS","NS18","Sipaliwini","district/distrikt",}),
   ({"NS","NS19","Wanica","district/distrikt",}),
   ({"NU","NU01","Boaco","department/departamento",}),
   ({"NU","NU02","Carazo","department/departamento",}),
   ({"NU","NU03","Chinandega","department/departamento",}),
   ({"NU","NU04","Chontales","department/departamento",}),
   ({"NU","NU05","Esteli","department/departamento",}),
   ({"NU","NU06","Granada","department/departamento",}),
   ({"NU","NU07","Jinotega","department/departamento",}),
   ({"NU","NU08","Leon","department/departamento",}),
   ({"NU","NU09","Madriz","department/departamento",}),
   ({"NU","NU10","Managua","department/departamento",}),
   ({"NU","NU11","Masaya","department/departamento",}),
   ({"NU","NU12","Matagalpa","department/departamento",}),
   ({"NU","NU13","Nueva Segovia","department/departamento",}),
   ({"NU","NU14","Rio San Juan","department/departamento",}),
   ({"NU","NU15","Rivas","department/departamento",}),
// ({"NU","NU16","Zelaya","department/departamento",}),	// obsolete
   ({"NU","NU17","Atlantico Norte","autonomous region/region autonoma",}),
   ({"NU","NU18","Atlantico Sur","autonomous region/region autonoma",}),
   ({"NZ","NZ01","Akaroa","county",}),
   ({"NZ","NZ03","Amuri","county",}),
   ({"NZ","NZ04","Ashburton","county",}),
   ({"NZ","NZ07","Bay of Islands","county",}),
   ({"NZ","NZ08","Bruce","county",}),
   ({"NZ","NZ09","Buller","county",}),
   ({"NZ","NZ10","Chatham Islands","county",}),
   ({"NZ","NZ11","Cheviot","county",}),
   ({"NZ","NZ12","Clifton","county",}),
   ({"NZ","NZ13","Clutha","county",}),
   ({"NZ","NZ14","Cook","county",}),
   ({"NZ","NZ16","Dannevirke","county",}),
   ({"NZ","NZ17","Egmont","county",}),
   ({"NZ","NZ18","Eketahuna","county",}),
   ({"NZ","NZ19","Ellesmere","county",}),
   ({"NZ","NZ20","Eltham","county",}),
   ({"NZ","NZ21","Eyre","county",}),
   ({"NZ","NZ22","Featherston","county",}),
   ({"NZ","NZ24","Franklin","county",}),
   ({"NZ","NZ26","Golden Bay","county",}),
   ({"NZ","NZ27","Great Barrier Island","county",}),
   ({"NZ","NZ28","Grey","county",}),
   ({"NZ","NZ29","Hauraki Plains","county",}),
   ({"NZ","NZ30","Hawera","district",}),
   ({"NZ","NZ31","Hawke's Bay","county",}),
   ({"NZ","NZ32","Heathcote","county",}),
   ({"NZ","NZ33","Hobson","county",}),
   ({"NZ","NZ34","Hokianga","county",}),
   ({"NZ","NZ35","Horowhenua","county",}),
   ({"NZ","NZ36","Hutt","county",}),
   ({"NZ","NZ37","Inangahua","county",}),
   ({"NZ","NZ38","Inglewood","county",}),
   ({"NZ","NZ39","Kaikoura","county",}),
   ({"NZ","NZ40","Kairanga","county",}),
   ({"NZ","NZ41","Kiwitea","county",}),
   ({"NZ","NZ43","Lake","county",}),
   ({"NZ","NZ45","Mackenzie","county",}),
   ({"NZ","NZ46","Malvern","county",}),
   ({"NZ","NZ47","Manawatu","county",}),
   ({"NZ","NZ48","Mangonui","county",}),
   ({"NZ","NZ49","Maniototo","county",}),
   ({"NZ","NZ50","Marlborough","county",}),
   ({"NZ","NZ51","Masterton","county",}),
   ({"NZ","NZ52","Matamata","county",}),
   ({"NZ","NZ53","Mount Herbert","county",}),
   ({"NZ","NZ54","Ohinemuri","county",}),
   ({"NZ","NZ55","Opotiki","county",}),
   ({"NZ","NZ56","Oroua","county",}),
   ({"NZ","NZ57","Otamatea","county",}),
   ({"NZ","NZ58","Otorohanga","district",}),
   ({"NZ","NZ59","Oxford","county",}),
   ({"NZ","NZ60","Pahiatua","county",}),
   ({"NZ","NZ61","Paparua","county",}),
   ({"NZ","NZ63","Patea","county",}),
   ({"NZ","NZ65","Piako","county",}),
   ({"NZ","NZ66","Pohangina","county",}),
   ({"NZ","NZ67","Raglan","county",}),
   ({"NZ","NZ68","Rangiora","district",}),
   ({"NZ","NZ69","Rangitikei","county",}),
   ({"NZ","NZ70","Rodney","county",}),
   ({"NZ","NZ71","Rotorua","district",}),
   ({"NZ","NZ72","Southland","county",}),
   ({"NZ","NZ73","Stewart Island","county",}),
   ({"NZ","NZ74","Stratford","county",}),
   ({"NZ","NZ76","Taranaki","county",}),
   ({"NZ","NZ77","Taumarunui","county",}),
   ({"NZ","NZ78","Taupo","county",}),
   ({"NZ","NZ79","Tauranga","county",}),
   ({"NZ","NZ81","Tuapeka","county",}),
   ({"NZ","NZ82","Vincent","county",}),
   ({"NZ","NZ83","Waiapu","county",}),
   ({"NZ","NZ84","Waihemo","county",}),
   ({"NZ","NZ85","Waikato","county",}),
   ({"NZ","NZ86","Waikohu","county",}),
   ({"NZ","NZ88","Waimairi","county",}),
   ({"NZ","NZ89","Waimarino","county",}),
   ({"NZ","NZ90","Waimate","county",}),
   ({"NZ","NZ91","Waimate West","county",}),
   ({"NZ","NZ92","Waimea","county",}),
   ({"NZ","NZ93","Waipa","county",}),
   ({"NZ","NZ95","Waipawa","district",}),
   ({"NZ","NZ96","Waipukurau","district",}),
   ({"NZ","NZ97","Wairarapa South","county",}),
   ({"NZ","NZ98","Wairewa","county",}),
   ({"NZ","NZ99","Wairoa","county",}),
   ({"NZ","NZA1","Whangarei","county",}),
   ({"NZ","NZA2","Whangaroa","county",}),
   ({"NZ","NZA3","Woodville","county",}),
   ({"NZ","NZA4","Waitaki","county",}),
   ({"NZ","NZA6","Waitomo","district",}),
   ({"NZ","NZA8","Waitotara","county",}),
   ({"NZ","NZB2","Wanganui","county",}),
   ({"NZ","NZB3","Westland","county",}),
   ({"NZ","NZB4","Whakatane","district",}),
   ({"NZ","NZD4","Hurunui","county",}),
   ({"NZ","NZD5","Silverpeaks","county",}),
   ({"NZ","NZD6","Strathallan","county",}),
   ({"NZ","NZD8","Waiheke","county",}),
   ({"NZ","NZD9","Hikurangi","town district",}),
   ({"NZ","NZE1","Manaia","town district",}),
   ({"NZ","NZE2","Runanga","county",}),
   ({"NZ","NZE3","Saint Kilda","county",}),
   ({"NZ","NZE4","Thames-Coromandel","district",}),
   ({"NZ","NZE5","Waverley","town district",}),
   ({"NZ","NZE6","Wallace","county",}),
   ({"PA","PA01","Alto Parana","department/departamento",}),
   ({"PA","PA02","Amambay","department/departamento",}),
   ({"PA","PA04","Caaguazu","department/departamento",}),
   ({"PA","PA05","Caazapa","department/departamento",}),
   ({"PA","PA06","Central","department/departamento",}),
   ({"PA","PA07","Concepcion","department/departamento",}),
   ({"PA","PA08","Cordillera","department/departamento",}),
   ({"PA","PA10","Guaira","department/departamento",}),
   ({"PA","PA11","Itapua","department/departamento",}),
   ({"PA","PA12","Misiones","department/departamento",}),
   ({"PA","PA13","Neembucu","department/departamento",}),
   ({"PA","PA15","Paraguari","department/departamento",}),
   ({"PA","PA16","Presidente Hayes","department/departamento",}),
   ({"PA","PA17","San Pedro","department/departamento",}),
   ({"PA","PA19","Canindeyu","department/departamento",}),
   ({"PA","PA22","Asuncion","department/departamento",}),
   ({"PA","PA23","Alto Paraguay","department/departamento",}),
   ({"PA","PA24","Boqueron","department/departamento",}),
   ({"PE","PE01","Amazonas","constitutional province/provincia constitucional",}),
   ({"PE","PE02","Ancash","constitutional province/provincia constitucional",}),
   ({"PE","PE03","Apurimac","constitutional province/provincia constitucional",}),
   ({"PE","PE04","Arequipa","constitutional province/provincia constitucional",}),
   ({"PE","PE05","Ayacucho","constitutional province/provincia constitucional",}),
   ({"PE","PE06","Cajamarca","constitutional province/provincia constitucional",}),
   ({"PE","PE07","Callao","department/departamento",}),
   ({"PE","PE08","Cusco","constitutional province/provincia constitucional",}),
   ({"PE","PE09","Huancavelica","constitutional province/provincia constitucional",}),
   ({"PE","PE10","Huanuco","constitutional province/provincia constitucional",}),
   ({"PE","PE11","Ica","constitutional province/provincia constitucional",}),
   ({"PE","PE12","Junin","constitutional province/provincia constitucional",}),
   ({"PE","PE13","La Libertad","constitutional province/provincia constitucional",}),
   ({"PE","PE14","Lambayeque","constitutional province/provincia constitucional",}),
   ({"PE","PE15","Lima","constitutional province/provincia constitucional",}),
   ({"PE","PE16","Loreto","constitutional province/provincia constitucional",}),
   ({"PE","PE17","Madre de Dios","constitutional province/provincia constitucional",}),
   ({"PE","PE18","Moquegua","constitutional province/provincia constitucional",}),
   ({"PE","PE19","Pasco","constitutional province/provincia constitucional",}),
   ({"PE","PE20","Piura","constitutional province/provincia constitucional",}),
   ({"PE","PE21","Puno","constitutional province/provincia constitucional",}),
   ({"PE","PE22","San Martin","constitutional province/provincia constitucional",}),
   ({"PE","PE23","Tacna","constitutional province/provincia constitucional",}),
   ({"PE","PE24","Tumbes","constitutional province/provincia constitucional",}),
   ({"PE","PE25","Ucayali","constitutional province/provincia constitucional",}),
   ({"PK","PK01","Federally Administered Tribal Areas","territory",}),
   ({"PK","PK02","Balochistan","province",}),
   ({"PK","PK03","North-West Frontier","province",}),
   ({"PK","PK04","Punjab","province",}),
   ({"PK","PK05","Sindh","province",}),
   ({"PK","PK06","Azad Kashmir","pakistan-administered area",}),
   ({"PK","PK07","Northern Areas","pakistan-administered area",}),
   ({"PK","PK08","Islamabad","capital territory",}),
   ({"PK","PK99","PK99","province",}),
// ({"PL","PL23","Biala Podlaska","province/wojewodztwo",}),	// obsolete
// ({"PL","PL24","Bialystok","province/wojewodztwo",}),	// obsolete
// ({"PL","PL25","Bielsko","province/wojewodztwo",}),	// obsolete
// ({"PL","PL26","Bydgoszcz","province/wojewodztwo",}),	// obsolete
// ({"PL","PL27","Chelm","province/wojewodztwo",}),	// obsolete
// ({"PL","PL28","Ciechanow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL29","Czestochowa","province/wojewodztwo",}),	// obsolete
// ({"PL","PL30","Elblag","province/wojewodztwo",}),	// obsolete
// ({"PL","PL31","Gdansk","province/wojewodztwo",}),	// obsolete
// ({"PL","PL32","Gorzow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL33","Jelenia Gora","province/wojewodztwo",}),	// obsolete
// ({"PL","PL34","Kalisz","province/wojewodztwo",}),	// obsolete
// ({"PL","PL35","Katowice","province/wojewodztwo",}),	// obsolete
// ({"PL","PL36","Kielce","province/wojewodztwo",}),	// obsolete
// ({"PL","PL37","Konin","province/wojewodztwo",}),	// obsolete
// ({"PL","PL38","Koszalin","province/wojewodztwo",}),	// obsolete
// ({"PL","PL39","Krakow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL40","Krosno","province/wojewodztwo",}),	// obsolete
// ({"PL","PL41","Legnica","province/wojewodztwo",}),	// obsolete
// ({"PL","PL42","Leszno","province/wojewodztwo",}),	// obsolete
// ({"PL","PL43","Lodz","province/wojewodztwo",}),	// obsolete
// ({"PL","PL44","Lomza","province/wojewodztwo",}),	// obsolete
// ({"PL","PL45","Lublin","province/wojewodztwo",}),	// obsolete
// ({"PL","PL46","Nowy Sacz","province/wojewodztwo",}),	// obsolete
// ({"PL","PL47","Olsztyn","province/wojewodztwo",}),	// obsolete
// ({"PL","PL48","Opole","province/wojewodztwo",}),	// obsolete
// ({"PL","PL49","Ostroleka","province/wojewodztwo",}),	// obsolete
// ({"PL","PL50","Pila","province/wojewodztwo",}),	// obsolete
// ({"PL","PL51","Piotrkow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL52","Plock","province/wojewodztwo",}),	// obsolete
// ({"PL","PL53","Poznan","province/wojewodztwo",}),	// obsolete
// ({"PL","PL54","Przemysl","province/wojewodztwo",}),	// obsolete
// ({"PL","PL55","Radom","province/wojewodztwo",}),	// obsolete
// ({"PL","PL56","Rzeszow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL57","Siedlce","province/wojewodztwo",}),	// obsolete
// ({"PL","PL58","Sieradz","province/wojewodztwo",}),	// obsolete
// ({"PL","PL59","Skierniewice","province/wojewodztwo",}),	// obsolete
// ({"PL","PL60","Slupsk","province/wojewodztwo",}),	// obsolete
// ({"PL","PL61","Suwalki","province/wojewodztwo",}),	// obsolete
// ({"PL","PL62","Szczecin","province/wojewodztwo",}),	// obsolete
// ({"PL","PL63","Tarnobrzeg","province/wojewodztwo",}),	// obsolete
// ({"PL","PL64","Tarnow","province/wojewodztwo",}),	// obsolete
// ({"PL","PL65","Torun","province/wojewodztwo",}),	// obsolete
// ({"PL","PL66","Walbrzych","province/wojewodztwo",}),	// obsolete
// ({"PL","PL67","Warszawa","province/wojewodztwo",}),	// obsolete
// ({"PL","PL68","Wloclawek","province/wojewodztwo",}),	// obsolete
// ({"PL","PL69","Wroclaw","province/wojewodztwo",}),	// obsolete
// ({"PL","PL70","Zamosc","province/wojewodztwo",}),	// obsolete
// ({"PL","PL71","Zielona Gora","province/wojewodztwo",}),	// obsolete
   ({"PL","PL72","Dolnoslaskie","province/wojewodztwo",}),
   ({"PL","PL73","Kujawsko-Pomorskie","province/wojewodztwo",}),
   ({"PL","PL74","Lodzkie","province/wojewodztwo",}),
   ({"PL","PL75","Lubelskie","province/wojewodztwo",}),
   ({"PL","PL76","Lubuskie","province/wojewodztwo",}),
   ({"PL","PL77","Malopolskie","province/wojewodztwo",}),
   ({"PL","PL78","Mazowieckie","province/wojewodztwo",}),
   ({"PL","PL79","Opolskie","province/wojewodztwo",}),
   ({"PL","PL80","Podkarpackie","province/wojewodztwo",}),
   ({"PL","PL81","Podlaskie","province/wojewodztwo",}),
   ({"PL","PL82","Pomorskie","province/wojewodztwo",}),
   ({"PL","PL83","Slaskie","province/wojewodztwo",}),
   ({"PL","PL84","Swietokrzyskie","province/wojewodztwo",}),
   ({"PL","PL85","Warminsko-Mazurskie","province/wojewodztwo",}),
   ({"PL","PL86","Wielkopolskie","province/wojewodztwo",}),
   ({"PL","PL87","Zachodniopomorskie","province/wojewodztwo",}),
   ({"PM","PM01","Bocas del Toro","province/provincia",}),
   ({"PM","PM02","Chiriqui","province/provincia",}),
   ({"PM","PM03","Cocle","province/provincia",}),
   ({"PM","PM04","Colon","province/provincia",}),
   ({"PM","PM05","Darien","province/provincia",}),
   ({"PM","PM06","Herrera","province/provincia",}),
   ({"PM","PM07","Los Santos","province/provincia",}),
   ({"PM","PM08","Panama","province/provincia",}),
   ({"PM","PM09","San Blas","intendancy/intendencia",}),
   ({"PM","PM10","Veraguas","province/provincia",}),
   ({"PO","PO02","Aveiro","district/distrito",}),
   ({"PO","PO03","Beja","district/distrito",}),
   ({"PO","PO04","Braga","district/distrito",}),
   ({"PO","PO05","Braganca","district/distrito",}),
   ({"PO","PO06","Castelo Branco","district/distrito",}),
   ({"PO","PO07","Coimbra","district/distrito",}),
   ({"PO","PO08","Evora","district/distrito",}),
   ({"PO","PO09","Faro","district/distrito",}),
   ({"PO","PO10","Madeira","autonomous region/regiao autonoma",}),
   ({"PO","PO11","Guarda","district/distrito",}),
   ({"PO","PO13","Leiria","district/distrito",}),
   ({"PO","PO14","Lisboa","district/distrito",}),
   ({"PO","PO16","Portalegre","district/distrito",}),
   ({"PO","PO17","Porto","district/distrito",}),
   ({"PO","PO18","Santarem","district/distrito",}),
   ({"PO","PO19","Setubal","district/distrito",}),
   ({"PO","PO20","Viana do Castelo","district/distrito",}),
   ({"PO","PO21","Vila Real","district/distrito",}),
   ({"PO","PO22","Viseu","district/distrito",}),
   ({"PO","PO23","Azores","autonomous region/regiao autonoma",}),
   ({"PP","PP01","Central","province",}),
   ({"PP","PP02","Gulf","province",}),
   ({"PP","PP03","Milne Bay","province",}),
   ({"PP","PP04","Northern","province",}),
   ({"PP","PP05","Southern Highlands","province",}),
   ({"PP","PP06","Western","province",}),
   ({"PP","PP07","Bougainville","province",}),
   ({"PP","PP08","Chimbu","province",}),
   ({"PP","PP09","Eastern Highlands","province",}),
   ({"PP","PP10","East New Britain","province",}),
   ({"PP","PP11","East Sepik","province",}),
   ({"PP","PP12","Madang","province",}),
   ({"PP","PP13","Manus","province",}),
   ({"PP","PP14","Morobe","province",}),
   ({"PP","PP15","New Ireland","province",}),
   ({"PP","PP16","Western Highlands","province",}),
   ({"PP","PP17","West New Britain","province",}),
   ({"PP","PP18","Sandaun","province",}),
   ({"PP","PP19","Enga","province",}),
   ({"PP","PP20","National Capital","province",}),
   ({"PU","PU01","Bafata","region",}),
   ({"PU","PU02","Quinara","region",}),
   ({"PU","PU04","Oio","region",}),
   ({"PU","PU05","Bolama","region",}),
   ({"PU","PU06","Cacheu","region",}),
   ({"PU","PU07","Tombali","region",}),
   ({"PU","PU10","Gabu","region",}),
   ({"PU","PU11","Bissau","region",}),
   ({"PU","PU12","Biombo","region",}),
   ({"QA","QA01","Ad Dawhah","municipality/baladiyat",}),
   ({"QA","QA02","Al Ghuwayriyah","municipality/baladiyat",}),
   ({"QA","QA03","Al Jumayliyah","municipality/baladiyat",}),
   ({"QA","QA04","Al Khawr","municipality/baladiyat",}),
   ({"QA","QA05","Al Wakrah","municipality/baladiyat",}),
   ({"QA","QA06","Ar Rayyan","municipality/baladiyat",}),
   ({"QA","QA07","Jarayan al Batinah","municipality/baladiyat",}),
   ({"QA","QA08","Madinat ash Shamal","municipality/baladiyat",}),
   ({"QA","QA09","Umm Salal","municipality/baladiyat",}),
   ({"RO","RO01","Alba","county/judet",}),
   ({"RO","RO02","Arad","county/judet",}),
   ({"RO","RO03","Arges","county/judet",}),
   ({"RO","RO04","Bacau","county/judet",}),
   ({"RO","RO05","Bihor","county/judet",}),
   ({"RO","RO06","Bistrita-Nasaud","county/judet",}),
   ({"RO","RO07","Botosani","county/judet",}),
   ({"RO","RO08","Braila","county/judet",}),
   ({"RO","RO09","Brasov","county/judet",}),
   ({"RO","RO10","Bucuresti","municipality/municipiu",}),
   ({"RO","RO11","Buzau","county/judet",}),
   ({"RO","RO12","Caras-Severin","county/judet",}),
   ({"RO","RO13","Cluj","county/judet",}),
   ({"RO","RO14","Constanta","county/judet",}),
   ({"RO","RO15","Covasna","county/judet",}),
   ({"RO","RO16","Dimbovita","county/judet",}),
   ({"RO","RO17","Dolj","county/judet",}),
   ({"RO","RO18","Galati","county/judet",}),
   ({"RO","RO19","Gorj","county/judet",}),
   ({"RO","RO20","Harghita","county/judet",}),
   ({"RO","RO21","Hunedoara","county/judet",}),
   ({"RO","RO22","Ialomita","county/judet",}),
   ({"RO","RO23","Iasi","county/judet",}),
   ({"RO","RO25","Maramures","county/judet",}),
   ({"RO","RO26","Mehedinti","county/judet",}),
   ({"RO","RO27","Mures","county/judet",}),
   ({"RO","RO28","Neamt","county/judet",}),
   ({"RO","RO29","Olt","county/judet",}),
   ({"RO","RO30","Prahova","county/judet",}),
   ({"RO","RO31","Salaj","county/judet",}),
   ({"RO","RO32","Satu Mare","county/judet",}),
   ({"RO","RO33","Sibiu","county/judet",}),
   ({"RO","RO34","Suceava","county/judet",}),
   ({"RO","RO35","Teleorman","county/judet",}),
   ({"RO","RO36","Timis","county/judet",}),
   ({"RO","RO37","Tulcea","county/judet",}),
   ({"RO","RO38","Vaslui","county/judet",}),
   ({"RO","RO39","Vilcea","county/judet",}),
   ({"RO","RO40","Vrancea","county/judet",}),
   ({"RO","RO41","Calarasi","county/judet",}),
   ({"RO","RO42","Giurgiu","county/judet",}),
   ({"RP","RP01","Abra","province",}),
   ({"RP","RP02","Agusan del Norte","province",}),
   ({"RP","RP03","Agusan del Sur","province",}),
   ({"RP","RP04","Aklan","province",}),
   ({"RP","RP05","Albay","province",}),
   ({"RP","RP06","Antique","province",}),
   ({"RP","RP07","Bataan","province",}),
   ({"RP","RP08","Batanes","province",}),
   ({"RP","RP09","Batangas","province",}),
   ({"RP","RP10","Benguet","province",}),
   ({"RP","RP11","Bohol","province",}),
   ({"RP","RP12","Bukidnon","province",}),
   ({"RP","RP13","Bulacan","province",}),
   ({"RP","RP14","Cagayan","province",}),
   ({"RP","RP15","Camarines Norte","province",}),
   ({"RP","RP16","Camarines Sur","province",}),
   ({"RP","RP17","Camiguin","province",}),
   ({"RP","RP18","Capiz","province",}),
   ({"RP","RP19","Catanduanes","province",}),
   ({"RP","RP20","Cavite","province",}),
   ({"RP","RP21","Cebu","province",}),
   ({"RP","RP22","Basilan","province",}),
   ({"RP","RP23","Eastern Samar","province",}),
   ({"RP","RP24","Davao del Norte","province",}),
   ({"RP","RP25","Davao del Sur","province",}),
   ({"RP","RP26","Davao Oriental","province",}),
   ({"RP","RP27","Ifugao","province",}),
   ({"RP","RP28","Ilocos Norte","province",}),
   ({"RP","RP29","Ilocos Sur","province",}),
   ({"RP","RP30","Iloilo","province",}),
   ({"RP","RP31","Isabela","province",}),
   ({"RP","RP32","Kalinga-Apayao","province",}),
   ({"RP","RP33","Laguna","province",}),
   ({"RP","RP34","Lanao del Norte","province",}),
   ({"RP","RP35","Lanao del Sur","province",}),
   ({"RP","RP36","La Union","province",}),
   ({"RP","RP37","Leyte","province",}),
   ({"RP","RP38","Marinduque","province",}),
   ({"RP","RP39","Masbate","province",}),
   ({"RP","RP40","Mindoro Occidental","province",}),
   ({"RP","RP41","Mindoro Oriental","province",}),
   ({"RP","RP42","Misamis Occidental","province",}),
   ({"RP","RP43","Misamis Oriental","province",}),
   ({"RP","RP44","Mountain","province",}),
   ({"RP","RP45","RP45","province",}),
   ({"RP","RP46","Negros Oriental","province",}),
   ({"RP","RP47","Nueva Ecija","province",}),
   ({"RP","RP48","Nueva Vizcaya","province",}),
   ({"RP","RP49","Palawan","province",}),
   ({"RP","RP50","Pampanga","province",}),
   ({"RP","RP51","Pangasinan","province",}),
   ({"RP","RP53","Rizal","province",}),
   ({"RP","RP54","Romblon","province",}),
   ({"RP","RP55","Samar","province",}),
   ({"RP","RP56","Maguindanao","province",}),
   ({"RP","RP57","North Cotabato","province",}),
   ({"RP","RP58","Sorsogon","province",}),
   ({"RP","RP59","Southern Leyte","province",}),
   ({"RP","RP60","Sulu","province",}),
   ({"RP","RP61","Surigao del Norte","province",}),
   ({"RP","RP62","Surigao del Sur","province",}),
   ({"RP","RP63","Tarlac","province",}),
   ({"RP","RP64","Zambales","province",}),
   ({"RP","RP65","Zamboanga del Norte","province",}),
   ({"RP","RP66","Zamboanga del Sur","province",}),
   ({"RP","RP67","Northern Samar","province",}),
   ({"RP","RP68","Quirino","province",}),
   ({"RP","RP69","Siquijor","province",}),
   ({"RP","RP70","South Cotabato","province",}),
   ({"RP","RP71","Sultan Kudarat","province",}),
   ({"RP","RP72","Tawi-Tawi","province",}),
   ({"RP","RPA1","Angeles","charter city",}),
   ({"RP","RPA2","Bacolod","charter city",}),
   ({"RP","RPA3","Bago","charter city",}),
   ({"RP","RPA4","Baguio","charter city",}),
   ({"RP","RPA5","Bais","charter city",}),
   ({"RP","RPA6","Basilan City","charter city",}),
   ({"RP","RPA7","Batangas City","charter city",}),
   ({"RP","RPA8","Butuan","charter city",}),
   ({"RP","RPA9","Cabanatuan","charter city",}),
   ({"RP","RPB1","Cadiz","charter city",}),
   ({"RP","RPB2","Cagayan de Oro","charter city",}),
   ({"RP","RPB3","Calbayog","charter city",}),
   ({"RP","RPB4","Caloocan","charter city",}),
   ({"RP","RPB5","Canlaon","charter city",}),
   ({"RP","RPB6","Cavite City","charter city",}),
   ({"RP","RPB7","Cebu City","charter city",}),
   ({"RP","RPB8","Cotabato","charter city",}),
   ({"RP","RPB9","Dagupan","charter city",}),
   ({"RP","RPC1","Danao","charter city",}),
   ({"RP","RPC2","Dapitane","charter city",}),
   ({"RP","RPC3","Davao City","charter city",}),
   ({"RP","RPC4","Dipolog","charter city",}),
   ({"RP","RPC5","Dumaguete","charter city",}),
   ({"RP","RPC6","General Santos","charter city",}),
   ({"RP","RPC7","Gingoog","charter city",}),
   ({"RP","RPC8","Iligan","charter city",}),
   ({"RP","RPC9","Iloilo City","charter city",}),
   ({"RP","RPD1","Iriga","charter city",}),
   ({"RP","RPD2","La Carlota","charter city",}),
   ({"RP","RPD3","Laoag","charter city",}),
   ({"RP","RPD4","LapuLapu","charter city",}),
   ({"RP","RPD5","Legaspi","charter city",}),
   ({"RP","RPD6","Lipa","charter city",}),
   ({"RP","RPD7","Lucena","charter city",}),
   ({"RP","RPD8","Mandaue","charter city",}),
   ({"RP","RPD9","Manila","charter city",}),
   ({"RP","RPE1","Marawi","charter city",}),
   ({"RP","RPE2","Naga","charter city",}),
   ({"RP","RPE3","Olongapo","charter city",}),
   ({"RP","RPE4","Ormoc","charter city",}),
   ({"RP","RPE5","Oroquieta","charter city",}),
   ({"RP","RPE6","Ozamis","charter city",}),
   ({"RP","RPE7","Pagadiane","charter city",}),
   ({"RP","RPE8","Palayan","charter city",}),
   ({"RP","RPE9","Pasay","charter city",}),
   ({"RP","RPF1","Puerto Princesa","charter city",}),
   ({"RP","RPF2","Quezon City","charter city",}),
   ({"RP","RPF3","Roxas","charter city",}),
   ({"RP","RPF4","San Carlos, Negros Occidental","charter city",}),
   ({"RP","RPF5","San Carlos, Pangasinan","charter city",}),
   ({"RP","RPF6","San Jose","charter city",}),
   ({"RP","RPF7","San Pablo","charter city",}),
   ({"RP","RPF8","Silay","charter city",}),
   ({"RP","RPF9","Surigao","charter city",}),
   ({"RP","RPG1","Tacloban","charter city",}),
   ({"RP","RPG2","Tagaytay","charter city",}),
   ({"RP","RPG3","Tagbilaran","charter city",}),
   ({"RP","RPG4","Tangub","charter city",}),
   ({"RP","RPG5","Toledo","charter city",}),
   ({"RP","RPG6","Trece Martires","charter city",}),
   ({"RP","RPG7","Zamboanga","charter city",}),
   ({"RP","RPG8","Aurora","province",}),
   ({"RP","RPH2","Quezon","province",}),
   ({"RP","RPH3","Negros Occidental","province",}),
   ({"RS","RS01","Adygeya","republic/respublika",}),
   ({"RS","RS02","Aginskiy Buryatskiy Avtonomnyy Okrug","city/gorod",}),
   ({"RS","RS03","Altay","republic/respublika",}),
   ({"RS","RS04","Altayskiy Kray","kray/kray",}),
   ({"RS","RS05","Amurskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS06","Arkhangel'skaya Oblast'","oblast/oblast'",}),
   ({"RS","RS07","Astrakhanskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS08","Bashkortostan","republic/respublika",}),
   ({"RS","RS09","Belgorodskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS10","Bryanskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS11","Buryatiya","republic/respublika",}),
   ({"RS","RS12","Chechnya","republic/respublika",}),
   ({"RS","RS13","Chelyabinskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS14","Chitinskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS15","Chukotskiy Avtonomnyy Okrug","kray/kray",}),
   ({"RS","RS16","Chuvashiya","republic/respublika",}),
   ({"RS","RS17","Dagestan","republic/respublika",}),
   ({"RS","RS18","Evenkiyskiy Avtonomnyy Okrug","kray/kray",}),
   ({"RS","RS19","Ingushetiya","republic/respublika",}),
   ({"RS","RS20","Irkutskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS21","Ivanovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS22","Kabardino-Balkariya","republic/respublika",}),
   ({"RS","RS23","Kaliningradskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS24","Kalmykiya","republic/respublika",}),
   ({"RS","RS25","Kaluzhskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS26","Kamchatskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS27","Karachayevo-Cherkesiya","republic/respublika",}),
   ({"RS","RS28","Kareliya","city/gorod",}),
   ({"RS","RS29","Kemerovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS30","Khabarovskiy Kray","kray/kray",}),
   ({"RS","RS31","Khakasiya","republic/respublika",}),
   ({"RS","RS32","Khanty-Mansiyskiy Avtonomnyy Okrug","autonomous okrug/avtonomnyy okrug",}),
   ({"RS","RS33","Kirovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS34","Komi","republic/respublika",}),
   ({"RS","RS35","Komi-Permyatskiy Avtonomnyy Okrug","autonomous okrug/avtonomnyy okrug",}),
   ({"RS","RS36","Koryakskiy Avtonomnyy Okrug","autonomous okrug/avtonomnyy okrug",}),
   ({"RS","RS37","Kostromskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS38","Krasnodarskiy Kray","kray/kray",}),
   ({"RS","RS39","Krasnoyarskiy Kray","kray/kray",}),
   ({"RS","RS40","Kurganskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS41","Kurskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS42","Leningradskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS43","Lipetskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS44","Magadanskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS45","Mariy-El","republic/respublika",}),
   ({"RS","RS46","Mordoviya","republic/respublika",}),
   ({"RS","RS47","Moskovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS48","Moskva","city/gorod",}),
   ({"RS","RS49","Murmanskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS50","Nenetskiy Avtonomnyy Okrug","oblast/oblast'",}),
   ({"RS","RS51","Nizhegorodskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS52","Novgorodskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS53","Novosibirskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS54","Omskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS55","Orenburgskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS56","Orlovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS57","Penzenskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS58","Permskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS59","Primorskiy Kray","kray/kray",}),
   ({"RS","RS60","Pskovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS61","Rostovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS62","Ryazanskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS63","Sakha ","republic/respublika","Yakutiya",}),
   ({"RS","RS64","Sakhalinskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS65","Samarskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS66","Sankt-Peterburg","city/gorod",}),
   ({"RS","RS67","Saratovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS68","Severnaya Osetiya-Alaniya","republic/respublika",}),
   ({"RS","RS69","Smolenskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS70","Stavropol'skiy Kray","kray/kray",}),
   ({"RS","RS71","Sverdlovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS72","Tambovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS73","Tatarstan","republic/respublika",}),
   ({"RS","RS74","Taymyrskiy ","autonomous okrug/avtonomnyy okrug","Dolgano-Nenetskiy",}),
   ({"RS","RS75","Tomskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS76","Tul'skaya Oblast'","oblast/oblast'",}),
   ({"RS","RS77","Tverskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS78","Tyumenskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS79","Tyva","republic/respublika",}),
   ({"RS","RS80","Udmurtiya","republic/respublika",}),
   ({"RS","RS81","Ul'yanovskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS82","Ust'-Ordynskiy Buryatskiy Avtonomnyy Okrug","autonomous okrug/avtonomnyy okrug",}),
   ({"RS","RS83","Vladimirskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS84","Volgogradskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS85","Vologodskaya oblast'","oblast/oblast'",}),
   ({"RS","RS86","Voronezhskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS87","Yamalo-Nenetskiy Avtonomnyy Okrug","autonomous okrug/avtonomnyy okrug",}),
   ({"RS","RS88","Yaroslavskaya Oblast'","oblast/oblast'",}),
   ({"RS","RS89","Yevreyskaya Avtonomnyy Oblast'","autonomous oblast/avtonomnaya oblast'",}),
   ({"RS","RSCI","Chechnya and Ingushetiya","oblast/oblast'",}),
   ({"RS","RSJA","RSJA","oblast/oblast'",}),
   ({"RW","RW01","Butare","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW02","Byumba","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW03","Cyangugu","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW04","Gikongoro","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW05","Gisenyi","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW06","Gitarama","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW07","Kibungo","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW08","Kibuye","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW09","Kigali","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"RW","RW10","Ruhengeri","prefecture/prefecture (French), prefegitura (Kinyarwanda)",}),
   ({"SA","SA02","Al Bahah","emirate/mintaqah",}),
   ({"SA","SA05","Al Madinah","emirate/mintaqah",}),
   ({"SA","SA06","Ash Sharqiyah","emirate/mintaqah",}),
   ({"SA","SA07","SA07","emirate/mintaqah",}),
   ({"SA","SA08","Al Qasim","emirate/mintaqah",}),
   ({"SA","SA10","Ar Riyad","emirate/mintaqah",}),
   ({"SA","SA11","'Asir","emirate/mintaqah",}),
   ({"SA","SA13","Ha'il","emirate/mintaqah",}),
   ({"SA","SA14","Makkah","emirate/mintaqah",}),
   ({"SA","SA15","Al Hudud ash Shamaliyah","emirate/mintaqah",}),
   ({"SA","SA16","Najran","emirate/mintaqah",}),
   ({"SA","SA17","Jizan","emirate/mintaqah",}),
   ({"SA","SA19","Tabuk","emirate/mintaqah",}),
   ({"SA","SA20","Al Jawf","emirate/mintaqah",}),
   ({"SA","SA99","SA99","emirate/mintaqah",}),
   ({"SC","SC01","Christ Church Nicholatown","parish",}),
   ({"SC","SC02","Saint Anne Sandy Point","parish",}),
   ({"SC","SC03","Saint George Basseterre","parish",}),
   ({"SC","SC04","Saint George Gingerland","parish",}),
   ({"SC","SC05","Saint James Windward","parish",}),
   ({"SC","SC06","Saint John Capesterre","parish",}),
   ({"SC","SC07","Saint John Figtree","parish",}),
   ({"SC","SC08","Saint Mary Cayon","parish",}),
   ({"SC","SC09","Saint Paul Capesterre","parish",}),
   ({"SC","SC10","Saint Paul Charlestown","parish",}),
   ({"SC","SC11","Saint Peter Basseterre","parish",}),
   ({"SC","SC12","Saint Thomas Lowland","parish",}),
   ({"SC","SC13","Saint Thomas Middle Island","parish",}),
   ({"SC","SC15","Trinity Palmetto Point","parish",}),
   ({"SE","SE01","Anse aux Pins","district/district",}),
   ({"SE","SE02","Anse Boileau","district/district",}),
   ({"SE","SE03","Anse Etoile","district/district",}),
   ({"SE","SE04","Anse Louis","district/district",}),
   ({"SE","SE05","Anse Royale","district/district",}),
   ({"SE","SE06","Baie Lazare","district/district",}),
   ({"SE","SE07","Baie Sainte Anne","district/district",}),
   ({"SE","SE08","Beau Vallon","district/district",}),
   ({"SE","SE09","Bel Air","district/district",}),
   ({"SE","SE10","Bel Ombre","district/district",}),
   ({"SE","SE11","Cascade","district/district",}),
   ({"SE","SE12","Glacis","district/district",}),
   ({"SE","SE13","Grand' Anse","district/district",}),
   ({"SE","SE14","Grand' Anse","district/district",}),
   ({"SE","SE15","La Digue","district/district",}),
   ({"SE","SE16","La Riviere Anglaise","district/district",}),
   ({"SE","SE17","Mont Buxton","district/district",}),
   ({"SE","SE18","Mont Fleuri","district/district",}),
   ({"SE","SE19","Plaisance","district/district",}),
   ({"SE","SE20","Pointe La Rue","district/district",}),
   ({"SE","SE21","Port Glaud","district/district",}),
   ({"SE","SE22","Saint Louis","district/district",}),
   ({"SE","SE23","Takamaka","district/district",}),
// ({"SF","SF01","Cape Province","province",}),	// obsolete
   ({"SF","SF02","KwaZulu-Natal","province",}),
   ({"SF","SF03","Free State","province",}),
// ({"SF","SF04","Transvaal","province",}),	// obsolete
   ({"SF","SF05","Eastern Cape","province",}),
   ({"SF","SF06","Gauteng","province",}),
   ({"SF","SF07","Mpumalanga","province",}),
   ({"SF","SF08","Northern Cape","province",}),
   ({"SF","SF09","Northern Province","province",}),
   ({"SF","SF10","North-West","province",}),
   ({"SF","SF11","Western Cape","province",}),
   ({"SG","SG01","Dakar","region/region",}),
   ({"SG","SG03","Diourbel","region/region",}),
   ({"SG","SG04","Saint-Louis","region/region",}),
   ({"SG","SG05","Tambacounda","region/region",}),
   ({"SG","SG07","Thies","region/region",}),
   ({"SG","SG08","Louga","region/region",}),
   ({"SG","SG09","Fatick","region/region",}),
   ({"SG","SG10","Kaolack","region/region",}),
   ({"SG","SG11","Kolda","region/region",}),
   ({"SG","SG12","Ziguinchor","region/region",}),
   ({"SH","SH01","Ascension","administrative area",}),
   ({"SH","SH02","Saint Helena","dependency",}),
   ({"SH","SH03","Tristan da Cunha","dependency",}),
   ({"SI","SI01","Ajdovscina","commune/obcina",}),
   ({"SI","SI02","Beltinci","commune/obcina",}),
   ({"SI","SI03","Bled","commune/obcina",}),
   ({"SI","SI04","Bohinj","commune/obcina",}),
   ({"SI","SI05","Borovnica","commune/obcina",}),
   ({"SI","SI06","Bovec","commune/obcina",}),
   ({"SI","SI07","Brda","commune/obcina",}),
   ({"SI","SI08","Brezice","commune/obcina",}),
   ({"SI","SI09","Brezovica","commune/obcina",}),
   ({"SI","SI10","Cankova-Tisina","commune/obcina",}),
   ({"SI","SI11","Celje","commune/obcina",}),
   ({"SI","SI12","Cerklje na Gorenjskem","commune/obcina",}),
   ({"SI","SI13","Cerknica","commune/obcina",}),
   ({"SI","SI14","Cerkno","commune/obcina",}),
   ({"SI","SI15","Crensovci","commune/obcina",}),
   ({"SI","SI16","Crna na Koroskem","commune/obcina",}),
   ({"SI","SI17","Crnomelj","commune/obcina",}),
   ({"SI","SI18","Destrnik-Trnovska Vas","commune/obcina",}),
   ({"SI","SI19","Divaca","commune/obcina",}),
   ({"SI","SI20","Dobrepolje","commune/obcina",}),
   ({"SI","SI21","Dobrova-Horjul-Polhov Gradec","commune/obcina",}),
   ({"SI","SI22","Dol pri Ljubljani","commune/obcina",}),
   ({"SI","SI23","Domzale","commune/obcina",}),
   ({"SI","SI24","Dornava","commune/obcina",}),
   ({"SI","SI25","Dravograd","commune/obcina",}),
   ({"SI","SI26","Duplek","commune/obcina",}),
   ({"SI","SI27","Gorenja Vas-Poljane","commune/obcina",}),
   ({"SI","SI28","Gorisnica","commune/obcina",}),
   ({"SI","SI29","Gornja Radgona","commune/obcina",}),
   ({"SI","SI30","Gornji Grad","commune/obcina",}),
   ({"SI","SI31","Gornji Petrovci","commune/obcina",}),
   ({"SI","SI32","Grosuplje","commune/obcina",}),
   ({"SI","SI33","HodosSalovci","commune/obcina",}),
   ({"SI","SI34","Hrastnik","commune/obcina",}),
   ({"SI","SI35","Hrpelje-Kozina","commune/obcina",}),
   ({"SI","SI36","Idrija","commune/obcina",}),
   ({"SI","SI37","Ig","commune/obcina",}),
   ({"SI","SI38","Ilirska Bistrica","commune/obcina",}),
   ({"SI","SI39","Ivancna Gorica","commune/obcina",}),
   ({"SI","SI40","Izola","commune/obcina",}),
   ({"SI","SI41","Jesenice","commune/obcina",}),
   ({"SI","SI42","Jursinci","commune/obcina",}),
   ({"SI","SI43","Kamnik","commune/obcina",}),
   ({"SI","SI44","Kanal","commune/obcina",}),
   ({"SI","SI45","Kidricevo","commune/obcina",}),
   ({"SI","SI46","Kobarid","commune/obcina",}),
   ({"SI","SI47","Kobilje","commune/obcina",}),
   ({"SI","SI48","Kocevje","commune/obcina",}),
   ({"SI","SI49","Komen","commune/obcina",}),
   ({"SI","SI50","Koper","urban commune/mestna obcina",}),
   ({"SI","SI51","Kozje","commune/obcina",}),
   ({"SI","SI52","Kranj","commune/obcina",}),
   ({"SI","SI53","Kranjska Gora","commune/obcina",}),
   ({"SI","SI54","Krsko","commune/obcina",}),
   ({"SI","SI55","Kungota","commune/obcina",}),
   ({"SI","SI56","Kuzma","commune/obcina",}),
   ({"SI","SI57","Lasko","commune/obcina",}),
   ({"SI","SI58","Lenart","commune/obcina",}),
   ({"SI","SI59","Lendava","commune/obcina",}),
   ({"SI","SI60","Litija","commune/obcina",}),
   ({"SI","SI61","Ljubljana","urban commune/mestna obcina",}),
   ({"SI","SI62","Ljubno","commune/obcina",}),
   ({"SI","SI63","Ljutomer","commune/obcina",}),
   ({"SI","SI64","Logatec","commune/obcina",}),
   ({"SI","SI65","Loska Dolina","commune/obcina",}),
   ({"SI","SI66","Loski Potok","commune/obcina",}),
   ({"SI","SI67","Luce","commune/obcina",}),
   ({"SI","SI68","Lukovica","commune/obcina",}),
   ({"SI","SI69","Majsperk","commune/obcina",}),
   ({"SI","SI70","Maribor","urban commune/mestna obcina",}),
   ({"SI","SI71","Medvode","commune/obcina",}),
   ({"SI","SI72","Menges","commune/obcina",}),
   ({"SI","SI73","Metlika","commune/obcina",}),
   ({"SI","SI74","Mezica","commune/obcina",}),
   ({"SI","SI75","Miren-Kostanjevica","commune/obcina",}),
   ({"SI","SI76","Mislinja","commune/obcina",}),
   ({"SI","SI77","Moravce","commune/obcina",}),
   ({"SI","SI78","Moravske Toplice","commune/obcina",}),
   ({"SI","SI79","Mozirje","commune/obcina",}),
   ({"SI","SI80","Murska Sobota","urban commune/mestna obcina",}),
   ({"SI","SI81","Muta","commune/obcina",}),
   ({"SI","SI82","Naklo","commune/obcina",}),
   ({"SI","SI83","Nazarje","commune/obcina",}),
   ({"SI","SI84","Nova Gorica","urban commune/mestna obcina",}),
   ({"SI","SI85","Novo Mesto","urban commune/mestna obcina",}),
   ({"SI","SI86","Odranci","commune/obcina",}),
   ({"SI","SI87","Ormoz","commune/obcina",}),
   ({"SI","SI88","Osilnica","commune/obcina",}),
   ({"SI","SI89","Pesnica","commune/obcina",}),
   ({"SI","SI90","Piran","commune/obcina",}),
   ({"SI","SI91","Pivka","commune/obcina",}),
   ({"SI","SI92","Podcetrtek","commune/obcina",}),
   ({"SI","SI93","Podvelka-Ribnica","commune/obcina",}),
   ({"SI","SI94","Postojna","commune/obcina",}),
   ({"SI","SI95","Preddvor","commune/obcina",}),
   ({"SI","SI96","Ptuj","urban commune/mestna obcina",}),
   ({"SI","SI97","Puconci","commune/obcina",}),
   ({"SI","SI98","Race-Fram","commune/obcina",}),
   ({"SI","SI99","Radece","commune/obcina",}),
   ({"SI","SIA1","Radenci","commune/obcina",}),
   ({"SI","SIA2","Radlje ob Dravi","commune/obcina",}),
   ({"SI","SIA3","Radovljica","commune/obcina",}),
   ({"SI","SIA4","Ravne-Prevalje","commune/obcina",}),
   ({"SI","SIA5","Ribnica","commune/obcina",}),
   ({"SI","SIA6","Rogasevci","commune/obcina",}),
   ({"SI","SIA7","Rogaska Slatina","commune/obcina",}),
   ({"SI","SIA8","Rogatec","commune/obcina",}),
   ({"SI","SIA9","Ruse","commune/obcina",}),
   ({"SI","SIB1","Semic","commune/obcina",}),
   ({"SI","SIB2","Sencur","commune/obcina",}),
   ({"SI","SIB3","Sentilj","commune/obcina",}),
   ({"SI","SIB4","Sentjernej","commune/obcina",}),
   ({"SI","SIB5","Sentjur pri Celju","commune/obcina",}),
   ({"SI","SIB6","Sevnica","commune/obcina",}),
   ({"SI","SIB7","Sezana","commune/obcina",}),
   ({"SI","SIB8","Skocjan","commune/obcina",}),
   ({"SI","SIB9","Skofja Loka","commune/obcina",}),
   ({"SI","SIC1","Skofljica","commune/obcina",}),
   ({"SI","SIC2","Slovenj Gradec","urban commune/mestna obcina",}),
   ({"SI","SIC3","Slovenska Bistrica","commune/obcina",}),
   ({"SI","SIC4","Slovenske Konjice","commune/obcina",}),
   ({"SI","SIC5","Smarje pri Jelsah","commune/obcina",}),
   ({"SI","SIC6","Smartno ob Paki","commune/obcina",}),
   ({"SI","SIC7","Sostanj","commune/obcina",}),
   ({"SI","SIC8","Starse","commune/obcina",}),
   ({"SI","SIC9","Store","commune/obcina",}),
   ({"SI","SID1","Sveti Jurij","commune/obcina",}),
   ({"SI","SID2","Tolmin","commune/obcina",}),
   ({"SI","SID3","Trbovlje","commune/obcina",}),
   ({"SI","SID4","Trebnje","commune/obcina",}),
   ({"SI","SID5","Trzic","commune/obcina",}),
   ({"SI","SID6","Turnisce","commune/obcina",}),
   ({"SI","SID7","Velenje","urban commune/mestna obcina",}),
   ({"SI","SID8","Velike Lasce","urban commune/mestna obcina",}),
   ({"SI","SID9","Videm","commune/obcina",}),
   ({"SI","SIE1","Vipava","commune/obcina",}),
   ({"SI","SIE2","Vitanje","commune/obcina",}),
   ({"SI","SIE3","Vodice","commune/obcina",}),
   ({"SI","SIE4","Vojnik","commune/obcina",}),
   ({"SI","SIE5","Vrhnika","commune/obcina",}),
   ({"SI","SIE6","Vuzenica","commune/obcina",}),
   ({"SI","SIE7","Zagorje ob Savi","commune/obcina",}),
   ({"SI","SIE8","Zalec","commune/obcina",}),
   ({"SI","SIE9","Zavrc","commune/obcina",}),
   ({"SI","SIF1","Zelezniki","commune/obcina",}),
   ({"SI","SIF2","Ziri","commune/obcina",}),
   ({"SI","SIF3","Zrece","commune/obcina",}),
   ({"SL","SL01","Eastern","province",}),
   ({"SL","SL02","Northern","province",}),
   ({"SL","SL03","Southern","province",}),
   ({"SL","SL04","Western Area","province",}),
   ({"SM","SM01","Acquaviva","municipality/castello",}),
   ({"SM","SM02","Chiesanuova","municipality/castello",}),
   ({"SM","SM03","Domagnano","municipality/castello",}),
   ({"SM","SM04","Faetano","municipality/castello",}),
   ({"SM","SM05","Fiorentino","municipality/castello",}),
   ({"SM","SM06","Borgo Maaggiore","municipality/castello",}),
   ({"SM","SM07","San Marino","municipality/castello",}),
   ({"SM","SM08","Monte Giardino","municipality/castello",}),
   ({"SM","SM09","Serravalle","municipality/castello",}),
   ({"SO","SO01","Bakool","region/gobolka",}),
   ({"SO","SO02","Banaadir","region/gobolka",}),
   ({"SO","SO03","Bari","region/gobolka",}),
   ({"SO","SO04","Bay","region/gobolka",}),
   ({"SO","SO05","Galguduud","region/gobolka",}),
   ({"SO","SO06","Gedo","region/gobolka",}),
   ({"SO","SO07","Hiiraan","region/gobolka",}),
   ({"SO","SO08","Jubbada Dhexe","region/gobolka",}),
   ({"SO","SO09","Jubbada Hoose","region/gobolka",}),
   ({"SO","SO10","Mudug","region/gobolka",}),
   ({"SO","SO11","Nugaal","region/gobolka",}),
   ({"SO","SO12","Sanaag","region/gobolka",}),
   ({"SO","SO13","Shabeellaha Dhexe","region/gobolka",}),
   ({"SO","SO14","Shabeellaha Hoose","region/gobolka",}),
   ({"SO","SO15","Togdheer","region/gobolka",}),
   ({"SO","SO16","Woqooyi Galbeed","region/gobolka",}),
   ({"SO","SO17","SO17","region/gobolka",}),
   ({"SP","SP01","SP01","autonomous community/comunidad autonoma",}),
   ({"SP","SP02","SP02","autonomous community/comunidad autonoma",}),
   ({"SP","SP03","SP03","autonomous community/comunidad autonoma",}),
   ({"SP","SP04","SP04","autonomous community/comunidad autonoma",}),
   ({"SP","SP05","SP05","autonomous community/comunidad autonoma",}),
   ({"SP","SP06","SP06","autonomous community/comunidad autonoma",}),
   ({"SP","SP07","Islas Baleares","autonomous community/comunidad autonoma",}),
   ({"SP","SP08","SP08","autonomous community/comunidad autonoma",}),
   ({"SP","SP09","SP09","autonomous community/comunidad autonoma",}),
   ({"SP","SP10","SP10","autonomous community/comunidad autonoma",}),
   ({"SP","SP11","SP11","autonomous community/comunidad autonoma",}),
   ({"SP","SP12","SP12","autonomous community/comunidad autonoma",}),
   ({"SP","SP13","SP13","autonomous community/comunidad autonoma",}),
   ({"SP","SP14","SP14","autonomous community/comunidad autonoma",}),
   ({"SP","SP15","SP15","autonomous community/comunidad autonoma",}),
   ({"SP","SP16","SP16","autonomous community/comunidad autonoma",}),
   ({"SP","SP17","SP17","autonomous community/comunidad autonoma",}),
   ({"SP","SP18","SP18","autonomous community/comunidad autonoma",}),
   ({"SP","SP19","SP19","autonomous community/comunidad autonoma",}),
   ({"SP","SP20","SP20","autonomous community/comunidad autonoma",}),
   ({"SP","SP21","SP21","autonomous community/comunidad autonoma",}),
   ({"SP","SP22","SP22","autonomous community/comunidad autonoma",}),
   ({"SP","SP23","SP23","autonomous community/comunidad autonoma",}),
   ({"SP","SP24","SP24","autonomous community/comunidad autonoma",}),
   ({"SP","SP25","SP25","autonomous community/comunidad autonoma",}),
   ({"SP","SP26","SP26","autonomous community/comunidad autonoma",}),
   ({"SP","SP27","La Rioja","autonomous community/comunidad autonoma",}),
   ({"SP","SP28","SP28","autonomous community/comunidad autonoma",}),
   ({"SP","SP29","Madrid","autonomous community/comunidad autonoma",}),
   ({"SP","SP30","SP30","autonomous community/comunidad autonoma",}),
   ({"SP","SP31","Murcia","autonomous community/comunidad autonoma",}),
   ({"SP","SP32","Navarra","autonomous community/comunidad autonoma",}),
   ({"SP","SP33","SP33","autonomous community/comunidad autonoma",}),
   ({"SP","SP34","Asturias","autonomous community/comunidad autonoma",}),
   ({"SP","SP35","SP35","autonomous community/comunidad autonoma",}),
   ({"SP","SP36","SP36","autonomous community/comunidad autonoma",}),
   ({"SP","SP37","SP37","autonomous community/comunidad autonoma",}),
   ({"SP","SP38","SP38","autonomous community/comunidad autonoma",}),
   ({"SP","SP39","Cantabria","autonomous community/comunidad autonoma",}),
   ({"SP","SP40","SP40","autonomous community/comunidad autonoma",}),
   ({"SP","SP41","SP41","autonomous community/comunidad autonoma",}),
   ({"SP","SP42","SP42","autonomous community/comunidad autonoma",}),
   ({"SP","SP43","SP43","autonomous community/comunidad autonoma",}),
   ({"SP","SP44","SP44","autonomous community/comunidad autonoma",}),
   ({"SP","SP45","SP45","autonomous community/comunidad autonoma",}),
   ({"SP","SP46","SP46","autonomous community/comunidad autonoma",}),
   ({"SP","SP47","SP47","autonomous community/comunidad autonoma",}),
   ({"SP","SP48","SP48","autonomous community/comunidad autonoma",}),
   ({"SP","SP49","SP49","autonomous community/comunidad autonoma",}),
   ({"SP","SP50","SP50","autonomous community/comunidad autonoma",}),
   ({"SP","SP51","Andalucia","autonomous community/comunidad autonoma",}),
   ({"SP","SP52","Aragon","autonomous community/comunidad autonoma",}),
   ({"SP","SP53","Canarias","autonomous community/comunidad autonoma",}),
   ({"SP","SP54","Castilla-La Mancha","autonomous community/comunidad autonoma",}),
   ({"SP","SP55","Castilla y Leon","autonomous community/comunidad autonoma",}),
   ({"SP","SP56","Cataluna","autonomous community/comunidad autonoma",}),
   ({"SP","SP57","Extremadura","autonomous community/comunidad autonoma",}),
   ({"SP","SP58","Galicia","autonomous community/comunidad autonoma",}),
   ({"SP","SP59","Pais Vasco","autonomous community/comunidad autonoma",}),
   ({"SP","SP60","Valenciana","autonomous community/comunidad autonoma",}),
   ({"ST","ST01","Anse-la-Raye","quarter",}),
   ({"ST","ST02","Dauphin","quarter",}),
   ({"ST","ST03","Castries","quarter",}),
   ({"ST","ST04","Choiseul","quarter",}),
   ({"ST","ST05","Dennery","quarter",}),
   ({"ST","ST06","Gros-Islet","quarter",}),
   ({"ST","ST07","Laborie","quarter",}),
   ({"ST","ST08","Micoud","quarter",}),
   ({"ST","ST09","Soufriere","quarter",}),
   ({"ST","ST10","Vieux-Fort","quarter",}),
   ({"ST","ST11","Praslin","quarter",}),
// ({"SU","SU26","A'ali an Nil","province/wilayat",}),	// obsolete
   ({"SU","SU27","SU27","province/wilayat",}),
// ({"SU","SU28","Al Istiwa'iyah","province/wilayat",}),	// obsolete
   ({"SU","SU29","Al Khartum","province/wilayat",}),
// ({"SU","SU30","Ash Shamaliyah","province/wilayat",}),	// obsolete
   ({"SU","SU31","SU31","province/wilayat",}),
   ({"SU","SU32","SU32","province/wilayat",}),
   ({"SU","SU33","SU33","province/wilayat",}),
   ({"SU","SU34","SU34","province/wilayat",}),
   ({"SU","SU35","A'ali an Nil","province/wilayat",}),
   ({"SU","SU36","Al Babr al Ahmar","province/wilayat",}),
   ({"SU","SU37","Al Buhayrat","province/wilayat",}),
   ({"SU","SU38","Al Jazirah","province/wilayat",}),
   ({"SU","SU39","Al Qadarif","province/wilayat",}),
   ({"SU","SU40","Al Wahdah","province/wilayat",}),
   ({"SU","SU41","An Nil al Abyad","province/wilayat",}),
   ({"SU","SU42","An Nil al Azraq","province/wilayat",}),
   ({"SU","SU43","Ash Shamaliyah","province/wilayat",}),
   ({"SU","SU44","Bahr al Jabal","province/wilayat",}),
   ({"SU","SU45","Gharb al Istiwa'iyah","province/wilayat",}),
   ({"SU","SU46","Gharb Bahr al Ghazal","province/wilayat",}),
   ({"SU","SU47","Gharb Darfur","province/wilayat",}),
   ({"SU","SU48","Gharb Kurdufan","province/wilayat",}),
   ({"SU","SU49","Janub Darfur","province/wilayat",}),
   ({"SU","SU50","Janub Kurdufan","province/wilayat",}),
   ({"SU","SU51","Junqali","province/wilayat",}),
   ({"SU","SU52","Kassala","province/wilayat",}),
   ({"SU","SU53","Nahr an Nil","province/wilayat",}),
   ({"SU","SU54","Shamal Bahr al Ghazal","province/wilayat",}),
   ({"SU","SU55","Shamal Darfur","province/wilayat",}),
   ({"SU","SU56","Shamal Kurdufan","province/wilayat",}),
   ({"SU","SU57","Sharq al Istiwa'iyah","province/wilayat",}),
   ({"SU","SU58","Sinnar","province/wilayat",}),
   ({"SU","SU59","Warab","province/wilayat",}),
// ({"SW","SW01","Alvsborgs Lan","province/lan",}),	// obsolete
   ({"SW","SW02","Blekinge Lan","province/lan",}),
   ({"SW","SW03","Gavleborgs Lan","province/lan",}),
// ({"SW","SW04","Goteborgs och Bohus Lan","province/lan",}),	// obsolete
   ({"SW","SW05","Gotlands Lan","province/lan",}),
   ({"SW","SW06","Hallands Lan","province/lan",}),
   ({"SW","SW07","Jamtlands Lan","province/lan",}),
   ({"SW","SW08","Jonkopings Lan","province/lan",}),
   ({"SW","SW09","Kalmar Lan","province/lan",}),
   ({"SW","SW10","Dalarnas Lan","province/lan",}),
// ({"SW","SW11","Kristianstads Lan","province/lan",}),	// obsolete
   ({"SW","SW12","Kronobergs Lan","province/lan",}),
// ({"SW","SW13","Malmohus Lan","province/lan",}),	// obsolete
   ({"SW","SW14","Norrbottens Lan","province/lan",}),
   ({"SW","SW15","Orebro Lan","province/lan",}),
   ({"SW","SW16","Ostergotlands Lan","province/lan",}),
// ({"SW","SW17","Skaraborgs Lan","province/lan",}),	// obsolete
   ({"SW","SW18","Sodermanlands Lan","province/lan",}),
   ({"SW","SW21","Uppsala Lan","province/lan",}),
   ({"SW","SW22","Varmlands Lan","province/lan",}),
   ({"SW","SW23","Vasterbottens Lan","province/lan",}),
   ({"SW","SW24","Vasternorrlands Lan","province/lan",}),
   ({"SW","SW25","Vastmanlands Lan","province/lan",}),
   ({"SW","SW26","Stockholms Lan","province/lan",}),
   ({"SW","SW27","Skane Lan","province/lan",}),
   ({"SW","SW28","Vastra Gotaland","province/lan",}),
   ({"SY","SY01","Al Hasakah","province/muhafazah",}),
   ({"SY","SY02","Al Ladhiqiyah","province/muhafazah",}),
   ({"SY","SY03","Al Qunaytirah","province/muhafazah",}),
   ({"SY","SY04","Ar Raqqah","province/muhafazah",}),
   ({"SY","SY05","As Suwayda'","province/muhafazah",}),
   ({"SY","SY06","Dar'a","province/muhafazah",}),
   ({"SY","SY07","Dayr az Zawr","province/muhafazah",}),
   ({"SY","SY08","Rif Dimashq","province/muhafazah",}),
   ({"SY","SY09","Halab","province/muhafazah",}),
   ({"SY","SY10","Hamah","province/muhafazah",}),
   ({"SY","SY11","Hims","province/muhafazah",}),
   ({"SY","SY12","Idlib","province/muhafazah",}),
   ({"SY","SY13","Dimashq","province/muhafazah",}),
   ({"SY","SY14","Tartus","province/muhafazah",}),
   ({"SZ","SZ01","Aargau","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ02","Ausser-Rhoden","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ03","Basel-Landschaft","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ04","Basel-Stadt","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ05","Bern","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ06","Fribourg","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ07","Geneve","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ08","Glarus","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ09","Graubunden","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ10","Inner-Rhoden","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ11","Luzern","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ12","Neuchatel","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ13","Nidwalden","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ14","Obwalden","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ15","Sankt Gallen","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ16","Schaffhausen","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ17","Schwyz","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ18","Solothurn","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ19","Thurgau","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ20","Ticino","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ21","Uri","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ22","Valais","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ23","Vaud","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ24","Zug","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ25","Zurich","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"SZ","SZ26","Jura","canton/caton (French), cantone (Italian), kanton (German)",}),
   ({"TD","TD01","Arima","municipality",}),
   ({"TD","TD02","Caroni","county",}),
   ({"TD","TD03","Mayaro","county",}),
   ({"TD","TD04","Nariva","county",}),
   ({"TD","TD05","Port-of-Spain","municipality",}),
   ({"TD","TD06","Saint Andrew","county",}),
   ({"TD","TD07","Saint David","county",}),
   ({"TD","TD08","Saint George","county",}),
   ({"TD","TD09","Saint Patrick","county",}),
   ({"TD","TD10","San Fernando","municipality",}),
   ({"TD","TD11","Tobago","ward",}),
   ({"TD","TD12","Victoria","county",}),
   ({"TH","TH01","Mae Hong Son","province/changwat",}),
   ({"TH","TH02","Chiang Mai","province/changwat",}),
   ({"TH","TH03","Chiang Rai","province/changwat",}),
   ({"TH","TH04","Nan","province/changwat",}),
   ({"TH","TH05","Lamphun","province/changwat",}),
   ({"TH","TH06","Lampang","province/changwat",}),
   ({"TH","TH07","Phrae","province/changwat",}),
   ({"TH","TH08","Tak","province/changwat",}),
   ({"TH","TH09","Sukhothai","province/changwat",}),
   ({"TH","TH10","Uttaradit","province/changwat",}),
   ({"TH","TH11","Kamphaeng Phet","province/changwat",}),
   ({"TH","TH12","Phitsanulok","province/changwat",}),
   ({"TH","TH13","Phichit","province/changwat",}),
   ({"TH","TH14","Phetchabun","province/changwat",}),
   ({"TH","TH15","Uthai Thani","province/changwat",}),
   ({"TH","TH16","Nakhon Sawan","province/changwat",}),
   ({"TH","TH17","Nong Khai","province/changwat",}),
   ({"TH","TH18","Loei","province/changwat",}),
// ({"TH","TH19","Udon Thani","province/changwat",}),	// obsolete
   ({"TH","TH20","Sakon Nakhon","province/changwat",}),
// ({"TH","TH21","Nakhon Phanom","province/changwat",}),	// obsolete
   ({"TH","TH22","Khon Kaen","province/changwat",}),
   ({"TH","TH23","Kalasin","province/changwat",}),
   ({"TH","TH24","Maha Sarakham","province/changwat",}),
   ({"TH","TH25","Roi Et","province/changwat",}),
   ({"TH","TH26","Chaiyaphum","province/changwat",}),
   ({"TH","TH27","Nakhon Ratchasima","province/changwat",}),
   ({"TH","TH28","Buriram","province/changwat",}),
   ({"TH","TH29","Surin","province/changwat",}),
   ({"TH","TH30","Sisaket","province/changwat",}),
   ({"TH","TH31","Narathiwat","province/changwat",}),
   ({"TH","TH32","Chai Nat","province/changwat",}),
   ({"TH","TH33","Sing Buri","province/changwat",}),
   ({"TH","TH34","Lop Buri","province/changwat",}),
   ({"TH","TH35","Ang Thong","province/changwat",}),
   ({"TH","TH36","Phra Nakhon Si Ayutthaya","province/changwat",}),
   ({"TH","TH37","Sara Buri","province/changwat",}),
   ({"TH","TH38","Nonthaburi","province/changwat",}),
   ({"TH","TH39","Pathum Thani","province/changwat",}),
   ({"TH","TH40","Krung Thep Mahanakhon","municipality",}),
   ({"TH","TH41","Phayao","province/changwat",}),
   ({"TH","TH42","Samut Prakan","province/changwat",}),
   ({"TH","TH43","Nakhon Nayok","province/changwat",}),
   ({"TH","TH44","Chachoengsao","province/changwat",}),
// ({"TH","TH45","Prachin Buri","province/changwat",}),	// obsolete
   ({"TH","TH46","Chon Buri","province/changwat",}),
   ({"TH","TH47","Rayong","province/changwat",}),
   ({"TH","TH48","Chanthaburi","province/changwat",}),
   ({"TH","TH49","Trat","province/changwat",}),
   ({"TH","TH50","Kanchanaburi","province/changwat",}),
   ({"TH","TH51","Suphan Buri","province/changwat",}),
   ({"TH","TH52","Ratchaburi","province/changwat",}),
   ({"TH","TH53","Nakhon Pathom","province/changwat",}),
   ({"TH","TH54","Samut Songkhram","province/changwat",}),
   ({"TH","TH55","Samut Sakhon","province/changwat",}),
   ({"TH","TH56","Phetchaburi","province/changwat",}),
   ({"TH","TH57","Prachuap Khiri Khan","province/changwat",}),
   ({"TH","TH58","Chumphon","province/changwat",}),
   ({"TH","TH59","Ranong","province/changwat",}),
   ({"TH","TH60","Surat Thani","province/changwat",}),
   ({"TH","TH61","Phangnga","province/changwat",}),
   ({"TH","TH62","Phuket","province/changwat",}),
   ({"TH","TH63","Krabi","province/changwat",}),
   ({"TH","TH64","Nakon Si Thammarat","province/changwat",}),
   ({"TH","TH65","Trang","province/changwat",}),
   ({"TH","TH66","Phatthalung","province/changwat",}),
   ({"TH","TH67","Satun","province/changwat",}),
   ({"TH","TH68","Songkhla","province/changwat",}),
   ({"TH","TH69","Pattani","province/changwat",}),
   ({"TH","TH70","Yala","province/changwat",}),
// ({"TH","TH71","Ubon Ratchathani","province/changwat",}),	// obsolete
   ({"TH","TH72","Yasothon","province/changwat",}),
   ({"TH","TH73","Nakhon Phanom","province/changwat",}),
   ({"TH","TH74","Prachin Buri","province/changwat",}),
   ({"TH","TH75","Ubon Ratchanthani","province/changwat",}),
   ({"TH","TH76","Udon Thani","province/changwat",}),
   ({"TH","TH77","Amnat Charoen","province/changwat",}),
   ({"TH","TH78","Mukdahan","province/changwat",}),
   ({"TH","TH79","Nong Bua Lamphu","province/changwat",}),
   ({"TH","TH80","Sa Kaeo","province/changwat",}),
   ({"TI","TI01","Kuhistoni Badakhshon","autonomous province/viloyati mukhtor",}),
   ({"TI","TI02","Khatlon","province/viloyati",}),
   ({"TI","TI03","Leninobod","province/viloyati",}),
   ({"TN","TN01","Ha'apai","island group",}),
   ({"TN","TN02","Tongatapu","island group",}),
   ({"TN","TN03","Vava'u","island group",}),
   ({"TO","TO01","Amlame","circumscription/circonscription",}),
   ({"TO","TO02","Aneho","circumscription/circonscription",}),
   ({"TO","TO03","Atakpame","circumscription/circonscription",}),
   ({"TO","TO04","Bafilo","circumscription/circonscription",}),
   ({"TO","TO05","Bassar","circumscription/circonscription",}),
   ({"TO","TO06","Dapaong","circumscription/circonscription",}),
   ({"TO","TO07","Kante","circumscription/circonscription",}),
   ({"TO","TO08","Klouto","circumscription/circonscription",}),
   ({"TO","TO09","Lama-Kara","circumscription/circonscription",}),
   ({"TO","TO10","Lome","circumscription/circonscription",}),
   ({"TO","TO11","Mango","circumscription/circonscription",}),
   ({"TO","TO12","Niamtougou","circumscription/circonscription",}),
   ({"TO","TO13","Notse","circumscription/circonscription",}),
   ({"TO","TO14","Kpagouda","circumscription/circonscription",}),
   ({"TO","TO15","Badou","circumscription/circonscription",}),
   ({"TO","TO16","Sotouboua","circumscription/circonscription",}),
   ({"TO","TO17","Tabligbo","circumscription/circonscription",}),
   ({"TO","TO18","Tsevie","circumscription/circonscription",}),
   ({"TO","TO19","Tchamba","circumscription/circonscription",}),
   ({"TO","TO20","Tchaoudjo","circumscription/circonscription",}),
   ({"TO","TO21","Vogan","circumscription/circonscription",}),
   ({"TP","TP01","Principe","district/concelho",}),
   ({"TP","TP02","Sao Tome","district/concelho",}),
   ({"TS","TS02","Al Qasrayn","governorate/wilayah",}),
   ({"TS","TS03","Al Qayrawan","governorate/wilayah",}),
   ({"TS","TS06","Jundubah","governorate/wilayah",}),
   ({"TS","TS14","Al Kaf","governorate/wilayah",}),
   ({"TS","TS15","Al Mahdiyah","governorate/wilayah",}),
   ({"TS","TS16","Al Munastir","governorate/wilayah",}),
   ({"TS","TS17","Bajah","governorate/wilayah",}),
   ({"TS","TS18","Banzart","governorate/wilayah",}),
   ({"TS","TS19","Nabul","governorate/wilayah",}),
   ({"TS","TS22","Silyanah","governorate/wilayah",}),
   ({"TS","TS23","Susah","governorate/wilayah",}),
   ({"TS","TS26","Aryanah","governorate/wilayah",}),
   ({"TS","TS27","Bin 'Arus","governorate/wilayah",}),
   ({"TS","TS28","Madanin","governorate/wilayah",}),
   ({"TS","TS29","Qabis","governorate/wilayah",}),
   ({"TS","TS30","Qafsah","governorate/wilayah",}),
   ({"TS","TS31","Qibili","governorate/wilayah",}),
   ({"TS","TS32","Safaqi","governorate/wilayah",}),
   ({"TS","TS33","Sidi Bu Zayd","governorate/wilayah",}),
   ({"TS","TS34","Tatawin","governorate/wilayah",}),
   ({"TS","TS35","Tawzar","governorate/wilayah",}),
   ({"TS","TS36","Tunis","governorate/wilayah",}),
   ({"TS","TS37","Zaghwan","governorate/wilayah",}),
// ({"TU","TU01","Adana","province/il",}),	// obsolete
   ({"TU","TU02","Adiyaman","province/il",}),
   ({"TU","TU03","Afyon","province/il",}),
   ({"TU","TU04","Agri","province/il",}),
   ({"TU","TU05","Amasya","province/il",}),
   ({"TU","TU06","TU06","province/il",}),
   ({"TU","TU07","Antalya","province/il",}),
   ({"TU","TU08","Artvin","province/il",}),
   ({"TU","TU09","Aydin","province/il",}),
   ({"TU","TU10","Balikesir","province/il",}),
   ({"TU","TU11","Bilecik","province/il",}),
   ({"TU","TU12","Bingol","province/il",}),
   ({"TU","TU13","Bitlis","province/il",}),
   ({"TU","TU14","Bolu","province/il",}),
   ({"TU","TU15","Burdur","province/il",}),
   ({"TU","TU16","Bursa","province/il",}),
   ({"TU","TU17","Canakkale","province/il",}),
// ({"TU","TU18","Cankiri","province/il",}),	// obsolete
   ({"TU","TU19","Corum","province/il",}),
   ({"TU","TU20","Denizli","province/il",}),
   ({"TU","TU21","Diyarbakir","province/il",}),
   ({"TU","TU22","Edirne","province/il",}),
   ({"TU","TU23","Elazig","province/il",}),
   ({"TU","TU24","Erzincan","province/il",}),
   ({"TU","TU25","Erzurum","province/il",}),
   ({"TU","TU26","Eskisehir","province/il",}),
// ({"TU","TU27","Gaziantep","province/il",}),	// obsolete
   ({"TU","TU28","Giresun","province/il",}),
   ({"TU","TU29","TU29","province/il",}),
   ({"TU","TU30","TU30","province/il",}),
   ({"TU","TU31","Hatay","province/il",}),
   ({"TU","TU32","Icel","province/il",}),
   ({"TU","TU33","Isparta","province/il",}),
   ({"TU","TU34","Istanbul","province/il",}),
   ({"TU","TU35","Izmir","province/il",}),
// ({"TU","TU36","Kars","province/il",}),	// obsolete
   ({"TU","TU37","Kastamonu","province/il",}),
   ({"TU","TU38","Kayseri","province/il",}),
   ({"TU","TU39","Kirklareli","province/il",}),
   ({"TU","TU40","Kirsehir","province/il",}),
   ({"TU","TU41","Kocaeli","province/il",}),
   ({"TU","TU42","TU42","province/il",}),
   ({"TU","TU43","Kutahya","province/il",}),
   ({"TU","TU44","Malatya","province/il",}),
   ({"TU","TU45","Manisa","province/il",}),
   ({"TU","TU46","Kahramanmaras","province/il",}),
   ({"TU","TU47","TU47","province/il",}),
   ({"TU","TU48","Mugla","province/il",}),
   ({"TU","TU49","Mus","province/il",}),
   ({"TU","TU50","Nevsehir","province/il",}),
   ({"TU","TU51","TU51","province/il",}),
   ({"TU","TU52","Ordu","province/il",}),
   ({"TU","TU53","Rize","province/il",}),
   ({"TU","TU54","Sakarya","province/il",}),
   ({"TU","TU55","Samsun","province/il",}),
   ({"TU","TU56","TU56","province/il",}),
   ({"TU","TU57","Sinop","province/il",}),
   ({"TU","TU58","Sivas","province/il",}),
   ({"TU","TU59","Tekirdag","province/il",}),
   ({"TU","TU60","Tokat","province/il",}),
   ({"TU","TU61","Trabzon","province/il",}),
   ({"TU","TU62","Tunceli","province/il",}),
   ({"TU","TU63","Sanliurfa","province/il",}),
   ({"TU","TU64","Usak","province/il",}),
   ({"TU","TU65","Van","province/il",}),
   ({"TU","TU66","Yozgat","province/il",}),
// ({"TU","TU67","Zonguldak","province/il",}),	// obsolete
   ({"TU","TU68","Ankara","province/il",}),
   ({"TU","TU69","Gumushane","province/il",}),
   ({"TU","TU70","Hakkari","province/il",}),
   ({"TU","TU71","Konya","province/il",}),
   ({"TU","TU72","Mardin","province/il",}),
   ({"TU","TU73","Nigde","province/il",}),
   ({"TU","TU74","Siirt","province/il",}),
   ({"TU","TU75","Aksaray","province/il",}),
   ({"TU","TU76","Batman","province/il",}),
   ({"TU","TU77","Bayburt","province/il",}),
   ({"TU","TU78","Karaman","province/il",}),
   ({"TU","TU79","Kirikkale","province/il",}),
   ({"TU","TU80","Sirnak","province/il",}),
   ({"TU","TU81","Adana","province/il",}),
   ({"TU","TU82","Cankiri","province/il",}),
   ({"TU","TU83","Gaziantep","province/il",}),
   ({"TU","TU84","Kars","province/il",}),
   ({"TU","TU85","Zonguldak","province/il",}),
   ({"TU","TU86","Ardahan","province/il",}),
   ({"TU","TU87","Bartin","province/il",}),
   ({"TU","TU88","Igdir","province/il",}),
   ({"TU","TU89","Karabuk","province/il",}),
   ({"TU","TU90","Kilis","province/il",}),
   ({"TU","TU91","Osmaniye","province/il",}),
   ({"TU","TU92","Yalova","province/il",}),
   ({"TW","TW01","Fu-chien","province/sheng",}),
   ({"TW","TW02","Kao-hsiung","municipality/shih",}),
   ({"TW","TW03","T'ai-pei","municipality/shih",}),
   ({"TW","TW04","T'ai-wan","province/sheng",}),
   ({"TX","TX01","Ahal","province/welayat",}),
   ({"TX","TX02","Balkan","province/welayat",}),
   ({"TX","TX03","Dashhowuz","province/welayat",}),
   ({"TX","TX04","Lebap","province/welayat",}),
   ({"TX","TX05","Mary","province/welayat",}),
   ({"TZ","TZ01","Arusha","region",}),
   ({"TZ","TZ02","Dar es Salaam","region",}),
   ({"TZ","TZ03","Dodoma","region",}),
   ({"TZ","TZ04","Iringa","region",}),
   ({"TZ","TZ05","Kigoma","region",}),
   ({"TZ","TZ06","Kilimanjaro","region",}),
   ({"TZ","TZ07","Lindi","region",}),
   ({"TZ","TZ08","Mara","region",}),
   ({"TZ","TZ09","Mbeya","region",}),
   ({"TZ","TZ10","Morogoro","region",}),
   ({"TZ","TZ11","Mtwara","region",}),
   ({"TZ","TZ12","Mwanza","region",}),
   ({"TZ","TZ13","Pemba North","region",}),
   ({"TZ","TZ14","Ruvuma","region",}),
   ({"TZ","TZ15","Shinyanga","region",}),
   ({"TZ","TZ16","Singida","region",}),
   ({"TZ","TZ17","Tabora","region",}),
   ({"TZ","TZ18","Tanga","region",}),
   ({"TZ","TZ19","Ziwa Magharibi","region",}),
   ({"TZ","TZ20","Pemba South","region",}),
   ({"TZ","TZ21","Zanzibar Central/South","region",}),
   ({"TZ","TZ22","Zanzibar North","region",}),
   ({"TZ","TZ23","Dar es Salaam","region",}),
   ({"TZ","TZ24","Rukwa","region",}),
   ({"TZ","TZ25","Zanzibar Urban/West","region",}),
   ({"UG","UG26","Apac","district",}),
   ({"UG","UG27","Arua","district",}),
   ({"UG","UG28","Bundibogyo","district",}),
   ({"UG","UG29","Bushenyi","district",}),
   ({"UG","UG30","Gulu","district",}),
   ({"UG","UG31","Hoima","district",}),
   ({"UG","UG32","Iganga","district",}),
   ({"UG","UG33","Jinja","district",}),
   ({"UG","UG34","Kabale","district",}),
   ({"UG","UG35","Kabarole","district",}),
   ({"UG","UG36","Kalangala","district",}),
   ({"UG","UG37","Kampala","district",}),
   ({"UG","UG38","Kamuli","district",}),
   ({"UG","UG39","Kapchorwa","district",}),
   ({"UG","UG40","Kasese","district",}),
   ({"UG","UG41","Kibale","district",}),
   ({"UG","UG42","Kiboga","district",}),
   ({"UG","UG43","Kisoro","district",}),
   ({"UG","UG44","Kitgum","district",}),
   ({"UG","UG45","Kotido","district",}),
   ({"UG","UG46","Kumi","district",}),
   ({"UG","UG47","Lira","district",}),
   ({"UG","UG48","Luwero","district",}),
   ({"UG","UG49","Masaka","district",}),
   ({"UG","UG50","Masindi","district",}),
   ({"UG","UG51","Mbale","district",}),
   ({"UG","UG52","Mbarara","district",}),
   ({"UG","UG53","Moroto","district",}),
   ({"UG","UG54","Moyo","district",}),
   ({"UG","UG55","Mpigi","district",}),
   ({"UG","UG56","Mubende","district",}),
   ({"UG","UG57","Mukono","district",}),
   ({"UG","UG58","Nebbi","district",}),
   ({"UG","UG59","Ntungamo","district",}),
   ({"UG","UG60","Pallisa","district",}),
   ({"UG","UG61","Rakai","district",}),
   ({"UG","UG62","Rukungiri","district",}),
   ({"UG","UG63","Soroti","district",}),
   ({"UG","UG64","Tororo","district",}),
   ({"UK","UK01","Avon","county",}),
   ({"UK","UK02","Bedford","county",}),
   ({"UK","UK03","Berkshire","county",}),
   ({"UK","UK04","Buckingham","county",}),
   ({"UK","UK05","Cambridge","county",}),
   ({"UK","UK06","Cheshire","county",}),
   ({"UK","UK07","Cleveland","county",}),
   ({"UK","UK08","Cornwall","county",}),
   ({"UK","UK09","Cumbria","county",}),
   ({"UK","UK10","Derby","county",}),
   ({"UK","UK11","Devon","county",}),
   ({"UK","UK12","Dorset","county",}),
   ({"UK","UK13","Durham","county",}),
   ({"UK","UK14","East Sussex","county",}),
   ({"UK","UK15","Essex","county",}),
   ({"UK","UK16","Gloucester","county",}),
   ({"UK","UK17","Greater London","metropolitan county",}),
   ({"UK","UK18","Greater Manchester","metropolitan county",}),
   ({"UK","UK19","Hampshire","county",}),
   ({"UK","UK20","Hereford and Worcester","county",}),
   ({"UK","UK21","Hertford","county",}),
   ({"UK","UK22","Humberside","county",}),
   ({"UK","UK23","Isle of Wight","county",}),
   ({"UK","UK24","Kent","county",}),
   ({"UK","UK25","Lancashire","county",}),
   ({"UK","UK26","Leicester","county",}),
   ({"UK","UK27","Lincoln","county",}),
   ({"UK","UK28","Merseyside","metropolitan county",}),
   ({"UK","UK29","Norfolk","county",}),
   ({"UK","UK30","North Yorkshire","county",}),
   ({"UK","UK31","Northampton","county",}),
   ({"UK","UK32","Northumberland","county",}),
   ({"UK","UK33","Nottingham","county",}),
   ({"UK","UK34","Oxford","county",}),
   ({"UK","UK35","Shropshire","county",}),
   ({"UK","UK36","Somerset","county",}),
   ({"UK","UK37","South Yorkshire","metropolitan county",}),
   ({"UK","UK38","Stafford","county",}),
   ({"UK","UK39","Suffolk","county",}),
   ({"UK","UK40","Surrey","county",}),
   ({"UK","UK41","Tyne and Wear","metropolitan county",}),
   ({"UK","UK42","Warwick","county",}),
   ({"UK","UK43","West Midlands","metropolitan county",}),
   ({"UK","UK44","West Sussex","county",}),
   ({"UK","UK45","West Yorkshire","metropolitan county",}),
   ({"UK","UK46","Wiltshire","county",}),
   ({"UK","UK52","Antrim","district",}),
   ({"UK","UK53","Ards","district",}),
   ({"UK","UK54","Armagh","district",}),
   ({"UK","UK55","Ballymena","district",}),
   ({"UK","UK56","Ballymoney","district",}),
   ({"UK","UK57","Banbridge","district",}),
   ({"UK","UK58","Belfast","district",}),
   ({"UK","UK59","Carrickfergus","district",}),
   ({"UK","UK60","Castlereagh","district",}),
   ({"UK","UK61","Coleraine","district",}),
   ({"UK","UK62","Cookstown","district",}),
   ({"UK","UK63","Craigavon","district",}),
   ({"UK","UK64","Down","district",}),
   ({"UK","UK65","Dungannon","district",}),
   ({"UK","UK66","Fermanagh","district",}),
   ({"UK","UK67","Larne","district",}),
   ({"UK","UK68","Limavady","district",}),
   ({"UK","UK69","Lisburn","district",}),
   ({"UK","UK70","Londonderry","district",}),
   ({"UK","UK71","Magherafelt","district",}),
   ({"UK","UK72","Moyle","district",}),
   ({"UK","UK73","Newry and Mourne","district",}),
   ({"UK","UK74","Newtownabbey","district",}),
   ({"UK","UK75","North Down","district",}),
   ({"UK","UK76","Omagh","district",}),
   ({"UK","UK77","Strabane","district",}),
   ({"UK","UK78","Borders","region",}),
   ({"UK","UK79","Central","region",}),
   ({"UK","UK80","Dumfries and Galloway","region",}),
   ({"UK","UK81","Fife","region",}),
   ({"UK","UK82","Grampian","region",}),
   ({"UK","UK83","Highland","region",}),
   ({"UK","UK84","Lothian","region",}),
   ({"UK","UK85","Orkney","island aarea",}),
   ({"UK","UK86","Shetland","island aarea",}),
   ({"UK","UK87","Strathclyde","region",}),
   ({"UK","UK88","Tayside","region",}),
   ({"UK","UK89","Western Isles","island aarea",}),
   ({"UK","UK90","Clwyd","county",}),
   ({"UK","UK91","Dyfed","county",}),
   ({"UK","UK92","Gwent","county",}),
   ({"UK","UK93","Gwynedd","county",}),
   ({"UK","UK94","Mid Glamorgan","county",}),
   ({"UK","UK95","Powys","county",}),
   ({"UK","UK96","South Glamorgan","county",}),
   ({"UK","UK97","West Glamorgan","county",}),
   ({"UP","UP01","Cherkas'ka Oblast'","province/oblast'",}),
   ({"UP","UP02","Chernihivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP03","Chernivets'ka Oblast'","province/oblast'",}),
   ({"UP","UP04","Dnipropetrovs'ka Oblast'","province/oblast'",}),
   ({"UP","UP05","Donets'ka Oblast'","province/oblast'",}),
   ({"UP","UP06","Ivano-Frankivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP07","Kharkivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP08","Khersons'ka Oblast'","province/oblast'",}),
   ({"UP","UP09","Khmel'nyts'ka Oblast'","province/oblast'",}),
   ({"UP","UP10","Kirovohrads'ka Oblast'","province/oblast'",}),
   ({"UP","UP11","Krym, Avtonomna Respublika","autonomous republic/avtonomna respublika",}),
   ({"UP","UP12","Kyyiv, Misto","city/misto",}),
   ({"UP","UP13","Kyyivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP14","Luhans'ka Oblast'","province/oblast'",}),
   ({"UP","UP15","L'vivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP16","Mykolayivs'ka Oblast'","province/oblast'",}),
   ({"UP","UP17","Odes'ka Oblast","province/oblast'",}),
   ({"UP","UP18","Poltavs'ka Oblast'","province/oblast'",}),
   ({"UP","UP19","Rivnens'ka Oblast'","province/oblast'",}),
   ({"UP","UP20","Sevastopol', Misto","city/misto",}),
   ({"UP","UP21","Sums'ka Oblast'","province/oblast'",}),
   ({"UP","UP22","Ternopil's'ka Oblast'","province/oblast'",}),
   ({"UP","UP23","Vinnyts'ka Oblast'","province/oblast'",}),
   ({"UP","UP24","Volyns'ka Oblast'","province/oblast'",}),
   ({"UP","UP25","Zakarpats'ka Oblast'","province/oblast'",}),
   ({"UP","UP26","Zaporiz'ka Oblast'","province/oblast'",}),
   ({"UP","UP27","Zhytomyrs'ka Oblast'","province/oblast'",}),
   ({"UV","UV15","Bam","province/province",}),
   ({"UV","UV16","Bazega","province/province",}),
   ({"UV","UV17","Bougouriba","province/province",}),
   ({"UV","UV18","Boulgou","province/province",}),
   ({"UV","UV19","Boulkiemde","province/province",}),
   ({"UV","UV20","Ganzourgou","province/province",}),
   ({"UV","UV21","Gnagna","province/province",}),
   ({"UV","UV22","Gourma","province/province",}),
   ({"UV","UV23","Houe","province/province",}),
   ({"UV","UV24","Kadiogo","province/province",}),
   ({"UV","UV25","Kenedougou","province/province",}),
   ({"UV","UV26","Komoe","province/province",}),
   ({"UV","UV27","Kossi","province/province",}),
   ({"UV","UV28","Kouritenga","province/province",}),
   ({"UV","UV29","Mouhoun","province/province",}),
   ({"UV","UV30","Namentenga","province/province",}),
   ({"UV","UV31","Naouri","province/province",}),
   ({"UV","UV32","Oubritenga","province/province",}),
   ({"UV","UV33","Oudalan","province/province",}),
   ({"UV","UV34","Passore","province/province",}),
   ({"UV","UV35","Poni","province/province",}),
   ({"UV","UV36","Sanguie","province/province",}),
   ({"UV","UV37","Sanmatenga","province/province",}),
   ({"UV","UV38","Seno","province/province",}),
   ({"UV","UV39","Sissili","province/province",}),
   ({"UV","UV40","Soum","province/province",}),
   ({"UV","UV41","Sourou","province/province",}),
   ({"UV","UV42","Tapoa","province/province",}),
   ({"UV","UV43","Yatenga","province/province",}),
   ({"UV","UV44","Zoundweogo","province/province",}),
   ({"UY","UY01","Artigas","department/departamento",}),
   ({"UY","UY02","Canelones","department/departamento",}),
   ({"UY","UY03","Cerro Largo","department/departamento",}),
   ({"UY","UY04","Colonia","department/departamento",}),
   ({"UY","UY05","Durazno","department/departamento",}),
   ({"UY","UY06","Flores","department/departamento",}),
   ({"UY","UY07","Florida","department/departamento",}),
   ({"UY","UY08","Lavalleja","department/departamento",}),
   ({"UY","UY09","Maldonado","department/departamento",}),
   ({"UY","UY10","Montevideo","department/departamento",}),
   ({"UY","UY11","Paysandu","department/departamento",}),
   ({"UY","UY12","Rio Negro","department/departamento",}),
   ({"UY","UY13","Rivera","department/departamento",}),
   ({"UY","UY14","Rocha","department/departamento",}),
   ({"UY","UY15","Salto","department/departamento",}),
   ({"UY","UY16","San Jose","department/departamento",}),
   ({"UY","UY17","Soriano","department/departamento",}),
   ({"UY","UY18","Tacuarembo","department/departamento",}),
   ({"UY","UY19","Treinta y Tres","department/departamento",}),
   ({"UZ","UZ01","Andijon","province/wiloyati",}),
   ({"UZ","UZ02","Bukhoro","province/wiloyati",}),
   ({"UZ","UZ03","Farghona","province/wiloyati",}),
   ({"UZ","UZ04","Jizzakh","province/wiloyati",}),
   ({"UZ","UZ05","Khorazm","province/wiloyati",}),
   ({"UZ","UZ06","Namangan","province/wiloyati",}),
   ({"UZ","UZ07","Nawoiy","province/wiloyati",}),
   ({"UZ","UZ08","Qashqadaryo","province/wiloyati",}),
   ({"UZ","UZ09","Qoraqalpoghiston","city/shahri",}),
   ({"UZ","UZ10","Samarqand","province/wiloyati",}),
   ({"UZ","UZ11","Sirdaryo","province/wiloyati",}),
   ({"UZ","UZ12","Surkhondaryo","province/wiloyati",}),
   ({"UZ","UZ13","Toshkent","republic/respublikasi",}),
   ({"UZ","UZ14","Toshkent","province/wiloyati",}),
   ({"VC","VC01","Charlotte","parish",}),
   ({"VC","VC02","Saint Andrew","parish",}),
   ({"VC","VC03","Saint David","parish",}),
   ({"VC","VC04","Saint George","parish",}),
   ({"VC","VC05","Saint Patrick","parish",}),
   ({"VC","VC06","Grenadines","parish",}),
   ({"VE","VE01","Amazonas","state/estado",}),
   ({"VE","VE02","Anzoategui","state/estado",}),
   ({"VE","VE03","Apure","state/estado",}),
   ({"VE","VE04","Aragua","state/estado",}),
   ({"VE","VE05","Barinas","state/estado",}),
   ({"VE","VE06","Bolivar","state/estado",}),
   ({"VE","VE07","Carabobo","state/estado",}),
   ({"VE","VE08","Cojedes","state/estado",}),
   ({"VE","VE09","Delta Amacuro","state/estado",}),
// ({"VE","VE10","Distrito Federal","state/estado",}),	// obsolete
   ({"VE","VE11","Falcon","state/estado",}),
   ({"VE","VE12","Guarico","state/estado",}),
   ({"VE","VE13","Lara","state/estado",}),
   ({"VE","VE14","Merida","state/estado",}),
   ({"VE","VE15","Miranda","state/estado",}),
   ({"VE","VE16","Monagas","state/estado",}),
   ({"VE","VE17","Nueva Esparta","state/estado",}),
   ({"VE","VE18","Portuguesa","state/estado",}),
   ({"VE","VE19","Sucre","state/estado",}),
   ({"VE","VE20","Tachira","state/estado",}),
   ({"VE","VE21","Trujillo","state/estado",}),
   ({"VE","VE22","Yaracuy","state/estado",}),
   ({"VE","VE23","Zulia","state/estado",}),
   ({"VE","VE24","Dependencias Federales","federal dependencise/dependencias federales",}),
   ({"VE","VE25","Distrito Federal","federal district/distrito federal",}),
   ({"VM","VM01","An Giang","province/tinh",}),
// ({"VM","VM02","Bac Thai","province/tinh",}),	// obsolete
   ({"VM","VM03","Ben Tre","province/tinh",}),
// ({"VM","VM04","Binh Tri Thien","province/tinh",}),	// obsolete
   ({"VM","VM05","Cao Bang","province/tinh",}),
// ({"VM","VM06","Cuu Long","province/tinh",}),	// obsolete
   ({"VM","VM07","Dak Lak","province/tinh",}),
   ({"VM","VM09","Dong Thap","province/tinh",}),
// ({"VM","VM10","Gai Lai-Kon Tum","province/tinh",}),	// obsolete
// ({"VM","VM11","Ha Bac","province/tinh",}),	// obsolete
// ({"VM","VM12","Hai Hung","province/tinh",}),	// obsolete
   ({"VM","VM13","Hai Phong","municipality/thanh pho",}),
// ({"VM","VM14","Ha Nam Ninh","province/tinh",}),	// obsolete
// ({"VM","VM15","Ha Noi","province/tinh",}),	// obsolete
// ({"VM","VM16","Ha Son Binh","province/tinh",}),	// obsolete
// ({"VM","VM17","Ha Tuyne","province/tinh",}),	// obsolete
// ({"VM","VM19","Hoang Lien Son","province/tinh",}),	// obsolete
   ({"VM","VM20","Ho Chi Minh","municipality/thanh pho",}),
   ({"VM","VM21","Kien Giang","province/tinh",}),
   ({"VM","VM22","Lai Chau","province/tinh",}),
   ({"VM","VM23","Lam Dong","province/tinh",}),
   ({"VM","VM24","Long An","province/tinh",}),
// ({"VM","VM25","Minh Hai","province/tinh",}),	// obsolete
// ({"VM","VM26","Nghe Tinh","province/tinh",}),	// obsolete
// ({"VM","VM27","Nghia Binh","province/tinh",}),	// obsolete
// ({"VM","VM28","Phu Khanh","province/tinh",}),	// obsolete
// ({"VM","VM29","Quang Nam-Da Nang","province/tinh",}),	// obsolete
   ({"VM","VM30","Quang Ninh","province/tinh",}),
// ({"VM","VM31","Song Be","province/tinh",}),	// obsolete
   ({"VM","VM32","Son La","province/tinh",}),
   ({"VM","VM33","Tay Ninh","province/tinh",}),
   ({"VM","VM34","Thanh Hoa","province/tinh",}),
   ({"VM","VM35","Thai Binh","province/tinh",}),
// ({"VM","VM36","Thuan Hai","province/tinh",}),	// obsolete
   ({"VM","VM37","Tien Giang","province/tinh",}),
// ({"VM","VM38","Vinh Phu","province/tinh",}),	// obsolete
   ({"VM","VM39","Lang Son","province/tinh",}),
// ({"VM","VM40","Vung Tau-Con Dao","province/tinh",}),	// obsolete
   ({"VM","VM41","VM41","province/tinh",}),
   ({"VM","VM43","Dong Nai","province/tinh",}),
   ({"VM","VM44","Ha Noi","municipality/thanh pho",}),
   ({"VM","VM45","Ba Ria-Vung Tau","province/tinh",}),
   ({"VM","VM46","Binh Dinh","province/tinh",}),
   ({"VM","VM47","Binh Thuan","province/tinh",}),
   ({"VM","VM48","Can Tho","province/tinh",}),
   ({"VM","VM49","Gia Lai","province/tinh",}),
   ({"VM","VM50","Ha Giang","province/tinh",}),
   ({"VM","VM51","Ha Tay","province/tinh",}),
   ({"VM","VM52","Ha Tinh","province/tinh",}),
   ({"VM","VM53","Hoa Binh","province/tinh",}),
   ({"VM","VM54","Khanh Hoa","province/tinh",}),
   ({"VM","VM55","Kon Tum","province/tinh",}),
   ({"VM","VM56","Lao Cai","province/tinh",}),
// ({"VM","VM57","Nam Ha","province/tinh",}),	// obsolete
   ({"VM","VM58","Nghe An","province/tinh",}),
   ({"VM","VM59","Ninh Binh","province/tinh",}),
   ({"VM","VM60","Ninh Thuan","province/tinh",}),
   ({"VM","VM61","Phu Yen","province/tinh",}),
   ({"VM","VM62","Quang Binh","province/tinh",}),
   ({"VM","VM63","Quang Ngai","province/tinh",}),
   ({"VM","VM64","Quang Tri","province/tinh",}),
   ({"VM","VM65","Soc Trang","province/tinh",}),
   ({"VM","VM66","Thura Thien-Hue","province/tinh",}),
   ({"VM","VM67","Tra Vinh","province/tinh",}),
   ({"VM","VM68","Tuyen Quang","province/tinh",}),
   ({"VM","VM69","Vinh Long","province/tinh",}),
   ({"VM","VM70","Yen Bai","province/tinh",}),
   ({"VM","VM71","Bac Giang","province/tinh",}),
   ({"VM","VM72","Bac Kan","province/tinh",}),
   ({"VM","VM73","Bac Lieu","province/tinh",}),
   ({"VM","VM74","Bac Ninh","province/tinh",}),
   ({"VM","VM75","Bin Duong","province/tinh",}),
   ({"VM","VM76","Bin Phuoc","province/tinh",}),
   ({"VM","VM77","Ca Mau","province/tinh",}),
   ({"VM","VM78","Da Nang","province/tinh",}),
   ({"VM","VM79","Hai Duong","province/tinh",}),
   ({"VM","VM80","Ha Nam","province/tinh",}),
   ({"VM","VM81","Hung Yen","province/tinh",}),
   ({"VM","VM82","Nam Dinh","province/tinh",}),
   ({"VM","VM83","Phu Tho","province/tinh",}),
   ({"VM","VM84","Quang Nam","province/tinh",}),
   ({"VM","VM85","Thai Nguyen","province/tinh",}),
   ({"VM","VM86","Vinh Phuc","province/tinh",}),
// ({"WA","WA01","Bethanien","district",}),	// obsolete
// ({"WA","WA18","Tsumeb","district",}),	// obsolete
   ({"WA","WA21","Khomas","district",}),
   ({"WA","WA28","Caprivi","district",}),
   ({"WA","WA29","Erongo","district",}),
   ({"WA","WA30","Hardap","district",}),
   ({"WA","WA31","Karas","district",}),
   ({"WA","WA32","Kunene","district",}),
   ({"WA","WA33","Ohangwena","district",}),
   ({"WA","WA34","Okavango","district",}),
   ({"WA","WA35","Omaheke","district",}),
   ({"WA","WA36","Omusati","district",}),
   ({"WA","WA37","Oshana","district",}),
   ({"WA","WA38","Oshikoto","district",}),
   ({"WA","WA39","Otjozondjupa","district",}),
// ({"WA","WA40","Khomas","district",}),	// obsolete
   ({"WS","WS01","A'ana","district",}),
   ({"WS","WS02","Aiga-i-le-Tai","district",}),
   ({"WS","WS03","Atua","district",}),
   ({"WS","WS04","Fa'asaleleaga","district",}),
   ({"WS","WS05","Gaga'emauga","district",}),
   ({"WS","WS06","Va'a-o-Fonoti","district",}),
   ({"WS","WS07","Gagaifomauga","district",}),
   ({"WS","WS08","Palauli","district",}),
   ({"WS","WS09","Satupa'itea","district",}),
   ({"WS","WS10","Tuamasaga","district",}),
   ({"WS","WS11","Vaisigano","district",}),
   ({"WZ","WZ01","Hhohho","district",}),
   ({"WZ","WZ02","Lubombo","district",}),
   ({"WZ","WZ03","Manzini","district",}),
   ({"WZ","WZ04","Shiselweni","district",}),
   ({"YI","YI01","Crna Gora ","republic/republika","Montenegro",}),
   ({"YI","YI02","Srbija ","republic/republika","Serbia",}),
   ({"YM","YM01","Abyan","governorate/muhafazah",}),
   ({"YM","YM02","'Adan","governorate/muhafazah",}),
   ({"YM","YM03","Al Mahrah","governorate/muhafazah",}),
   ({"YM","YM04","Hadramawt","governorate/muhafazah",}),
   ({"YM","YM05","Shabwah","governorate/muhafazah",}),
   ({"YM","YM06","Lahij","governorate/muhafazah",}),
   ({"YM","YM07","Al Bayda'","governorate/muhafazah",}),
   ({"YM","YM08","Al Hudaydah","governorate/muhafazah",}),
   ({"YM","YM09","Al Jawf","governorate/muhafazah",}),
   ({"YM","YM10","Al Mahwit","governorate/muhafazah",}),
   ({"YM","YM11","Dhamar","governorate/muhafazah",}),
   ({"YM","YM12","Hajjah","governorate/muhafazah",}),
   ({"YM","YM13","Ibb","governorate/muhafazah",}),
   ({"YM","YM14","Ma'rib","governorate/muhafazah",}),
   ({"YM","YM15","Sa'dah","governorate/muhafazah",}),
   ({"YM","YM16","San'a'","governorate/muhafazah",}),
   ({"YM","YM17","Ta'izz","governorate/muhafazah",}),
   ({"ZA","ZA01","North-Western","province",}),
   ({"ZA","ZA02","Copperbelt","province",}),
   ({"ZA","ZA03","Western","province",}),
   ({"ZA","ZA04","Southern","province",}),
   ({"ZA","ZA05","Central","province",}),
   ({"ZA","ZA06","Eastern","province",}),
   ({"ZA","ZA07","Northern","province",}),
   ({"ZA","ZA08","Luapula","province",}),
   ({"ZA","ZA09","Lusaka","province",}),
   ({"ZI","ZI01","Manicaland","province",}),
   ({"ZI","ZI02","Midlands","province",}),
   ({"ZI","ZI03","Mashonaland Central","province",}),
   ({"ZI","ZI04","Mashonaland East","province",}),
   ({"ZI","ZI05","Mashonaland West","province",}),
   ({"ZI","ZI06","Matabeleland North","province",}),
   ({"ZI","ZI07","Matabeleland South","province",}),
   ({"ZI","ZI08","Masvingo","province",}),
});

