# Dependencies and Imports
from enum import Enum


"""
 * Enum for subscriptions that specifies whether its notification messages are
 * to be delivered by reliable means (e.g. TCP) or fast means (e.g. UDP).
 * @class OcaNotificationDeliveryMode
"""
class OcaNotificationDeliveryMode(Enum):
    Reliable = 1
    Fast = 2

"""
 * Singleton object corresponding to the entry with value ``1``.
 * @type {OcaNotificationDeliveryMode}
 * @member Reliable
 * @memberof OcaNotificationDeliveryMode
 * @static

 * Singleton object corresponding to the entry with value ``2``.
 * @type {OcaNotificationDeliveryMode}
 * @member Fast
 * @memberof OcaNotificationDeliveryMode
 * @static
"""
