from ...ocp1.ocalevelmeterlaw import OcaLevelMeterLaw
from ..make_control_class import make_control_class
from .ocalevelsensor import OcaLevelSensor

# Child of **OcaLevelSensor** that returns an audio meter reading in dB relative
# to a known reference level, and whose value has been calculated by the
# selected averaging algorithm.
# @extends OcaLevelSensor
# @class OcaAudioLevelSensor
OcaAudioLevelSensor = make_control_class(
    'OcaAudioLevelSensor',
    5,
    '\u0001\u0001\u0002\u0002\u0001',
    2,
    OcaLevelSensor,
    [
        ['GetLaw', 5, 1, [], [OcaLevelMeterLaw]],
        ['SetLaw', 5, 2, [OcaLevelMeterLaw], []],
    ],
    [
      ['Law', [OcaLevelMeterLaw], 5, 1, False, False, None],
    ],
    []
)

# Gets the value of the Law property. The return value indicates whether the
# property was successfully retrieved.
#
# @method OcaAudioLevelSensor#GetLaw
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Sets the value of the Law property. The return value indicates whether the
# property was successfully set. Only implemented for objects whose Law property
# is read/write.
#
# @method OcaAudioLevelSensor#SetLaw
# @param {int} law
#
# @returns {Promise<None>}
# This event is emitted when the property ``Law`` changes in the remote object.
# The property ``Law`` is described in the AES70 standard as follows.
# Enum that defines metering algorithm, including averaging characteristics and,
# in some cases, reference level. Readonly in some objects.
#
# @member {PropertyEvent<int>} OcaAudioLevelSensor#OnLawChanged
