from ...ocp1.ocalibaccess import OcaLibAccess
from ...ocp1.ocalibvol import OcaLibVol
from ...ocp1.ocalibvolchangedeventdata import OcaLibVolChangedEventData
from ...ocp1.ocalibvoltype import OcaLibVolType
from ...ocp1.ocamap import OcaMap
from ...ocp1.ocauint16 import OcaUint16
from ...ocp1.ocauint32 import OcaUint32
from ..make_control_class import make_control_class
from .ocaagent import OcaAgent

# A **library** is an agent that holds a collection of datasets. We refer to
# each dataset as a **Volume**. There are two kinds of volumes: **ParamSet**
# (parameter set). A ParamSet is a collection of operating parameter settings
# that can be applied to a block. Each ParamSet is associated with a specific
# block type, but not with a specific instance of that type. A ParamSet may be
# applied to any block instance of the associated type. A block's type is the
# object number of its factory or, for factory-defined blocks, a unique
# identifier set at time of manufacture. **Patch**. A Patch is a collection of
# ParamSet assignments. A ParamSet assigment is the description of a binding of
# a ParamSet to a block instance. To "apply" a Patch is to apply all of its
# assignments. To apply an assignment is to set all of its ParamSet's parameter
# values into its block. A given library instance can only hold one class of
# volume. A device that supports libraries can have any number of Patch and
# ParamSet libraries. If a device implements a Patch library, it must also
# implement at least one ParamSet library. However, the reverse is not true: a
# device may implement one or more ParamSet libraries without a Patch library.
# @extends OcaAgent
# @class OcaLibrary
OcaLibrary = make_control_class(
    'OcaLibrary',
    3,
    '\u0001\u0002\u0005',
    2,
    OcaAgent,
    [
        ['AddVolume', 3, 1, [OcaLibVol], [OcaUint32]],
        ['ReplaceVolume', 3, 2, [OcaUint32, OcaLibVol], []],
        ['DeleteVolume', 3, 3, [OcaUint32], []],
        ['GetVolume', 3, 4, [OcaUint32], [OcaLibVol]],
        ['GetVolumeCount', 3, 5, [], [OcaUint16]],
        ['GetVolumes', 3, 6, [], [OcaMap(OcaUint32, OcaLibVol)]],
        ['GetAccess', 3, 7, [], [OcaLibAccess]],
        ['SetAccess', 3, 8, [OcaLibAccess], []],
    ],
    [
      ['VolumeType', [OcaLibVolType], 3, 1, False, False, None],
      ['Access', [OcaLibAccess], 3, 2, False, False, None],
      ['Volumes', [OcaMap(OcaUint32, OcaLibVol)], 3, 3, False, False, None],
    ],
    [
      ['OcaLibVolChanged', 3, 1, [OcaLibVolChangedEventData] ],
    ]
)

# Adds a volume to the library and returns its volume ID. The return value
# indicates whether the volume was successfully added. Changed in version 2
# because the definition of OcaLibVolMetaData, which is part of OcaLibVol, has
# changed.
#
# @method OcaLibrary#AddVolume
# @param {IOcaLibVol} Volume
#
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Replaces a volume in the library at the given volume ID. The return value
# indicates whether the volume was successfully replaced. Changed in version 2
# because the definition of OcaLibVolMetaData, which is part of OcaLibVol, has
# changed.
#
# @method OcaLibrary#ReplaceVolume
# @param {int} ID
# @param {IOcaLibVol} Volume
#
# @returns {Promise<None>}
# Deletes a volume from the library. The return value indicates whether the
# group was successfully deleted.
#
# @method OcaLibrary#DeleteVolume
# @param {int} ID
#
# @returns {Promise<None>}
# Retrieves a library volume. The return value indicates whether the volume was
# successfully retrieved. Changed in version 2 because the definition of
# OcaLibVolMetaData, which is part of OcaLibVol, has changed.
#
# @method OcaLibrary#GetVolume
# @param {int} ID
#
# @returns {Promise<OcaLibVol>}
#   A promise which resolves to a single value of type :class:`OcaLibVol`.
# Gets the count of volumes in this library. The return value indicates whether
# the count was successfully retrieved.
#
# @method OcaLibrary#GetVolumeCount
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Gets the list of volumes held in this library. The return value indicates
# whether the list was successfully retrieved. Changed in version 2 because the
# definition of OcaLibVolMetaData, which is part of OcaLibVol, has changed.
#
# @method OcaLibrary#GetVolumes
# @returns {Promise<Dict[int, OcaLibVol]>}
#   A promise which resolves to a single value of type ``Dict[int, OcaLibVol]``.
# Gets allowed access mode for this library. The return value indicates whether
# the property was successfully retrieved.
#
# @method OcaLibrary#GetAccess
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Sets allowed access mode for this library. The return value indicates whether
# the property was successfully set. Not implemented for static,
# manufacturer-supplied libraries.
#
# @method OcaLibrary#SetAccess
# @param {int} Access
#
# @returns {Promise<None>}
# Event that is raised whenever private property **Volumes** changes. Added in
# OcaLibrary Version 2.
# @member OcaLibrary#OnOcaLibVolChanged {Event}
# This event is emitted when the property ``VolumeType`` changes in the remote object.
# The property ``VolumeType`` is described in the AES70 standard as follows.
# Type of library volumes:
#
# @member {PropertyEvent<OcaLibVolType>} OcaLibrary#OnVolumeTypeChanged
# This event is emitted when the property ``Access`` changes in the remote object.
# The property ``Access`` is described in the AES70 standard as follows.
# Readonly, read-expand, or full.
#
# @member {PropertyEvent<int>} OcaLibrary#OnAccessChanged
# This event is emitted when the property ``Volumes`` changes in the remote object.
# The property ``Volumes`` is described in the AES70 standard as follows.
# Map of volumes held in the Library. Changed in version 2 because the
# definition of OcaLibVolMetaData, which is part of OcaLibVol, has changed, and
# because it is now a private property whose changes are signaled by the
# **OcaLibVolChanged** event.
#
# @member {PropertyEvent<Dict[int, OcaLibVol]>} OcaLibrary#OnVolumesChanged
