from ...ocp1.ocablob import OcaBlob
from ...ocp1.ocaboolean import OcaBoolean
from ...ocp1.ocastring import OcaString
from ..make_control_class import make_control_class
from .ocamanager import OcaManager

# Manager that collects and controls security settings (including security
# keys).
#
#  - Must be instantiated in every device that supports secure control and
#    monitoring; otherwise, is optional.
#
#  - May be instantiated at most once in any device.
#
#  - If instantiated, object number must be 2.
#
#
# @extends OcaManager
# @class OcaSecurityManager
OcaSecurityManager = make_control_class(
    'OcaSecurityManager',
    3,
    '\u0001\u0003\u0002',
    2,
    OcaManager,
    [
        ['EnableControlSecurity', 3, 1, [], []],
        ['DisableControlSecurity', 3, 2, [], []],
        ['ChangePreSharedKey', 3, 3, [OcaString, OcaBlob], []],
        ['AddPreSharedKey', 3, 4, [OcaString, OcaBlob], []],
        ['DeletePreSharedKey', 3, 5, [OcaString], []],
    ],
    [
      ['secureControlData', [OcaBoolean], 3, 1, False, False, None],
    ],
    []
)

# Enables security of control data (OCA messages). After calling this method all
# OCA messages are sent and received using a secure connection. The return value
# indicates whether the operation succeeded. If the operation fails security is
# not enabled.
#
# @method OcaSecurityManager#EnableControlSecurity
# @returns {Promise<None>}
# Disables security of control data (OCA messages). After calling this method
# all OCA messages can be sent and received both on insecure and secure
# connections. The return value indicates whether the operation succeeded. If
# the operation fails security is not disabled.
#
# @method OcaSecurityManager#DisableControlSecurity
# @returns {Promise<None>}
# Changes the pre-shared key identified by the passed identity. Note that
# changing a PSK over the network will only work if the controller has a secure
# connection to the device and control security has been turned on. If this is
# not the case the method will return DeviceError.
#
# @method OcaSecurityManager#ChangePreSharedKey
# @param {str} identity
# @param {bytes} newKey
#
# @returns {Promise<None>}
# Adds a pre-shared key (identified by the passed identity) to the device. By
# having multiple PSKs the device is able to participate in multiple secure
# systems. Note that adding a PSK over the network will only work if the
# controller has a secure connection to the device and control security has been
# turned on. If this is not the case the method will return DeviceError.
#
# @method OcaSecurityManager#AddPreSharedKey
# @param {str} identity
# @param {bytes} key
#
# @returns {Promise<None>}
# Deletes a pre-shared key (identified by the passed identity) on the device.
# After deleting the pre-shared key the device will no longer be able to
# participate in the secure system that uses the PSK. Note that deleting a PSK
# over the network will only work if the controller has a secure connection to
# the device and control security has been turned on. If this is not the case
# the method will return DeviceError.
#
# @method OcaSecurityManager#DeletePreSharedKey
# @param {str} identity
#
# @returns {Promise<None>}
# This event is emitted when the property ``secureControlData`` changes in the remote object.
# The property ``secureControlData`` is described in the AES70 standard as follows.
# Indicates whether the OCA control data in the system is secured.
#
# @member {PropertyEvent<bool>} OcaSecurityManager#OnsecureControlDataChanged
