from ...ocp1.ocaboolean import OcaBoolean
from ...ocp1.ocafloat32 import OcaFloat32
from ...ocp1.ocaparametermask import OcaParameterMask
from ...ocp1.ocasweeptype import OcaSweepType
from ...ocp1.ocawaveformtype import OcaWaveformType
from ..make_control_class import make_control_class
from .ocaactuator import OcaActuator

# Multiwaveform signal generator with optional sweep capability.
# @extends OcaActuator
# @class OcaSignalGenerator
OcaSignalGenerator = make_control_class(
    'OcaSignalGenerator',
    4,
    '\u0001\u0001\u0001\u0011',
    2,
    OcaActuator,
    [
        ['GetFrequency1', 4, 1, [], [OcaFloat32, OcaFloat32, OcaFloat32]],
        ['SetFrequency1', 4, 2, [OcaFloat32], []],
        ['GetFrequency2', 4, 3, [], [OcaFloat32, OcaFloat32, OcaFloat32]],
        ['SetFrequency2', 4, 4, [OcaFloat32], []],
        ['GetLevel', 4, 5, [], [OcaFloat32, OcaFloat32, OcaFloat32]],
        ['SetLevel', 4, 6, [OcaFloat32], []],
        ['GetWaveform', 4, 7, [], [OcaWaveformType]],
        ['SetWaveform', 4, 8, [OcaWaveformType], []],
        ['GetSweepType', 4, 9, [], [OcaSweepType]],
        ['SetSweepType', 4, 10, [OcaSweepType], []],
        ['GetSweepTime', 4, 11, [], [OcaFloat32, OcaFloat32, OcaFloat32]],
        ['SetSweepTime', 4, 12, [OcaFloat32], []],
        ['GetSweepRepeat', 4, 13, [], [OcaBoolean]],
        ['SetSweepRepeat', 4, 14, [OcaBoolean], []],
        ['GetGenerating', 4, 15, [], [OcaBoolean]],
        ['Start', 4, 16, [], []],
        ['Stop', 4, 17, [], []],
        ['SetMultiple', 4, 18, [OcaParameterMask, OcaFloat32, OcaFloat32, OcaFloat32, OcaWaveformType, OcaSweepType, OcaFloat32, OcaBoolean], []],
    ],
    [
      ['Frequency1', [OcaFloat32], 4, 1, False, False, None],
      ['Frequency2', [OcaFloat32], 4, 2, False, False, None],
      ['Level', [OcaFloat32], 4, 3, False, False, None],
      ['Waveform', [OcaWaveformType], 4, 4, False, False, None],
      ['SweepType', [OcaSweepType], 4, 5, False, False, None],
      ['SweepTime', [OcaFloat32], 4, 6, False, False, None],
      ['SweepRepeat', [OcaBoolean], 4, 7, False, False, None],
      ['Generating', [OcaBoolean], 4, 8, False, False, None],
    ],
    []
)

# Gets the value of the Frequency1 property. The return value indicates whether
# the property was successfully retrieved.
# The return values of this method are
#
# - frequency of type ``int``
# - minFrequency of type ``int``
# - maxFrequency of type ``int``
#
# @method OcaSignalGenerator#GetFrequency1
# @returns {Promise<Arguments[int,int,int]>}
# Sets the value of the Frequency1 property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetFrequency1
# @param {int} frequency
#
# @returns {Promise<None>}
# Gets the value of the Frequency2 property. The return value indicates whether
# the property was successfully retrieved.
# The return values of this method are
#
# - frequency of type ``int``
# - minFrequency of type ``int``
# - maxFrequency of type ``int``
#
# @method OcaSignalGenerator#GetFrequency2
# @returns {Promise<Arguments[int,int,int]>}
# Sets the value of the Frequency2 property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetFrequency2
# @param {int} frequency
#
# @returns {Promise<None>}
# Gets the value of the Level property. The return value indicates whether the
# property was successfully retrieved.
# The return values of this method are
#
# - Level of type ``int``
# - minLevel of type ``int``
# - maxLevel of type ``int``
#
# @method OcaSignalGenerator#GetLevel
# @returns {Promise<Arguments[int,int,int]>}
# Sets the value of the Level property. The return value indicates whether the
# property was successfully set.
#
# @method OcaSignalGenerator#SetLevel
# @param {int} Level
#
# @returns {Promise<None>}
# Gets the value of the Waveform property. The return value indicates whether
# the property was successfully retrieved.
#
# @method OcaSignalGenerator#GetWaveform
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Sets the value of the Waveform property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetWaveform
# @param {int} waveform
#
# @returns {Promise<None>}
# Gets the value of the SweepType property. The return value indicates whether
# the property was successfully retrieved.
#
# @method OcaSignalGenerator#GetSweepType
# @returns {Promise<int>}
#   A promise which resolves to a single value of type ``int``.
# Sets the value of the SweepType property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetSweepType
# @param {int} sweepType
#
# @returns {Promise<None>}
# Gets the value of the SweepTime property. The return value indicates whether
# the property was successfully retrieved.
# The return values of this method are
#
# - sweepTime of type ``int``
# - minSweepTime of type ``int``
# - maxSweepTime of type ``int``
#
# @method OcaSignalGenerator#GetSweepTime
# @returns {Promise<Arguments[int,int,int]>}
# Sets the value of the SweepTime property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetSweepTime
# @param {int} sweepTime
#
# @returns {Promise<None>}
# Gets the value of the SweepRepeat property. The return value indicates whether
# the property was successfully retrieved.
#
# @method OcaSignalGenerator#GetSweepRepeat
# @returns {Promise<bool>}
#   A promise which resolves to a single value of type ``bool``.
# Sets the value of the SweepRepeat property. The return value indicates whether
# the property was successfully set.
#
# @method OcaSignalGenerator#SetSweepRepeat
# @param {bool} sweepRepeat
#
# @returns {Promise<None>}
# Gets the value of the Generating property. The return value indicates whether
# the property was successfully retrieved.
#
# @method OcaSignalGenerator#GetGenerating
# @returns {Promise<bool>}
#   A promise which resolves to a single value of type ``bool``.
# Starts the signal generator. The return value indicates whether the signal
# generator was successfully started.
#
# @method OcaSignalGenerator#Start
# @returns {Promise<None>}
# Stops the signal generator. The return value indicates whether the signal
# generator was successfully stopped.
#
# @method OcaSignalGenerator#Stop
# @returns {Promise<None>}
# Sets some or all signal generation parameters. The return value indicates if
# the parameters were successfully set. The action of this method is atomic - if
# any of the value changes fails, none of the changes are made.
#
# @method OcaSignalGenerator#SetMultiple
# @param {int} Mask
# @param {int} Frequency1
# @param {int} Frequency2
# @param {int} Level
# @param {int} Waveform
# @param {int} SweepType
# @param {int} SweepTime
# @param {bool} SweepRepeat
#
# @returns {Promise<None>}
# This event is emitted when the property ``Frequency1`` changes in the remote object.
# The property ``Frequency1`` is described in the AES70 standard as follows.
# Center frequency or sweep start frequency.
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnFrequency1Changed
# This event is emitted when the property ``Frequency2`` changes in the remote object.
# The property ``Frequency2`` is described in the AES70 standard as follows.
# Sweep end frequency.
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnFrequency2Changed
# This event is emitted when the property ``Level`` changes in the remote object.
# The property ``Level`` is described in the AES70 standard as follows.
# Output level in dB relative to device-defined zero level.
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnLevelChanged
# This event is emitted when the property ``Waveform`` changes in the remote object.
# The property ``Waveform`` is described in the AES70 standard as follows.
# The waveform type this generator generates (e.g. sine, square, noise, etc.).
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnWaveformChanged
# This event is emitted when the property ``SweepType`` changes in the remote object.
# The property ``SweepType`` is described in the AES70 standard as follows.
# The sweep type of the signal generator: None for no sweep, linear or
# logarithmic if sweep is generated.
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnSweepTypeChanged
# This event is emitted when the property ``SweepTime`` changes in the remote object.
# The property ``SweepTime`` is described in the AES70 standard as follows.
# Duration of sweep in seconds.
#
# @member {PropertyEvent<int>} OcaSignalGenerator#OnSweepTimeChanged
# This event is emitted when the property ``SweepRepeat`` changes in the remote object.
# The property ``SweepRepeat`` is described in the AES70 standard as follows.
# Indicates whether the sweep is repeated (true) or is one-shot (false).
#
# @member {PropertyEvent<bool>} OcaSignalGenerator#OnSweepRepeatChanged
# This event is emitted when the property ``Generating`` changes in the remote object.
# The property ``Generating`` is described in the AES70 standard as follows.
# Read-only property that indicates whether the generator is producing output
# (true) or not (false).
#
# @member {PropertyEvent<bool>} OcaSignalGenerator#OnGeneratingChanged
