/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.servlet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

class CaudiumSession
implements HttpSession {
    final long creationTime;
    long lastAccessedTime;
    long previousAccessedTime;
    boolean isNew;
    boolean invalidated;
    int maxInactiveInterval;
    Hashtable attributes;
    private static final IDGenerator generator = new IDGenerator();
    final String id;

    CaudiumSession() {
        this.previousAccessedTime = this.lastAccessedTime = (this.creationTime = System.currentTimeMillis());
        this.isNew = true;
        this.invalidated = false;
        this.maxInactiveInterval = 3600;
        this.attributes = new Hashtable();
        this.id = generator.generate();
    }

    public long getCreationTime() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.previousAccessedTime;
    }

    public boolean isInvalidOrExpired(long l) {
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        return this.invalidated || this.maxInactiveInterval >= 0 && (l - this.lastAccessedTime) / 1000L >= (long)this.maxInactiveInterval;
    }

    boolean access() {
        if (this.invalidated) {
            return false;
        }
        this.previousAccessedTime = this.lastAccessedTime;
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.maxInactiveInterval >= 0 && (this.lastAccessedTime - this.previousAccessedTime) / 1000L >= (long)this.maxInactiveInterval) {
            return false;
        }
        this.isNew = false;
        return true;
    }

    public boolean isNew() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.isNew;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }

    public synchronized void invalidate() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        this.invalidated = true;
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.attributes.get(string);
            if (v == null || !(v instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
        this.attributes.clear();
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public String[] getValueNames() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        Set set = this.attributes.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public synchronized Object getAttribute(String string) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        return this.attributes.keys();
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        Object v = this.attributes.get(string);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
        this.attributes.put(string, object);
        if (v != null && v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public void removeAttribute(String string) {
        if (this.invalidated) {
            throw new IllegalStateException();
        }
        Object v = this.attributes.get(string);
        this.attributes.remove(string);
        if (v != null && v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    static class IDGenerator {
        String base = "";
        int seq = 0;

        synchronized String generate() {
            return this.base + this.seq++;
        }

        IDGenerator() {
            try {
                this.base = this.base + InetAddress.getLocalHost().getHostAddress() + ":";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this.base = this.base + System.currentTimeMillis() + ":";
        }
    }
}

