/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.servlet;

class HeaderTokenizer {
    String header;
    int pos;
    int len;

    protected final void skipComment() {
        int n = 0;
        while (this.pos < this.len) {
            switch (this.header.charAt(this.pos)) {
                case '(': {
                    ++n;
                    break;
                }
                case ')': {
                    if (--n != 0) break;
                    return;
                }
                case '\\': {
                    if (this.pos + 1 >= this.len) break;
                    ++this.pos;
                }
            }
            ++this.pos;
        }
    }

    protected final void skipWS() {
        while (true) {
            if (this.pos < this.len && this.header.charAt(this.pos) <= ' ') {
                ++this.pos;
                continue;
            }
            if (this.pos >= this.len || this.header.charAt(this.pos) != '(') break;
            this.skipComment();
        }
    }

    public boolean lookingAt(char c) {
        this.skipWS();
        return this.pos < this.len && this.header.charAt(this.pos) == c;
    }

    public void discard(char c) {
        if (!this.lookingAt(c)) {
            throw new IllegalArgumentException("header: " + this.header);
        }
        ++this.pos;
    }

    protected static final boolean badTokenChar(char c) {
        return c <= ' ' || c == '\u007f' || c == '(' || c == ')' || c == '[' || c == ']' || c == '\"' || c == ',' || c == '\\' || c == '/' || c == '{' || c == '}' || c >= ':' && c <= '@';
    }

    public String getToken() {
        this.skipWS();
        int n = this.pos;
        while (this.pos < this.len && !HeaderTokenizer.badTokenChar(this.header.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos == n) {
            throw new IllegalArgumentException("header: " + this.header);
        }
        return this.header.substring(n, this.pos).toLowerCase();
    }

    public String getValue() {
        if (!this.lookingAt('\"')) {
            return this.getToken();
        }
        int n = ++this.pos;
        while (this.pos < this.len && this.header.charAt(this.pos) != '\"') {
            if (this.header.charAt(this.pos) == '\\') {
                this.pos += 2;
                continue;
            }
            ++this.pos;
        }
        if (this.pos >= this.len) {
            throw new IllegalArgumentException("header: " + this.header);
        }
        String string = this.header.substring(n, this.pos++);
        n = 0;
        while ((n = string.indexOf(92, n)) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            ++n;
        }
        return string;
    }

    public boolean more() {
        this.skipWS();
        return this.pos < this.len;
    }

    public HeaderTokenizer(String string) {
        this.header = string;
        this.pos = 0;
        this.len = string.length();
    }
}

