/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.ServletEngine;
import org.apache.tomcat.util.log.Log;

public class JspServlet
extends HttpServlet {
    Log loghelper = Log.getLog((String)"JASPER_LOG", (String)"JspServlet");
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected JasperLoader loader;
    protected Options options;
    protected ClassLoader parentClassLoader;
    protected ServletEngine engine;
    protected String serverInfo;
    private final boolean insecure_TMI = false;
    static boolean firstTime = true;
    static boolean jdk12 = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        this.options = new EmbededServletOptions(config, this.context);
        this.parentClassLoader = (ClassLoader)this.context.getAttribute("org.apache.tomcat.classloader");
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        if (this.loader == null) {
            if (jdk12) {
                try {
                    Class<?> ld = Class.forName("org.apache.jasper.servlet.JasperLoader12");
                    this.loader = (JasperLoader)ld.newInstance();
                }
                catch (Throwable t) {
                    this.loghelper.log("Loading org.apache.jasper.servlet.JasperLoader12", t);
                }
            }
            if (this.loader == null) {
                this.loader = new JasperLoader();
            }
            this.loader.setParentClassLoader(this.parentClassLoader);
            this.loader.setOptions(this.options);
            Object pd = this.context.getAttribute("org.apache.tomcat.protection_domain");
            this.loader.setProtectionDomain(pd);
        }
        if (firstTime) {
            firstTime = false;
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setDefaultFactory(new JspFactoryImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = null;
        Hashtable hashtable = this.jsps;
        synchronized (hashtable) {
            wrapper = (JspServletWrapper)this.jsps.get(jspUri);
            if (wrapper == null) {
                wrapper = new JspServletWrapper(jspUri, isErrorPage);
                this.jsps.put(jspUri, wrapper);
            }
        }
        wrapper.service(request, response, precompile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean preCompile(HttpServletRequest request) throws ServletException {
        boolean precompile = false;
        String precom = null;
        String qString = request.getQueryString();
        if (qString != null && qString.indexOf("jsp_precompile") >= 0) {
            precom = request.getParameter("jsp_precompile");
        }
        if (precom != null) {
            if (precom.equals("true")) {
                return true;
            }
            if (!precom.equals("false")) throw new ServletException("Can't have request parameter jsp_precompile set to " + precom);
            return false;
        }
        if (qString == null) return precompile;
        if (qString.startsWith("jsp_precompile")) return true;
        if (qString.indexOf("&jsp_precompile") == -1) return precompile;
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            boolean precompile = this.preCompile(request);
            Log jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.getLevel() >= 3) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
                jasperLog.log("\t  Request Params: ");
                if (!precompile && request.getMethod().equals("POST")) {
                    jasperLog.log("Parameters not read because method is POST");
                } else {
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        jasperLog.log("\t\t " + name + " = " + request.getParameter(name));
                    }
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    boolean loadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        return this.loader.loadJSP(this, jspUri, classpath, isErrorPage, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doLoadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        boolean outDated;
        block14: {
            JspServletWrapper jsw = (JspServletWrapper)this.jsps.get(jspUri);
            if (jsw == null) {
                throw new JasperException("Can't happen - JspServletWrapper=null");
            }
            JspEngineContext ctxt = new JspEngineContext(this.loader, classpath, this.context, jspUri, isErrorPage, this.options, req, res);
            outDated = false;
            Compiler compiler = null;
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                compiler = ctxt.createCompiler();
            }
            try {
                outDated = compiler.isOutDated();
                if (jsw.isInstantiated() && !outDated) break block14;
                jspServletWrapper = jsw;
                synchronized (jspServletWrapper) {
                    outDated = compiler.compile();
                    if (!jsw.isInstantiated() || outDated) {
                        if (null == ctxt.getServletClassName()) {
                            compiler.computeServletClassName();
                        }
                        jsw.instantiateServlet(this.loader.loadClass(ctxt.getFullClassName()));
                    }
                }
            }
            catch (FileNotFoundException ex) {
                compiler.removeGeneratedFiles();
                throw ex;
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString("jsp.error.unable.compile"), ex);
            }
        }
        return outDated;
    }

    public boolean isOutDated(File jsp, JspCompilationContext ctxt, Mangler mangler) {
        File jspReal = null;
        jspReal = new File(ctxt.getRealPath(jsp.getPath()));
        File classFile = new File(mangler.getClassFileName());
        boolean outDated = classFile.exists() ? classFile.lastModified() < jspReal.lastModified() : true;
        return outDated;
    }

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            jdk12 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class JspServletWrapper {
        JspCountedServlet theServlet;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }

        public synchronized void instantiateServlet(Class servletClass) throws JasperException, ServletException {
            try {
                Servlet servlet;
                this.servletClass = servletClass;
                if (this.theServlet != null) {
                    this.theServlet.destroy();
                }
                if ((servlet = (Servlet)servletClass.newInstance()) instanceof HttpJspBase) {
                    ((HttpJspBase)servlet).setClassLoader(JspServlet.this.parentClassLoader);
                }
                this.theServlet = new JspCountedServlet(servlet);
                this.theServlet.init(JspServlet.this.config);
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
        }

        public synchronized Servlet getServlet() {
            return this.theServlet;
        }

        public synchronized boolean isInstantiated() {
            return this.theServlet != null;
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp = (String)JspServlet.this.context.getAttribute("org.apache.tomcat.jsp_classpath");
            if (cp == null || cp.equals("")) {
                accordingto = "according to the init parameter";
                cp = JspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{accordingto, cp == null ? "" : cp}, 3);
            JspServlet.this.loadJSP(this.jspUri, cp, this.isErrorPage, req, res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            block9: {
                Servlet servlet = null;
                try {
                    this.loadIfNecessary(request, response);
                    servlet = this.getServlet();
                    if (precompile) {
                        return;
                    }
                    if (servlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            servlet.service(request, response);
                            break block9;
                        }
                    }
                    servlet.service(request, response);
                }
                catch (FileNotFoundException ex) {
                    try {
                        response.sendError(404, Constants.getString("jsp.error.file.not.found", new Object[0]));
                    }
                    catch (IllegalStateException ise) {
                        Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found.TMI", new Object[]{ex.getMessage()}), (Throwable)ex, 1);
                        throw new FileNotFoundException(Constants.getString("jsp.error.file.not.found", new Object[0]));
                    }
                    return;
                }
            }
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }
    }

    class JspCountedServlet
    extends HttpServlet {
        private Servlet servlet = null;
        private int threadCount = 0;
        private boolean destroyed = false;

        public JspCountedServlet(Servlet servlet) {
            this.servlet = servlet;
        }

        public void init(ServletConfig config) throws ServletException, JasperException {
            try {
                this.servlet.init(config);
            }
            catch (NullPointerException e) {
                throw new JasperException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, JasperException {
            block9: {
                try {
                    this.incrementCount();
                    if (this.servlet instanceof SingleThreadModel) {
                        Servlet servlet = this.servlet;
                        synchronized (servlet) {
                            this.servlet.service(req, res);
                            break block9;
                        }
                    }
                    this.servlet.service(req, res);
                }
                catch (NullPointerException e) {
                    throw new JasperException(e);
                }
                finally {
                    this.decrementCount();
                }
            }
        }

        public void destroy() {
            this.destroyed = true;
            if (this.getCount() == 0) {
                this.doDestroy();
            }
        }

        private void doDestroy() {
            try {
                this.servlet.destroy();
                this.servlet = null;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private synchronized void incrementCount() {
            ++this.threadCount;
        }

        private synchronized void decrementCount() {
            if (this.threadCount <= 0) {
                Constants.message("jsp.error.badcount", 1);
                return;
            }
            --this.threadCount;
            if (this.threadCount == 0 && this.destroyed) {
                this.doDestroy();
            }
        }

        private synchronized int getCount() {
            return this.threadCount;
        }
    }
}

