import Tools.Logging;

object app;
string model_id;

int overwrite = 0;
int verified;

protected object context;
protected object ddm;
protected object dim;
protected string ddmloc;
protected string dimloc;

string ddc = 
#"// auto-generated by Fins.AdminTools.ModelBuilder for table %{table}.
inherit Fins.Model.DataObject;

string table_name = \"%{table}\";
string instance_name = \"%{objname}\";

void post_define(Fins.Model.DataModelContext context)
{
  // Add any post configuration logic here
  // set_alternate_key(\"myalternatekey\");
}
";
    
string dic = 
#"// auto-generated by Fins.AdminTools.ModelBuilder.
inherit Fins.Model.DirectAccessInstance;
string context_name = \"%{model_id}\";
string type_name = \"%{objname}\";
";


protected void create(object _app, string _model_id)
{
  app = _app;
  model_id = _model_id;
}

void set_overwrite(int o)
{
  overwrite = o;
}

int verify()
{
  if(!app->model) 
  {
	Log.error("You cannot run ModelBuilder without a model.");
	Log.error("Please add a model section to your configuration");
	Log.error("and specify a database to use.");
	return 1;
  }

  context = Fins.Model.get_context(model_id); 

  if(!context->repository->get_model_module())
  {
	Log.error("No datatype definition module specified.");
	return 1;	
  }
  else
    ddm = context->repository->get_model_module();

  if(!context->repository->get_object_module())
  {
	Log.warn("No datatype instance module specified, so we won't work with that.");
//	return 1;	
  }
  else
    dim = context->repository->get_object_module();

  Log.debug("Model is connected to " + context->sql_url + ".");
  Log.debug("Checking Model module directories.");

  // okay, first, let's see if the two modules are directories.
  ddmloc = Fins.Util.get_path_for_module(ddm);
  if(!ddmloc || !file_stat(ddmloc)->isdir || (ddmloc/"/")[-1] == "module.pmod")
  {
	Log.error("Datatype definition module is not a directory. We can't continue.");
    return 1;
  }
  else Log.debug("Datatype definition classes will be stored in " + ddmloc);

  if(dim)
  {
    dimloc = Fins.Util.get_path_for_module(dim);
    if(!ddmloc || !file_stat(ddmloc)->isdir || (ddmloc/"/")[-1] == "module.pmod")
    {
	  Log.error("Datatype instance module is not a directory. We can't continue.");
      return 1;
    }
    else Log.debug("Datatype instance classes will be stored in " + dimloc);
  }

  verified = 1;

  return 0;
}


//! adds new model object stubs for a given table.
//!
//! @returns
//!  0 on success, 1 on failure.
int add(array tables_to_add)
{
  int errorout;

  foreach(tables_to_add; int i; string t)
  {
    array x = context->sql->list_tables(t);
    if(!sizeof(x))
    {
	  Log.error("Table \"" + t + "\" does not exist.");
      errorout++;	
    }
  }

  if(errorout)
  {
	Log.error("Aborting due to missing tables.");
	return 1;
  }

  Log.debug("Model ID is " + model_id + ". If you change this, things will break!");

  foreach(tables_to_add; int i; string t)
  {
  // first, we figure out what the object should be called.
    string objname = map_table_to_type(t);

    Log.info("Creating objects for data type " + objname + ", sourced from table " + t + ".");

    mapping params = (["model_id": model_id, "table": t, "objname": objname]);

    string fn = combine_path(ddmloc, objname + ".pike");
    if(file_stat(fn) && !overwrite)
      Log.warn("file " + fn + " already exists... skipping.");
    else
    {
      Stdio.write_file(fn, Tools.String.NamedSprintf()->named_sprintf(ddc, params));
      Log.info("Wrote new data definition class " + fn + ".");
    }
	fn = combine_path(dimloc, objname + ".pike");
    if(file_stat(fn) && !overwrite)
      Log.warn("file " + fn + " already exists... skipping.");
	else
    {
      Stdio.write_file(fn, Tools.String.NamedSprintf()->named_sprintf(dic, params));
      Log.info("Wrote new data instance class " + fn + ".");
    }
  }

  return 0;
}

//!
int has_id(string table)
{
  int haveid = 0;

  if(!verified)
  {
    Tools.throw(Error.Generic, "ModelBuilder cannot run before calling verify()");
  }

  array f = context->sql->list_fields(table, "id");
  foreach(f;; mapping field)
  {
    if(field->name == "id") haveid++;
  }
  return haveid;
}

array scan()
{
  array t;
  array ta = ({});

  if(!verified)
  {
    Tools.throw(Error.Generic, "ModelBuilder cannot run before calling verify()");
  }

  t = context->sql->list_tables();

  foreach(t;;string table)
  {
    array components = table / "_";

    if(sizeof(components) == 1)
    {
      if(has_id(table))
        ta += ({ table });
      else
        Log.debug("Table " + table + " has no id field. Skipping.");
    }

    else
    {
      array joinedtables = ({});
      // search for the two possibly joined tables.
      foreach(t;; string pt)
      {
        if(search(table, pt) != -1)
        {
          // TODO: standardize this method similar to map_table_to_type().
          // found one possible part, see if it has a properly formatted id field.
          string fn = lower_case(Tools.Language.Inflect.singularize(pt)) + "_id";
          array jf = context->sql->list_fields(table, fn);
          int foundit;
          foreach(jf;; mapping jfd) if(jfd->name == fn) foundit++;
          if(foundit)
            joinedtables += ({ pt });
        }
      }

      // if, after searching all of the tables, we find 2 tables 
      // referenced, it's a join-table, and we can ignore it. otherwise,
      // we should ask.
      if(sizeof(joinedtables) != 2 && !has_id(table))
      {
        Log.info("*** We found a table, " + table + ", that looks like it might ");
        Log.info("    be a join-table between two other types. ");
        Log.info("    However, it doesn't seem to have the right fields in it ");
        Log.info("    for its name, or its referenced tables are missing.");
        Log.info("    If this assumption is incorrect, you can fix the schema to resolve the problem");
        Log.info("    and rerun the scan.");
      }
      else if(has_id(table))
      {
        Log.info("*** We found a table, " + table + ", that looks like it might ");
        Log.info("    be a join-table between two other types. ");
        Log.info("    It does have a correct ID field, so we assume it is a type");
        Log.info("    that just happens to have an underbar in it.");
        Log.info("    If that's not correct, you can remove the generated class files ");
        Log.info("    from your application's modules directory.");
        ta+=({table});
       
      }

    }
  }

  return ta;
}

//! generates a classname from a given tablename.
string map_table_to_type(string t)
{
  string objname = Tools.Language.Inflect.singularize(t);

  if(!objname) 
  {
    Log.warn("Unable to singularize table %s: returns %O, using table name", t, objname);
    objname = t;
  }
  objname = String.capitalize(objname);
  return objname;
}
