// $Id: acef2d92f37302dde1ec3184568b76c4463ba645 $

#pike __REAL_VERSION__

//! @ignore
#if !constant (._JSON)
constant this_program_does_not_exist = 1;
#else
inherit ._JSON;
//! @endignore

//! @appears Standards.JSON module
//!
//! Tools for handling the JSON structured data format. See
//! @url{http://www.json.org/@} and RFC 4627.

//! @ignore
// Use getters and Val-> to ensure dynamic resolving in case the
// values in Val.pmod are replaced.
Val.True `->true() {return Val->true;}
Val.False `->false() {return Val->false;}
Val.Null `->null() {return Val->null;}
//! @endignore

//! @decl Val.True true
//! @decl Val.False false
//! @decl Val.Null null
//!
//! Compat aliases for the corresponding @[Val] objects. These are
//! used to represent the three JSON literals @expr{true@},
//! @expr{false@} and @expr{null@}.
//!
//! @deprecated Val.true, Val.false, Val.null

//! Error thrown when JSON decode fails.
class DecodeError {
    inherit Error.Generic;

    constant error_type = "json_decode";
    constant is_json_decode_error = 1;

    //! The string that failed to be decoded.
    string err_str;

    //! The failing position in @[err_str].
    int err_pos;

    protected void create(string err_str, int err_pos, void|string reason, void|array bt) {
	this_program::err_str = err_str;
	this_program::err_pos = err_pos;

	string pre_context = err_pos > 13 ?
	    sprintf ("...%O", err_str[err_pos - 10..err_pos - 1]) :
	    err_pos > 0 ?
	    sprintf ("%O", err_str[..err_pos - 1]) :
	    "";
	if (err_pos >= sizeof (err_str))
	  err_str = sprintf ("%s-><-", pre_context);
	else {
	  string post_context = err_pos < sizeof (err_str) - 14 ?
	    sprintf ("%O...", err_str[err_pos + 1..err_pos + 10]) :
	    err_pos + 1 < sizeof (err_str) ?
	    sprintf ("%O", err_str[err_pos + 1..]) :
	    "";
	  err_str = sprintf ("%s->[%c]<-%s",
			     pre_context, err_str[err_pos], post_context);
	}

	if (reason)
	    ::create(sprintf("Error decoding JSON at position %d %s: %s.\n",
			     err_pos, err_str, reason), bt);
	else 
	    ::create(sprintf("Error decoding JSON at position %d %s\n",
			     err_pos, err_str), bt);
    }
}

void decode_error(string err_str, int err_pos, void|string reason, void|mixed ... args) {
    if (sizeof(args)) reason = sprintf(reason, @args);
    throw(DecodeError(err_str, err_pos, reason, backtrace()[..<1]));
}

#endif	// constant (._JSON)
