
inherit Fins.FinsController;

object series;
object fonts;
object matrices;

void start()
{
  series = load_controller("series_controller");
  fonts = load_controller("font_controller");
  matrices = load_controller("matrix_controller");
}

void index(object id, object response, mixed ... args)
{
  string req = sprintf("%O", mkmapping(indices(id), values(id)));
  string con = master()->describe_object(this);
  string method = function_name(backtrace()[-1][2]);
  object v = view->get_view("internal:index");

  v->add("appname", "matrixlib");
  v->add("request", req);
  v->add("controller", con);
  v->add("method", method);

  response->set_view(v);
}
