//!
//! returns a script reference to a locally stalled copy of Dojo.
//!
string simple_macro_javascript_includes(Fins.Template.TemplateData data, mapping|void args)
{
  return 
#" 
<script src=\"/static/javascripts/dojo.js\" type=\"text/javascript\"></script> 
";
}

//!
//! args:
//!
//! id: the id of this form element, if provided, this form will be sent as part of the
//!     asyncronous request.
//! method
//!
//! url
//!
//! parameters
//!
//! update: if provided, the dom object with this id will be filled with the response from the server.
//!
//! success: if provided, should be javascript code that will be run on a successful response from the server. Javascript 
//!    variables "type", "data", and "event" will be passed. see Dojo for descriptions of these elements. 
//!
//! complete: if provided, should be javascript code that will be run on at the end of a successful response from the server.
//!
//! load: if provided, should be javascript code (not a function) that is executed on successful load of a page. if provided,
//!    this function replaces the use of update, success and complete above.
//!
//! error: same as load, except on a failure.
//!
//! begin: javascript code that will be run before the remote request is made.
//!
string simple_macro_remote_form(Fins.Template.TemplateData data, mapping|void arguments)
{


  return "<form " + (arguments->id?"id=\"" + arguments->id + "\" ":"") + "onsubmit=\"" + 
     remote_function(arguments) + "\"" 
     ">";
}

//! takes same arguments as remote_form, except argument "form" will be the id of
//!  a form to submit with the request, and argument "id" will be the id of the link
//!  element generated by this macro.
string simple_macro_remote_link(Fins.Template.TemplateData data, mapping|void arguments)
{
  string id = arguments->id;
  if(arguments->form)
    arguments->id = arguments->form;

  return "<a " + (id?"id=\"" + id + "\" ":"") + "onclick=\"" + 
     remote_function(arguments) + "\"" 
     ">";
}


string remote_function(mapping options)
{
  string f = "";
  array u = ({});

  string loadFunc = "";
  string errorFunc = "";

  if(!options->load)
  {

    if(options->success)
    {
      loadFunc += options->success;
    }

    if(options->update)
    {
      loadFunc += "var d = document.getElementById(" + stringify(options->update) + ");"
                "if(d) d.innerHTML = data.toString();";
    }
  
    if(options->complete)
    {
      loadFunc += options->complete;
    }
  }
  else
  {  
    loadFunc = options->load;
  }

  if(options->error)
  {
    errorFunc += options->error;
  }

  u += ({ "load: function(type, data, event){ " + loadFunc + "}" });
  u += ({ "error: function(type, data, event){ " + errorFunc + "}" });

  foreach(({"method", "mimetype", "url", "transport"});; string o)
  {
    if(options[o]) u += ({ o + ": " + stringify(options[o]) });
  }
 
  f = "var bindArgs = { " + (u * ",") + "};";

  

  if(options->id)
  {
    f += "var form = document.getElementById(" + stringify(options->id) + ");"
         "if(form) bindArgs.formNode = form;";
  }

  if(options->begin)
  {
    f += options->begin;
  }

  f += "var requestObj = dojo.io.bind(bindArgs);";

  f += "return false;";

  return "return function ()  { " + f + "}();";
}

string stringify(string s)
{
  return "'" + replace(s, "\"", "\\\"") + "'";
}
