inherit Monotype.Line;

	
	int hyphenation_disabled()
	{
	  if(!sizeof(elements)) // can't hyphenate an empty line...
	    return 1;
	  else return elements[-1]->hyphenation_disabled;
	}
	
	// remove a sort from the line; recalculate the justification
	object remove()
	{
	  object r;
	  if(!sizeof(elements))
	    return 0;
  	  r = elements[-1];
	//	werror("calling remove()\n");
//	   displayline = displayline[..sizeof(displayline)-2];
	   if(r->is_real_js)
	   {
		 linespaces--;
	     linelength -= (min_space_units);
	   }
	   else
	     linelength -= r->get_set_width();

	   elements = elements[0..sizeof(elements)-2];	

	   [big, little] = calculate_justification();

	   return r;
	}
	
	array calculate_justification(int|float|void mylinelength)
	{
	  float justspace;

	  justspace = calc_justspace(0, mylinelength);
	  if(!mylinelength)
 	    units = justspace;
//	werror("justspace: %f\n", justspace);
	  return low_calculate_justification(justspace);
	}

	float calc_justspace(int|void verbose, int|float|void mylinelength)
	{
	  float justspace = 0.00;

	  if(linespaces)
	  {
		// algorithm from page 14
		justspace = (((float)(lineunits)-get_line_length(mylinelength))/linespaces); // in units of set.
	  //  justspace = ((float)(lineunits-get_line_length(mylinelength))/linespaces); // in units of set.
	//	if(verbose)
	//	werror("%f = (%O - %O) / %d\n", justspace, lineunits, linelength, linespaces);
	  }

	  return justspace;
	}



  // can we add n units to the line and still meet the justification requirements?
  int can_add(float units)
  {
	return !is_overset(linelength + units);
  }

  int is_overset(float|void mylinelength)
  {
    int mbig, mlittle;
    catch {
      if(!combined_space)
        [mbig, mlittle] = calculate_justification(mylinelength);
      else
      {
        float cjs = calc_justspace(0, mylinelength);
        [mbig, mlittle] = calculate_wordspacing_code(cjs);
        //calculated_justifying_space = cjs;
      }
    };
    int overset = get_line_length(mylinelength) > lineunits ;//|| (linespaces && ((mbig*15)+mlittle)<((min_big*15)+min_little) );

    overset = overset || (linespaces && ((mbig*15)+mlittle)<((min_big*15)+min_little));
    if(overset)
    {
      werror("overset: # %d => line length: %d, units in line: %.1f, to add: %.1f, linespaces: %d, just: %d/%d min: %d/%d\n", line_number, lineunits, linelength, (float)mylinelength, linespaces, mbig, mlittle, min_big, min_little);
    }

    if(!mylinelength)
    {
      big = mbig, little = mlittle;
    }

    return overset;
  }

	int can_justify()
	{
	//	werror("linespaces: %O big: %O little: %O\n", linespaces, big, little);
	  	return(linespaces && ((big <= 15) && (big > 0))  && ((little <= 15) && (little > 0)));
	}
	