/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.mobile.app.SceneController"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.mobile.app.SceneController"] = true;
dojo.provide("dojox.mobile.app.SceneController");
dojo.experimental("dojox.mobile.app.SceneController");
dojo.require("dojox.mobile._base");

(function(){

	var app = dojox.mobile.app;

	var templates = {};

	dojo.declare("dojox.mobile.app.SceneController", dojox.mobile.View, {

		stageController: null,

		keepScrollPos: false,

		init: function(sceneName, params){
			// summary:
			//    Initializes the scene by loading the HTML template and code, if it has
			//    not already been loaded

			this.sceneName = sceneName;
			this.params = params;
			var templateUrl = app.resolveTemplate(sceneName);

			this._deferredInit = new dojo.Deferred();

			if(templates[sceneName]){
				// If the template has been cached, do not load it again.
				this._setContents(templates[sceneName]);
			}else{
				// Otherwise load the template
				dojo.xhrGet({
					url: templateUrl,
					handleAs: "text"
				}).addCallback(dojo.hitch(this, this._setContents));
			}

			return this._deferredInit;
		},

		_setContents: function(templateHtml){
			// summary:
			//    Sets the content of the View, and invokes either the loading or
			//    initialization of the scene assistant.
			templates[this.sceneName] = templateHtml;

			this.domNode.innerHTML = "<div>" + templateHtml + "</div>";

			var sceneAssistantName = "";

			var nameParts = this.sceneName.split("-");

			for(var i = 0; i < nameParts.length; i++){
				sceneAssistantName += nameParts[i].substring(0, 1).toUpperCase()
							+ nameParts[i].substring(1);
			}
			sceneAssistantName += "Assistant";
			this.sceneAssistantName = sceneAssistantName;

			var _this = this;

			dojox.mobile.app.loadResourcesForScene(this.sceneName, function(){

				console.log("All resources for ",_this.sceneName," loaded");

				var assistant;
				if(typeof(dojo.global[sceneAssistantName]) != "undefined"){
					_this._initAssistant();
				}else{
					var assistantUrl = app.resolveAssistant(_this.sceneName);

					dojo.xhrGet({
						url: assistantUrl,
						handleAs: "text"
					}).addCallback(function(text){
						try{
							dojo.eval(text);
						}catch(e){
							console.log("Error initializing code for scene " + _this.sceneName
							+ '. Please check for syntax errors');
							throw e;
						}
						_this._initAssistant();
					});
				}
			});

		},

		_initAssistant: function(){
			// summary:
			//    Initializes the scene assistant. At this point, the View is
			//    populated with the HTML template, and the scene assistant type
			//    is declared.

			console.log("Instantiating the scene assistant " + this.sceneAssistantName);

			var cls = dojo.getObject(this.sceneAssistantName);

			if(!cls){
				throw Error("Unable to resolve scene assistant "
							+ this.sceneAssistantName);
			}

			this.assistant = new cls(this.params);

			this.assistant.controller = this;
			this.assistant.domNode = this.domNode.firstChild;

			this.assistant.setup();

			this._deferredInit.callback();
		},

		query: function(selector, node){
			// summary:
			//    Queries for DOM nodes within either the node passed in as an argument
			//    or within this view.

			return dojo.query(selector, node || this.domNode)
		},

		parse: function(node){
			var widgets = this._widgets =
				dojox.mobile.parser.parse(node || this.domNode, {
					controller: this
				});

			// Tell all widgets what their controller is.
			for(var i = 0; i < widgets.length; i++){
				widgets[i].set("controller", this);
			}
		},

		getWindowSize: function(){
			// TODO, this needs cross browser testing

			return {
				w: dojo.global.innerWidth,
				h: dojo.global.innerHeight
			}
		},

		showAlertDialog: function(props){

			var size = dojo.marginBox(this.assistant.domNode);
			var dialog = new dojox.mobile.app.AlertDialog(
					dojo.mixin(props, {controller: this}));
			this.assistant.domNode.appendChild(dialog.domNode);

			console.log("Appended " , dialog.domNode, " to ", this.assistant.domNode);
			dialog.show();
		},

		popupSubMenu: function(info){
			var widget = new dojox.mobile.app.ListSelector({
				controller: this,
				destroyOnHide: true,
				onChoose: info.onChoose
			});

			this.assistant.domNode.appendChild(widget.domNode);

			widget.set("data", info.choices);
			widget.show(info.fromNode);
		}
	});

})();

}
