/*
 * Decompiled with CFR 0.152.
 */
package org.gotpike.pdt.editors;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.gotpike.pdt.editors.ColorManager;
import org.gotpike.pdt.editors.PikeDoubleClickStrategy;
import org.gotpike.pdt.editors.PikeEditor;
import org.gotpike.pdt.editors.PikePresentationReconciler;
import org.gotpike.pdt.editors.PikeReconciliationStrategy;

public class PikeConfiguration
extends SourceViewerConfiguration {
    private PikeDoubleClickStrategy doubleClickStrategy;
    private ColorManager colorManager;
    private PikeEditor editor;

    public PikeConfiguration(ColorManager colorManager, PikeEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__pike_autodoc", "__pike_comment", "__pike_cpp", "__pike_string"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new PikeDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PikePresentationReconciler reconciler = new PikePresentationReconciler(this.colorManager);
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        PikeReconciliationStrategy strategy = new PikeReconciliationStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }
}

