/*
 * Decompiled with CFR 0.152.
 */
package org.gotpike.pdt.editors;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.gotpike.pdt.editors.ColorManager;
import org.gotpike.pdt.editors.EditorConstants;
import org.gotpike.pdt.editors.IPikeColorConstants;
import org.gotpike.pdt.editors.rule.PreprocessorRule;

public class PikeDefaultScanner
extends RuleBasedScanner {
    public PikeDefaultScanner(ColorManager manager) {
        Token pikeReserved = new Token((Object)new TextAttribute(manager.getColor(IPikeColorConstants.PIKE_RESERVED)));
        Token pikeDatatype = new Token((Object)new TextAttribute(manager.getColor(IPikeColorConstants.PIKE_DATATYPE)));
        Token pikeCpp = new Token((Object)new TextAttribute(manager.getColor(IPikeColorConstants.PIKE_CPP)));
        IRule[] rules = new IRule[3];
        WordRule r = new WordRule((IWordDetector)new PikeDefaultWordDetector());
        int i = 0;
        while (i < EditorConstants.PIKE_RESERVED_KEYWORDS.length) {
            r.addWord(EditorConstants.PIKE_RESERVED_KEYWORDS[i], (IToken)pikeReserved);
            ++i;
        }
        rules[0] = r;
        r = new WordRule((IWordDetector)new PikeDefaultWordDetector());
        i = 0;
        while (i < EditorConstants.PIKE_RESERVED_DATATYPES.length) {
            r.addWord(EditorConstants.PIKE_RESERVED_DATATYPES[i], (IToken)pikeDatatype);
            ++i;
        }
        rules[1] = r;
        PreprocessorRule pr = new PreprocessorRule(new PikeDefaultWordDetector());
        int i2 = 0;
        while (i2 < EditorConstants.PIKE_RESERVED_CPP.length) {
            pr.addWord(EditorConstants.PIKE_RESERVED_CPP[i2], (IToken)pikeCpp);
            ++i2;
        }
        rules[2] = pr;
        this.setRules(rules);
    }

    static class PikeDefaultWordDetector
    implements IWordDetector {
        PikeDefaultWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c >= 'a' && c <= 'z' || c == '_';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c) || c == '_';
        }
    }
}

