/*
 * Decompiled with CFR 0.152.
 */
package org.gotpike.pdt.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class PikeDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        System.out.println("pos: " + pos);
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment(pos)) {
            this.selectWord(pos);
        }
    }

    protected boolean selectComment(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            String type = doc.getPartition(caretPos).getType();
            System.out.println("type: " + type);
            if (type == "__pike_autodoc") {
                int start = doc.getPartition(caretPos).getOffset();
                int end = start + doc.getPartition(caretPos).getLength();
                this.selectRange(start - 1, end);
                return true;
            }
            if (type == "__pike_comment") {
                int start = doc.getPartition(caretPos).getOffset();
                int end = start + doc.getPartition(caretPos).getLength();
                this.selectRange(start - 2, end);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println("error!");
            return false;
        }
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

