/*
 * Decompiled with CFR 0.152.
 */
package org.gotpike.pdt.editors;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.gotpike.pdt.editors.ColorManager;
import org.gotpike.pdt.editors.PikeConfiguration;
import org.gotpike.pdt.editors.PikeDocumentProvider;

public class PikeEditor
extends TextEditor {
    private ProjectionSupport projectionSupport;
    private ColorManager colorManager = new ColorManager();
    private ProjectionAnnotationModel annotationModel;
    private ProjectionAnnotation[] oldAnnotations;

    public PikeEditor() {
        this.setSourceViewerConfiguration(new PikeConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new PikeDocumentProvider());
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList positions) {
        ProjectionAnnotation[] annotations = new ProjectionAnnotation[positions.size()];
        HashMap newAnnotations = new HashMap();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations((Annotation[])this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }
}

