
/* Functions for rendering the navigation. */

/* The variable current is assumed to have been set to the node
 * representing the current document.
 */

/* These are all arrays of nodes. */
var module_children = [];
var class_children = [];
var enum_children = [];
var directive_children = [];
var method_children = [];
var member_children = [];
var operator_children = [];
var namespace_children = [];
var appendix_children = [];
var children = [];
var siblings = [];

function clear_children()
{
  module_children = [];
  class_children = [];
  enum_children = [];
  directive_children = [];
  method_children = [];
  operator_children = [];
  member_children = [];
  namespace_children = [];
  appendix_children = [];
  children = [];
}

function cmp_nodes(/* node */a, /* node */b)
{
  return (a.name > b.name) - (b.name > a.name);
}

function merge_node_lists(/* array(node) */old, /* array(node) */nodes)
{
  var i;
  var hash = {};
  for (i=0; i < old.length; i++) {
    var node = old[i];

    hash[node.name] = i+1;
  }
  for (i = 0; i < nodes.length; i++) {
    var node = nodes[i];
    var j = hash[node.name];
    if (j) {
      old[j-1] = node;
    } else {
      old[old.length] = node;
    }
  }
  old.sort(cmp_nodes);
  return old;
}

function add_module_children(/* array(node) */children)
{
  module_children = merge_node_lists(module_children, children);
}

function add_class_children(/* array(node) */children)
{
  class_children = merge_node_lists(class_children, children);
}

function add_enum_children(/* array(node) */children)
{
  enum_children = merge_node_lists(enum_children, children);
}

function add_directive_children(/* array(node) */children)
{
  directive_children = merge_node_lists(directive_children, children);
}

function add_method_children(/* array(node) */children)
{
  method_children = merge_node_lists(method_children, children);
}

function add_operator_children(/* array(node) */children)
{
  operator_children = merge_node_lists(operator_children, children);
}

function add_namespace_children(/* array(node) */children)
{
  namespace_children = merge_node_lists(namespace_children, children);
}

function add_appendix_children(/* array(node) */children)
{
  appendix_children = merge_node_lists(appendix_children, children);
}

function add_member_children(/* array(node) */children)
{
  member_children = merge_node_lists(member_children, children);
}

function low_end_inherit(/* array(node) */nodes)
{
  var i;
  for (i=0; i < nodes.length; i++) {
    nodes[i].inherited = 1;
  }
}

function end_inherit()
{
  low_end_inherit(module_children);
  low_end_inherit(class_children);
  low_end_inherit(enum_children);
  low_end_inherit(directive_children);
  low_end_inherit(method_children);
  low_end_inherit(operator_children);
  low_end_inherit(member_children);
  low_end_inherit(namespace_children);
  low_end_inherit(appendix_children);
}

function emit_end_inherit()
{
  document.write("<script language='javascript'>\n" +
                 "end_inherit();\n" +
                 "</script>\n");
}

function escapehtml(/* string */text)
{
  text = text.split('&').join('&amp;');
  text = text.split('<').join('&lt;');
  return text.split('>').join('&gt;');
}

function basedir(/* string */path)
{
  var i = path.lastIndexOf('/');
  if (i < 1) return '';
  return path.substring(0, i);
}

function has_prefix(/* string */prefix, /* string */other)
{
  return other.substring(0, prefix.length) == prefix;
}

function adjust_link(/* string */link)
{
  var reldir = basedir(current.link);
  var dots = '';
  while (reldir != '' && !has_prefix(link, reldir + '/')) {
    dots += '../';
    reldir = basedir(reldir);
  }
  return dots + link.substring(reldir.length);
}

function emit_load_js(/* string */link)
{
  document.write("<script language='javascript' src='" +
                 adjust_link(link) + "' >\n" +
                 "</script>\n");
}

function low_navbar(/* Document */document, /* string */heading,
                    /* array(node) */nodes, /* string */suffix)
{
  if (!nodes || !nodes.length) return;

  document.write('<br /><b>' + escapehtml(heading) + '</b>\n');

  document.write('<div style="margin-left:0.5em;">\n');
  var i;
  for (i=0; i < nodes.length; i++) {
    var n = nodes[i];
    var name = escapehtml(n.name + suffix);
    if (!n.inherited) {
      name = '<b>' + name + '</b>';
    }
    if (n.link == current.link) {
      document.write(name);
    } else {
      document.write('<a href="' + adjust_link(n.link) + '">');
      document.write(name);
      document.write('</a>');
    }
    document.write('<br />\n');
  }
  document.write('</div>\n');
}

/* Render the left navigation bar. */
function navbar(/* Document */document)
{
  document.write('<div class="sidebar">\n');
  low_navbar(document, 'Modules', module_children, '');
  low_navbar(document, 'Classes', class_children, '');
  low_navbar(document, 'Enums', enum_children, '');
  low_navbar(document, 'Directives', directive_children, '');
  low_navbar(document, 'Methods', method_children, '()');
  low_navbar(document, 'Operators', operator_children, '()');
  low_navbar(document, 'Members', member_children, '()');
  low_navbar(document, 'Namespaces', namespace_children, '::');
  low_navbar(document, 'Appendices', appendix_children, '');
  document.write('</div>\n');
}
