

object ecasound;
Stdio.File stdout = Stdio.File();
Stdio.File stdin = Stdio.File();
Stdio.File stderr = Stdio.File();
string last_reply;
string last_returntype; 

int recv = 0;
int sent = 0;

void create() {

   mapping opts = ([ "stdout" : stdout->pipe(), "stdin": stdin->pipe(), "stderr" : stderr->pipe() ]);
   ecasound = Process.create_process(({"ecasound", "-c"}), opts );
   
//   stdout->set_nonblocking();
//   stdout->set_read_callback(data_recv);

   stderr->set_nonblocking();
   stderr->set_read_callback(edata_recv);
   
   send_command("int-output-mode-wellformed");
   send_command("debug 256");
   send_command("int-set-float-to-string-precision 17");
}

void send_command(string command) {
	sent++;
	werror("sending command %d: %O\n", sent, command);
  stdin->write(command + "\n");
  read_response();
}

void read_response() {
	recv++;
	string data;
	do {
	  data = stdout->read(1024,1);
//	  werror("data: %O\n", data);
	  if(data && data != "") data_recv(recv, data);
    } while(!data || !sizeof(data));
}

void data_recv(mixed id, string data) {
 // werror("data %d: %O\n", recv, data);
 int loglevel, len;
 string msg;
 sscanf(data, "%d %d%s", loglevel, len, data);
 if(sizeof(data) && data[0] == ' ') {
	 last_returntype = data[1..1];
	 
     last_reply = data[4..4+len-1];
	 werror("last_reply: type=%s, data=%O\n", last_returntype, last_reply);

 }
 else if(sizeof(data) && has_prefix(data, "\r\n"))
 {
     last_reply = data[2..(2+len-1)];
	 werror("last_reply: %O\n", last_reply);
 }
 else
	 werror("invalid data: %O\n", data);
 
}

string last_string() {
	string lr = last_reply;
	last_reply = "";
	return lr;
}

float last_float() {
	string lr = last_reply;
	last_reply = "";
	return (float)lr;
}


void edata_recv(mixed id, string data) {

 werror("edata: " + data + "\n");
 
}
