#!/bin/sh

OS=Linux
DIST=el7
PKG=pike8.0
VER=`grep '^%define real_version' buildscripts/$PKG/$PKG.spec | cut -f 3 -d ' ' | tr 'v' ' ' | tr '\t' ' ' | sed -e 's/^[ ]*//;s/[ ]*$//'`
RELEASE=trunk
PLATFORM=x86_64
PKGSRC_REL=$RELEASE

if [ "x$VER" = "x" ] ; then
  echo "Unable to find version for pike package build. aborting."
  exit 1
else
  echo "Building a package for Pike $VER for OS $OS $DIST $RELEASE".
fi

#image for centos
IMAGE="centos-7"


SSHOPTS="-oUserKnownHostsFile=/dev/null -oStrictHostKeyChecking=no"
DATE=`date +%y%m%d%H%M`
HOST=$OS-$DIST-$RELEASE-rpmbuild-$DATE

echo preparing to build

triton create -w -N external -n $HOST $IMAGE sample-1G
sleep 40
# bootstrap and install prerequisite packages

tar czvf rpmbuild-$$-tar.gz rpmbuild  || (echo "failed to create tar. exiting" && exit 1)
scp $SSHOPTS rpmbuild-$$-tar.gz root@$HOST:/rpmbuild.tar.gz
rm rpmbuild-$$-tar.gz

ssh $SSHOPTS root@$HOST << EOFF


#  yum update -y
  yum install -y \
    mock \
    gcc gcc-c++ \
    make cmake \
    pkgconfig \
    automake autoconf \
    rpm-build \
    rpmdevtools \
    sudo \
    bzip2 \
    tar \
    ed \
    psmisc \
    screen 

    yum clean all
    
    
    useradd -m rpmbuild 
    echo "rpmbuild ALL=(ALL) NOPASSWD: ALL" > /etc/sudoers.d/rpmbuild

  useradd -U -m -s /bin/bash -d /home/pikebuild -c "pike build user" pikebuild

   cd /home/pikebuild
   tar xzvf /rpmbuild.tar.gz
EOFF

   scp $SSHOPTS buildscripts/$PKG/* root@$HOST:/home/pikebuild
   ssh  $SSHOPTS root@$HOST chown -R pikebuild /home/pikebuild

#copy setup files

ssh $SSHOPTS root@$HOST << EOFF
cd /home/pikebuild
./pkg.sh
cd /home/pikebuild/rpmbuild/RPMS/$PLATFORM
ls -l
rpm -i $PKG-$VER-1.0.$DIST.centos.$PLATFORM.rpm
pike --info 
exit

EOFF

PKGFILE=$PKG\*-$VER-1.0.$DIST.centos.$PLATFORM.rpm
DESTDIR=rpmbuild/RPMS/$PLATFORM
LOCALDESTDIR=rpms/$DIST/$PLATFORM
scp $SSHOPTS root@$HOST:/home/pikebuild/$DESTDIR/$PKGFILE .
x=`ls $PKGFILE`

if [ "x$x" != x ] ; then
echo build successful.
ls -l $PKGFILE
echo deleting build host
triton instance delete -w $HOST
else
  echo build failed. preserving host $HOST.
 exit 3
fi
mkdir -p $LOCALDESTDIR
echo moving $PKGFILE to $LOCALDESTDIR
mv $PKGFILE $LOCALDESTDIR
