#!/usr/local/bin/pike

constant my_version = "0.1";

string logfile_path = "/tmp/scriptrunner.log";
Stdio.File logfile;
int shutdown = 0;
int requests = 0;
mapping compiled_scripts = ([]);

int main(int argc, array(string) argv)
{
  int sock;

  if(logfile_path)
    logfile=Stdio.File(logfile_path, "rwac");

  Stdio.File f = Stdio.stdin.dup();
  
	for (int i = 0; i < 8; i++) {
		Thread.Thread(request_loop, f->query_fd(), i);
	}
	return (-1);
}

void request_loop(int sock, int id)
{
	object request = Public.Web.FCGI.FCGI(sock);

        do{
		request->accept();
                requests ++;
                object request_id;
                mixed e;

                e = catch {
                request_id = ((program)"RequestID")(request);

                // do we have a script file passed?
                if(request_id->misc->path_info && 
                       sizeof(request_id->misc->path_info))
                {
                   object s;
                  s = get_script(request_id->misc->path_translated, request_id);
		     log("running script\n");
                     mixed retval;
                     retval = s->parse(request_id);
                     if(!stringp(retval))
                     {
                        if(mappingp(retval))
                        {

                          if(!retval->_headers)
                            retval->_headers = ([]);
                          if(!retval->error)
                            retval->error = 200;
                          if(!retval->type)
                            retval->type = "text/html";

                          request->write("Status: %d\r\n", retval->error);
                          request->write("Content-type: %s\r\n", retval->type);

                          foreach(retval->_headers; string hname; string hvalue)
                            request->write("%s: %s\r\n", String.capitalize(hname), hvalue);

                          request->write("\r\n");

                          // TODO: don't think we can get it all in one call.
                          if(objectp(retval->data))
                            request->write(retval->data->read());
                          else if(retval->data)
                            request->write(retval->data);

                        } 
                        else error("Invalid return value from parse().\n");
                     }
                     else
                     {
                        request->write("Content-type: text/html\r\n\r\n");
                        request->write(retval);
                     }
                }
                // no, then just print info.
                else
                {
  		  request->write("Content-type: text/html\r\n\r\n");
                  request->write("<h1>Pike ScriptRunner v" + my_version + "</h1>\n");
		  request->write("Hello world, this is page (%O) request #%d generated by thread %d\n", request_id->not_query, requests, id);
                  request->write("<p><b>Pike Info:</b>\n");
                  request->write("<pre>\n%s\n</pre>\n", version());
                  request->write("<b>Request Info:</b>\n");
		  request->write("<pre>\nID: %O\n</pre>", 
                    mkmapping(indices(request_id), values(request_id)));
                }

                };

                  if(e)
                  {
                     if(objectp(e))
                       log("got an error: %s\n", e->describe());
                     else
                       log("got an error: %O\n", e);
                     request->write("Content-type: text/html\r\n\r\n");
                     request->write("an error occurred while compiling the script:\n");
                     if(objectp(e))
                       request->write("<pre>\n%s\n</pre>", e->describe()); 
                     else  
                       request->write("<pre>\n%O\n</pre>", e); 
                   request->finish();
                  }


		log("request finished\n");
                

	} while(!shutdown);
}

object get_script(string path, object id)
{
  string code;
  program p;
  Stdio.Stat stat;

  stat = file_stat(path);

  if(!stat)
    error("Script does not exist.\n");

  if((compiled_scripts[path] && compiled_scripts[path]->modified == stat->mtime)
         && !id->pragma["no-cache"])
    return compiled_scripts[path]->object;

  log("compiling file %s\n", path);

  code = Stdio.read_file(path);

  if(!code)
    error("Script is an empty file.\n");

  p = compile_string(code);
  
  mapping ent = (["object": p(), "modified": stat->mtime]);

  compiled_scripts[path] = ent;

  return ent->object;
}

void log(string t, mixed ... args)
{
  if(!logfile) return;

  if(args)
    t = sprintf(t, @args);
  logfile->write(sprintf("[%s] %s", (ctime(time())- "\n"), t));
}
