#!/usr/local/bin/pike -M.

constant my_version = "0.1";

Web.PikeServerPages.PSPCompiler compiler = Web.PikeServerPages.PSPCompiler();

string logfile_path = "/tmp/scriptrunner.log";
Stdio.File logfile;
int shutdown = 0;
int requests = 0;
mapping compiled_scripts = ([]);

int main(int argc, array(string) argv)
{
  int sock;
 
  add_constant("RequestID", .RequestID);

  if(logfile_path)
    logfile=Stdio.File(logfile_path, "rwac");

  Stdio.File f = Stdio.stdin.dup();
  
	for (int i = 0; i < 8; i++) {
		Thread.Thread(request_loop, f->query_fd(), i);
	}
	return (-1);
}

void request_loop(int sock, int id)
{
	object request = Public.Web.FCGI.FCGI(sock);

        do{
		request->accept();
                requests ++;
                object request_id;
                mixed e;

                e = catch {
                request_id = ((program)"RequestID")(request);

                // do we have a script file passed?
                if(request_id->misc->path_info && 
                       sizeof(request_id->misc->path_info))
                {
                   object|string s;
                  s = get_script(request_id->misc->path_translated, request_id);
                  if(stringp(s))
                  {
                    request->write("Content-type: text/html\r\n\r\n");
                    request->write("<h1>Compile Error</h1><pre>" + s + "</pre>");
                    request->finish(); 
                    return;
                  }
		     log("running script\n");
                     mixed retval;
                     retval = s->parse(request_id);
                     if(!stringp(retval))
                     {
                        if(mappingp(retval))
                        {

                          if(!retval->_headers)
                            retval->_headers = ([]);
                          if(!retval->error)
                            retval->error = 200;
                          if(!retval->type)
                            retval->type = "text/html";

                          request->write("Status: %d\r\n", retval->error);
                          request->write("Content-type: %s\r\n", retval->type);

                          foreach(retval->_headers; string hname; string hvalue)
                            request->write("%s: %s\r\n", String.capitalize(hname), hvalue);

                          request->write("\r\n");

                          // TODO: don't think we can get it all in one call.
                          if(objectp(retval->data))
                            request->write(retval->data->read());
                          else if(retval->data)
                            request->write(retval->data);

                        } 
                        else error("Invalid return value from parse().\n");
                     }
                     else
                     {
                        request->write("Content-type: text/html\r\n\r\n");
                        request->write(retval);
                     }
                }
                // no, then just print info.
                else
                {
  		  request->write("Content-type: text/html\r\n\r\n");
                  request->write("<h1>Pike ScriptRunner v" + my_version + "</h1>\n");
		  request->write("Hello world, this is page (%O) request #%d generated by thread %d\n", request_id->not_query, requests, id);
                  request->write("<p><b>Pike Info:</b>\n");
                  request->write("<pre>\n%s\n</pre>\n", version());
                  request->write("<b>Request Info:</b>\n");
		  request->write("<pre>\nID: %O\n</pre>", 
                    mkmapping(indices(request_id), values(request_id)));
                }

                };

                  if(e)
                  {
                     if(objectp(e))
                       log("got an error: %s\n", e->describe());
                     else
                       log("got an error: %O\n", e);
                     request->write("Content-type: text/html\r\n\r\n");
                     request->write("<h1>\n%s\n</h1>", describe_error(e)); 
                     request->write("<pre>\n%s\n</pre>", describe_backtrace(e)); 
                   request->finish();
                  }


		log("request finished\n");
                

	} while(!shutdown);
}

string|object get_script(string path, object id)
{
  string code;
  program p;
  Stdio.Stat stat;

  stat = file_stat(path);

  if(!stat)
    error("Script does not exist.\n");

  if((compiled_scripts[path] && compiled_scripts[path][0] == stat->mtime)
         && !id->pragma["no-cache"])
    return compiled_scripts[path][1];

  log("compiling file %s\n", path);

  code = Stdio.read_file(path);

  if(!code)
    error("Script is an empty file.\n");

  if(path[sizeof(path)-4..] == ".psp")
  {
     log("  compiling as a psp\n");
     code = compiler->parse_psp(code);
  }

  object er = ErrorContainer();

  master()->set_inhibit_compile_errors(er);
  catch(p = compile_string(code));
  master()->set_inhibit_compile_errors(0);
  
  if(!p) // an error must have occurred...
  {
    log("%s", er->get());
    return er->get();
  }

  array ent = ({ stat->mtime, p() });

  compiled_scripts[path] = ent;

  return ent[1];
}

void log(string t, mixed ... args)
{
  if(!logfile) return;

  if(args)
    t = sprintf(t, @args);
  logfile->write(sprintf("[%s] %s", (ctime(time())- "\n"), t));
}




//!
class LowErrorContainer
{
  string d;
  string errors="", warnings="";
  string get()
  {
    return errors;
  }

  //!
  string get_warnings()
  {
    return warnings;
  }

  //!
  void print_warnings(string prefix) {
    if(warnings && strlen(warnings))
      log(prefix+"\n"+warnings);
  }

  //!
  void got_error(string file, int line, string err, int|void is_warning)
  {
    if (file[..sizeof(d)-1] == d) {
      file = file[sizeof(d)..];
    }
    if( is_warning)
      warnings+= sprintf("%s:%s\t%s\n", file, line ? (string) line : "-", err);
    else
      errors += sprintf("%s:%s\t%s\n", file, line ? (string) line : "-", err);
  }

  //!
  void compile_error(string file, int line, string err)
  {
    got_error(file, line, "Error: " + err);
  }
 
  //!
  void compile_warning(string file, int line, string err)
  {  
    got_error(file, line, "Warning: " + err, 1);
  }
      
  //!
  void create()
  {  
    d = getcwd();
    if (sizeof(d) && (d[-1] != '/') && (d[-1] != '\\'))
      d += "/";
  }
}
    
//! @appears ErrorContainer
class ErrorContainer
{
  inherit LowErrorContainer;

  //!
  void compile_error(string file, int line, string err)
  {
//    if( sizeof(compile_error_handlers) )   
//      compile_error_handlers->compile_error( file,line, err );
//    else
      ::compile_error(file,line,err);
  }
    
  //!
  void compile_warning(string file, int line, string err)
  {   
//    if( sizeof(compile_error_handlers) )
//      compile_error_handlers->compile_warning( file,line, err );
//    else
      ::compile_warning(file,line,err);
  }
}

