/*
   wxPike - (c) 2005 Julio Csar Gzquez
   
   handcoded2.cc: 
   Wrapper functions implemented by hand for special case objects

*/
#include "wx.h"
#include "array.h"

/*
    Functions that interface with Pike needs C interfaces
*/
extern "C" {
void f_wxWindow__GetTextExtent(INT32 args);
void f_wxComboBox__create(INT32 args);
void f_wxListBox__create(INT32 args);
void f_wxChoice__create(INT32 args);
}

extern struct program* wxPoint_program;
extern struct program* wxSize_program;
extern struct program* wxFont_program;
extern struct program* wxWindow_program;
extern struct program* wxValidator_program;

void f_wxWindow__GetTextExtent(INT32 args)
{
	wxString par0;
	struct pike_string* pstr0;
	wxFont* par1 = NULL;
	struct object *obj = NULL;
	get_all_args("GetTextExtent", args, "%n.%o", &pstr0, &obj);
	
	par0 = pstr0->str;
	if(obj)
		par1 = static_cast<wxFont*>(STORAGE(obj,wxFont)->cppobject);

	pop_n_elems(args);
	int x, y, descent, externalLeading;
	static_cast<wxWindow*>(THIS->cppobject)->wxWindow::GetTextExtent(par0, &x, &y, &descent, &externalLeading, par1);
	
	push_int(x);
	push_int(y);
	push_int(descent);
	push_int(externalLeading);
	f_aggregate(4);
}

int pike_array_to_c_array(struct array* pikearr, wxString*& carr,INT32 args)
{
	int n=pikearr->size;
	carr = new wxString[n];

	for (int i=0; i<n; i++) {
		ref_push_array(pikearr);
		push_int(i);
		f_index(2);
		if (Pike_sp[-1].type!=T_STRING)
			SIMPLE_BAD_ARG_ERROR("create",5,"array(string)");
		carr[i]=Pike_sp[-1].u.string->str;
		pop_stack();
	}
	return n;
}

void f_wxComboBox__create(INT32 args)
{
	struct object* obj_parent;
	wxWindow* parent;
	int id;
	struct pike_string *str_value = NULL;
	wxString value;
	struct object* obj_pos = NULL;
	wxPoint* pos;
	struct object* obj_size = NULL;
	wxSize *size;
	struct array* arr_choices = NULL;
	int n=0;
	wxString* choices;
	long style=0;
	struct object* obj_validator = NULL;
	wxValidator* validator;
	struct pike_string* str_name = NULL;
	wxString name;
	
	get_all_args("create", args, "%o%d.%n%o%o%a%i%o%n", &obj_parent, &id, &str_value, &obj_pos, &obj_size, &arr_choices, &style, &validator, &name);
	
	parent=static_cast<wxWindow*>(STORAGE(obj_parent,wxWindow)->cppobject);
	
	if (str_value)
		value=str_value->str;
	else
		value=wxEmptyString;

	if (obj_pos)
		pos=static_cast<wxPoint*>(STORAGE(obj_pos,wxPoint)->cppobject);
	else
		pos=const_cast<wxPoint*>(&wxDefaultPosition);

	if (obj_size)
		size=static_cast<wxSize*>(STORAGE(obj_size,wxSize)->cppobject);
	else
		size=const_cast<wxSize*>(&wxDefaultSize);

	if (arr_choices)
		n=pike_array_to_c_array(arr_choices, choices, args);

	
	if (obj_validator)
		validator=static_cast<wxValidator*>(STORAGE(obj_validator,wxValidator)->cppobject);
	else
		validator=const_cast<wxValidator*>(&wxDefaultValidator);
	
	if (str_name)
		name=str_name->str;
	else
		name=wxComboBoxNameStr;
	
	pop_n_elems(args);
	static_cast<wxComboBox*>(THIS->cppobject) 
		= new wxComboBox(parent, id, value, *pos, *size, n,
		choices, style, *validator, name);
	add_ref(Pike_fp->current_object);
}

void f_wxListBox__create(INT32 args)
{
	struct object* obj_parent;
	wxWindow* parent;
	int id;
	struct object* obj_pos = NULL;
	wxPoint* pos;
	struct object* obj_size = NULL;
	wxSize *size;
	struct array* arr_choices = NULL;
	int n=0;
	wxString* choices;
	long style=0;
	struct object* obj_validator = NULL;
	wxValidator* validator;
	struct pike_string* str_name = NULL;
	wxString name;
	
	get_all_args("create", args, "%o%d.%o%o%a%i%o%n", &obj_parent, &id, &obj_pos, &obj_size, &arr_choices, &style, &validator, &name);
	
	parent=static_cast<wxWindow*>(STORAGE(obj_parent,wxWindow)->cppobject);
	
	if (obj_pos)
		pos=static_cast<wxPoint*>(STORAGE(obj_pos,wxPoint)->cppobject);
	else
		pos=const_cast<wxPoint*>(&wxDefaultPosition);

	if (obj_size)
		size=static_cast<wxSize*>(STORAGE(obj_size,wxSize)->cppobject);
	else
		size=const_cast<wxSize*>(&wxDefaultSize);

	if (arr_choices)
		n=pike_array_to_c_array(arr_choices, choices, args);
	
	if (obj_validator)
		validator=static_cast<wxValidator*>(STORAGE(obj_validator,wxValidator)->cppobject);
	else
		validator=const_cast<wxValidator*>(&wxDefaultValidator);
	
	if (str_name)
		name=str_name->str;
	else
		name=wxListBoxNameStr;
	
	pop_n_elems(args);
	static_cast<wxListBox*>(THIS->cppobject) 
		= new wxListBox(parent, id, *pos, *size, n,
		choices, style, *validator, name);
	add_ref(Pike_fp->current_object);
}

void f_wxChoice__create(INT32 args)
{
	struct object* obj_parent;
	wxWindow* parent;
	int id;
	struct object* obj_pos = NULL;
	wxPoint* pos;
	struct object* obj_size = NULL;
	wxSize *size;
	struct array* arr_choices = NULL;
	int n=0;
	wxString* choices;
	long style=0;
	struct object* obj_validator = NULL;
	wxValidator* validator;
	struct pike_string* str_name = NULL;
	wxString name;
	
	get_all_args("create", args, "%o%d.%o%o%a%i%o%n", &obj_parent, &id, &obj_pos, &obj_size, &arr_choices, &style, &validator, &name);
	
	parent=static_cast<wxWindow*>(STORAGE(obj_parent,wxWindow)->cppobject);
	
	if (obj_pos)
		pos=static_cast<wxPoint*>(STORAGE(obj_pos,wxPoint)->cppobject);
	else
		pos=const_cast<wxPoint*>(&wxDefaultPosition);

	if (obj_size)
		size=static_cast<wxSize*>(STORAGE(obj_size,wxSize)->cppobject);
	else
		size=const_cast<wxSize*>(&wxDefaultSize);

	if (arr_choices)
		n=pike_array_to_c_array(arr_choices, choices, args);
	
	if (obj_validator)
		validator=static_cast<wxValidator*>(STORAGE(obj_validator,wxValidator)->cppobject);
	else
		validator=const_cast<wxValidator*>(&wxDefaultValidator);
	
	if (str_name)
		name=str_name->str;
	else
		name=wxChoiceNameStr;
	
	pop_n_elems(args);
	static_cast<wxChoice*>(THIS->cppobject) 
		= new wxChoice(parent, id, *pos, *size, n,
		choices, style, *validator, name);
	add_ref(Pike_fp->current_object);
}
