
class MenuApp
{
	inherit wx.App;
	
	int OnInit()
	{
		MenuFrame mainMenu=MenuFrame("Main Menu",
			([ "Office":([ 
				"WordProcessor":0,
				"Spreadsheet":0]),
			"Network":0, 
			"Util":0 ]) );
		mainMenu->Show(wx.TRUE);
		SetTopWindow(mainMenu);
	}
}

class MenuFrame
{
	inherit wx.Frame;
	array(mixed) itemActions; 
	void create(string title, mapping(string:mixed) items)
	{
		::create(0,-1,title);
		
		itemActions = allocate(sizeof(items));
		
		wx.BoxSizer sizer=wx.BoxSizer(wx.VERTICAL);
		wx.BoxSizer titleSizer=wx.BoxSizer(wx.HORIZONTAL);
		SetSizer(sizer);
		sizer->AddSizer(titleSizer);
		
		wx.CheckBox stick=wx.CheckBox(this_object(), -1, "");
		titleSizer->Add(stick);
		wx.Frame aux=wx.Frame(0,-1,"Aux");
		wx.StaticText b=wx.StaticText(aux, -1, title);
		b->Reparent(this_object());
		titleSizer->Add(b);
		
		string item;
		int i=0;
		foreach (indices(items), item) {
			write(sprintf("%s:%O\n",item,items[item]));
			wx.Button b=wx.Button(this_object(), 10000+i, item);
			sizer->Add(b);
			if (_typeof(([]))<= _typeof(items[item])) {
				write("x\n");
				itemActions[i]=MenuFrame(item,items[item]);
				Connect(10000+i,wx.EVT_COMMAND_BUTTON_CLICKED,this_object()->openSubMenu);
			} else
				itemActions[i]=items[item];
			i++; 
		}
		Fit();
	}
	void openSubMenu(wx.Event ev)
	{
		//wx.Point p=ClientToScreen(button->GetPosition());
		//p->
		itemActions[ev->GetId()-10000]->Show(wx.TRUE);
	}
}

int main()
{
werror("starting\n");
	wx.implement_app(MenuApp);
werror("done\n");
return -1;
}
